/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.springsupport.transaction;

import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.QueueingException;
import jp.terasoluna.fw.batch.core.ThrowableHandler;
import jp.terasoluna.fw.batch.core.WorkQueue;
import jp.terasoluna.fw.batch.springsupport.transaction.TransactionalJobStatus;
import jp.terasoluna.fw.batch.standard.QueueProcessor;
import jp.terasoluna.fw.batch.standard.ThrowBatchSystemErrorThrowableHandler;

public class TransactionalQueueProcessor
extends QueueProcessor {
    private ThrowableHandler throwableHandler = new ThrowBatchSystemErrorThrowableHandler();

    public void process(WorkQueue workQueue, JobStatus jobStatus) {
        TransactionalJobStatus transactionalJobStatus = (TransactionalJobStatus)jobStatus;
        transactionalJobStatus.beginTransaction();
        try {
            super.process(workQueue, jobStatus);
        }
        catch (QueueingException e) {
            transactionalJobStatus.rollback();
            if (jobStatus.getJobState() == JobStatus.STATE.SUSPENDING) {
                return;
            }
            throw e;
        }
        catch (Throwable throwable) {
            this.throwableHandler.handle(null, throwable, jobStatus);
        }
        if (jobStatus.isExecuting() || jobStatus.getJobState() == JobStatus.STATE.ENDING_NORMALLY || jobStatus.isShutdownGraceful()) {
            transactionalJobStatus.commit();
        } else {
            transactionalJobStatus.rollback();
        }
        if (jobStatus.isShutdownGraceful()) {
            jobStatus.suspend();
        }
    }

    public void setThrowableHandler(ThrowableHandler throwableHandler) {
        this.throwableHandler = throwableHandler;
    }
}

