/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.springsupport.init;

import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.init.JobRequestInfo;
import jp.terasoluna.fw.batch.springsupport.init.JobExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobStarter {
    private static Log log = LogFactory.getLog(JobStarter.class);

    public static void main(String[] args) throws Throwable {
        if (log.isDebugEnabled()) {
            log.debug((Object)"START Batch");
        }
        JobStarter jobStarter = new JobStarter();
        int exitCode = jobStarter.execute(args);
        if (log.isDebugEnabled()) {
            log.debug((Object)"END Batch");
        }
        System.exit(exitCode);
    }

    protected int execute(String[] args) throws Throwable {
        int exitCode = 0;
        JobExecutor jobExecutor = new JobExecutor();
        JobStatus jobStatus = null;
        try {
            JobRequestInfo jobInfo = new JobRequestInfo(args);
            jobInfo.init();
            jobStatus = jobExecutor.execute(jobInfo);
            exitCode = jobStatus.getJobExitCode();
        }
        catch (Throwable throwable) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("Critical Error!! ");
            logStr.append(throwable.getMessage());
            log.error((Object)logStr.toString(), throwable);
            throw throwable;
        }
        finally {
            try {
                jobExecutor.destroy();
            }
            catch (Throwable throwable) {
                StringBuilder logStr = new StringBuilder();
                logStr.append("Critical Error!! ");
                logStr.append(throwable.getMessage());
                log.error((Object)logStr.toString(), throwable);
                throw throwable;
            }
        }
        return exitCode;
    }
}

