/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.core;

import java.util.LinkedHashMap;
import java.util.List;
import jp.terasoluna.fw.batch.core.BLogicException;
import jp.terasoluna.fw.batch.core.BLogicExecutor;
import jp.terasoluna.fw.batch.core.BLogicResultHandler;
import jp.terasoluna.fw.batch.core.ExceptionHandlerUtil;
import jp.terasoluna.fw.batch.core.JobException;
import jp.terasoluna.fw.batch.core.JobExceptionHandler;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.ThrowableHandler;
import jp.terasoluna.fw.batch.openapi.BLogic;
import jp.terasoluna.fw.batch.openapi.BLogicResult;
import jp.terasoluna.fw.batch.openapi.JobContext;
import jp.terasoluna.fw.batch.standard.ThrowBatchSystemErrorThrowableHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardBLogicExecutor
implements BLogicExecutor {
    private static Log log = LogFactory.getLog(StandardBLogicExecutor.class);
    private BLogicResultHandler bLogicResultHandler = null;
    private BLogic<Object, JobContext> blogic = null;
    private LinkedHashMap<JobException, JobExceptionHandler> exceptionHandlerMap = null;
    private JobExceptionHandler defaultJobExceptionHandler = null;
    private ThrowableHandler throwableHandler = new ThrowBatchSystemErrorThrowableHandler();

    @Override
    public void executeBLogic(Object blogicInputData, JobContext jobContext, JobStatus jobStatus, List<LinkedHashMap<String, Object>> batchUpdateMapList) {
        BLogicResult blogicResult = null;
        try {
            try {
                this.writeStartLog(jobStatus);
                blogicResult = this.blogic.execute(blogicInputData, jobContext);
                this.bLogicResultHandler.handle(blogicResult, blogicInputData, jobStatus, batchUpdateMapList);
                this.writeEndLog(jobStatus, blogicResult);
            }
            catch (RuntimeException e) {
                BLogicException wrappingException = new BLogicException(e, blogicInputData, blogicResult);
                JobExceptionHandler handler = ExceptionHandlerUtil.getJobExceptionHandler(wrappingException, this.exceptionHandlerMap, this.defaultJobExceptionHandler);
                try {
                    handler.handlException(jobContext, wrappingException, jobStatus);
                }
                catch (RuntimeException handlerException) {
                    log.error((Object)("[Exception in ExceptionHandler] Error JobID: " + jobStatus.getJobId()), (Throwable)handlerException);
                    jobStatus.setJobState(JobStatus.STATE.ENDING_ABNORMALLY);
                }
            }
        }
        catch (Throwable throwable) {
            this.throwableHandler.handle(jobContext, throwable, jobStatus);
        }
    }

    public void setBlogicResultHandler(BLogicResultHandler bLogicResultHandler) {
        this.bLogicResultHandler = bLogicResultHandler;
    }

    public void setBlogic(BLogic<Object, JobContext> blogic) {
        this.blogic = blogic;
    }

    public void setExceptionHandlerMap(LinkedHashMap<JobException, JobExceptionHandler> exceptionHandlerMap) {
        this.exceptionHandlerMap = exceptionHandlerMap;
    }

    public void setDefaultJobExceptionHandler(JobExceptionHandler defaultJobExceptionHandler) {
        this.defaultJobExceptionHandler = defaultJobExceptionHandler;
    }

    private void writeStartLog(JobStatus jobStatus) {
        if (log.isDebugEnabled()) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("Business logic processing START: [jobId=");
            logStr.append(jobStatus.getJobId());
            logStr.append("] [jobRequestNo=");
            logStr.append(jobStatus.getJobRequestNo());
            logStr.append("] [partitionNo=");
            logStr.append(jobStatus.getPartitionNo());
            logStr.append("] [BLogicName=");
            logStr.append(this.blogic.getClass().getSimpleName());
            logStr.append("] [JobState=");
            logStr.append((Object)jobStatus.getJobState());
            logStr.append("]");
            log.debug((Object)logStr.toString());
        }
    }

    private void writeEndLog(JobStatus jobStatus, BLogicResult blogicResult) {
        if (log.isDebugEnabled()) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("Business logic processing END: [jobId=");
            logStr.append(jobStatus.getJobId());
            logStr.append("] [jobRequestNo=");
            logStr.append(jobStatus.getJobRequestNo());
            logStr.append("] [partitionNo=");
            logStr.append(jobStatus.getPartitionNo());
            logStr.append("] [BLogicName=");
            logStr.append(this.blogic.getClass().getSimpleName());
            logStr.append("] [ResultHandler=");
            logStr.append(this.bLogicResultHandler.getClass().getSimpleName());
            logStr.append("] [ReturnCode=");
            logStr.append((Object)blogicResult.getReturnCode());
            logStr.append("] [JobExitCode=");
            logStr.append(jobStatus.getJobExitCode());
            logStr.append("] [JobState=");
            logStr.append((Object)jobStatus.getJobState());
            logStr.append("]");
            log.debug((Object)logStr.toString());
        }
    }

    public void setThrowableHandler(ThrowableHandler throwableHandler) {
        this.throwableHandler = throwableHandler;
    }
}

