/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.springsupport.transaction;

import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;

import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.openapi.JobContext;

/**
 * gUNVێWuXe[^XNXB
 * 
 */
public class TransactionalJobStatus extends JobStatus {
    
    /**
     * Z[u|CgB 
     */
    private Object savepoint = null;
    
    /**
     * gUNV}l[WB 
     */
    private PlatformTransactionManager transactionManager = null;
    
    /**
     * s̃gUNṼgUNVXe[^XB 
     */
    private TransactionStatus transactionStatus = null;
    
    /**
     * Z[u|Cggǂ̃tOB
     */
    private boolean useSavepoint = false;

    /**
     * gUNV擾ݒ肷B
     *
     */
    public void beginTransaction() {
        transactionStatus = transactionManager.getTransaction(null);
    }
    
    /**
     * gUNVR~bgB
     *
     */
    public void commit() {
        if (!transactionStatus.isCompleted()) {
            transactionManager.commit(transactionStatus);
            savepoint = null;
            incrementCommitCount();
        }
    }

    /**
     * qWu󋵂擾B
     * 
     * @param jobContext WuReLXg
     * @return qWu
     */
    public JobStatus getChild(JobContext jobContext) {
        TransactionalJobStatus childJobStatus = new TransactionalJobStatus();
        childJobStatus.setTransactionManager(this.transactionManager);
        childJobStatus.setUseSavepoint(this.useSavepoint);
        resetChildData(childJobStatus, jobContext);
        return childJobStatus;    
    }

    /**
     * gUNV}l[W擾B
     * 
     * @return gUNV}l[W
     */
    protected PlatformTransactionManager getTransactionManager() {
        return transactionManager;
    }

    /**
     * Z[u|Cg쐬Ăꍇɂ͉AVɃZ[u|Cg쐬
     * B 
     *
     */
    public void releaseAndCreateSavepoint() {
        if (!useSavepoint) {
            return;
        }
        
        if (savepoint != null) {
            transactionStatus.releaseSavepoint(savepoint);
        }
    
        // Z[u|Cg̍쐬
        savepoint = transactionStatus.createSavepoint();
    }

    /**
     * gUNV[obNB
     *
     */
    public void rollback() {
        if (!transactionStatus.isCompleted() && useSavepoint 
                && savepoint != null) {
            // Z[u|Cg܂ł̃[obN
            transactionStatus.rollbackToSavepoint(savepoint);
        } else if (!transactionStatus.isCompleted()) {
            transactionManager.rollback(transactionStatus);
        }
    }

    /**
     * Z[u|Cg܂ŃgUNV[obNB
     *
     */
    public void rollbackToSavepoint() {
        if (!useSavepoint) {
            return;
        }

        if (!transactionStatus.isCompleted() && savepoint != null) {
            // Z[u|Cg܂ł̃[obN
            transactionStatus.rollbackToSavepoint(savepoint);
        }
    }

    /**
     * gUNV}l[Wݒ肷B
     * 
     * @param transactionManager gUNV}l[W
     */
    public void setTransactionManager(
            PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    /**
     * Z[u|Cggǂݒ肷B
     * 
     * @param useSavepoint Z[u|Cggꍇɂ́A<code>true</code>
     */
    public void setUseSavepoint(boolean useSavepoint) {
        this.useSavepoint = useSavepoint;
    }

    /**
     * Z[u|CggǂԂB
     * 
     * @return Z[u|Cggꍇɂ́A<code>true</code>
     */
    public boolean useSavepoint() {
        return useSavepoint;
    }
    
}
