/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.springsupport.init;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * 񓯊ob`f[NXB
 * AsyncBatchDaemonBean.xml̐ݒeɏ]
 * 񓯊ob`f[NB
 * 
 * <ul>AsyncBatchDaemonBean.xml̐ݒe
 * <pre><code>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;
 * &lt;!DOCTYPE beans PUBLIC "-//SPRING//DTD BEAN//EN"
 *     "http://www.springframework.org/dtd/spring-beans.dtd"&gt;
 * &lt;beans&gt;
 *     &lt;!-- ===================== }l[W` ===================== --&gt;
 *     &lt;!-- 񓯊ob`Np̃}l[W --&gt;
 *     &lt;bean id="jobManager" parent="baseManager"&gt;
 *         &lt;property name="name" value="AsyncBatchDaemonManager" /&gt;
 *         &lt;property name="collector" ref="batchDaemonJobCollector" /&gt;
 *         &lt;property name="workQueueFactory"&gt;
 *             &lt;bean class="jp.terasoluna.fw.batch.standard.StandardWorkQueueFactory"&gt;
 *                 &lt;property name="workerExecutorService" ref="workerExecutorService"/&gt;
 *                 &lt;property name="queueProcessor" ref="asyncBatchDaemonQueueProcessor" /&gt;
 *                 &lt;property name="queueLength" value="10"/&gt;
 *                 &lt;property name="multiplicity" ref="multiplicity"/&gt;
 *             &lt;/bean&gt;
 *         &lt;/property&gt;
 *         &lt;!-- eWuO --&gt;
 *         &lt;property name="preProcessor" ref="parentJobPreProcessor"/&gt;
 * 
 *         &lt;!-- eWu㏈ --&gt;
 *         &lt;property name="postProcessor" ref="parentJobPostProcessor"/&gt;
 *     &lt;/bean&gt;
 * 
 *     &lt;!-- eWuO --&gt;
 *     &lt;bean id="parentJobPreProcessor" parent="transactionalSupportProcessor"&gt;
 *         &lt;property name="supportProcessor"&gt;
 *             &lt;bean parent="standardSupportProcessor"&gt;
 *                 &lt;property name="supportProcessorName" ref="parentJobPreProcessorName"/&gt;
 *             &lt;/bean&gt;
 *         &lt;/property&gt;
 *     &lt;/bean&gt;
 * 
 *     &lt;!-- eWu㏈ --&gt;
 *     &lt;bean id="parentJobPostProcessor" parent="transactionalSupportProcessor"&gt;
 *         &lt;property name="supportProcessor"&gt;
 *             &lt;bean parent="standardSupportProcessor"&gt;
 *                 &lt;property name="supportProcessorName" ref="parentJobPostProcessorName"/&gt;
 *             &lt;/bean&gt;
 *         &lt;/property&gt;
 *     &lt;/bean&gt;
 * 
 *     &lt;!-- WuReNXg --&gt;
 *     &lt;bean name="jobContext" class="jp.terasoluna.fw.batch.openapi.JobContext" /&gt;
 * 
 *     &lt;!-- ===================== L[vZbT` ===================== --&gt;
 *     &lt;bean id="asyncBatchDaemonQueueProcessor" parent="baseQueueProcessor"&gt;
 *         &lt;property name="name" value="asyncBatchDaemonQueueProcessor" /&gt;
 *         &lt;property name="worker" ref="childJobManager" /&gt;
 *     &lt;/bean&gt;
 * 
 *     &lt;!-- ob`Np[J --&gt;
 *     &lt;bean id="childJobManager" class="jp.terasoluna.fw.batch.springsupport.init.JobExecutor"&gt;
 *         &lt;constructor-arg&gt;
 *             &lt;value&gt;/common/FrameworkBean.xml,/common/dataAccessContext-batch.xml,/common/ThreadPoolContext-AsyncBatch.xml,/common/ValidationContext-AsyncBatch.xml&lt;/value&gt;
 *         &lt;/constructor-arg&gt;
 *         &lt;property name="async" value="true" /&gt;
 *         &lt;!-- eWuO --&gt;
 *         &lt;property name="preJobProcessor" ref="preJobProcessor"/&gt;
 *         &lt;!-- eWu㏈ --&gt;
 *         &lt;property name="postJobProcessor" ref="postJobProcessor"/&gt;
 *         &lt;!-- Wup[^̋؂蕶 --&gt;
 *         &lt;property name="jobParametersSplitStr" value="\\,"/&gt;
 *     &lt;/bean&gt;
 * 
 *     &lt;!-- WuO --&gt;
 *     &lt;bean id="preJobProcessor" parent="transactionalSupportProcessor"&gt;
 *         &lt;property name="supportProcessor"&gt;
 *             &lt;bean parent="standardSupportProcessor"&gt;
 *                 &lt;property name="supportProcessorName" ref="jobPreProcessorName"/&gt;
 *                 &lt;property name="supportLogicList"&gt;
 *                     &lt;list&gt;
 *                         &lt;bean class="jp.terasoluna.fw.batch.springsupport.init.AsyncJobPreLogic"&gt;
 *                             &lt;property name="jobControlTableHandler" ref="JobControlTableHandler" /&gt;
 *                         &lt;/bean&gt;
 *                     &lt;/list&gt;
 *                 &lt;/property&gt;    
 *             &lt;/bean&gt;
 *         &lt;/property&gt;
 *     &lt;/bean&gt;
 * 
 *     &lt;!-- Wu㏈ --&gt;
 *     &lt;bean id="postJobProcessor" parent="transactionalSupportProcessor"&gt;
 *         &lt;property name="supportProcessor"&gt;
 *             &lt;bean parent="standardSupportProcessor"&gt;
 *                 &lt;property name="supportProcessorName" ref="jobPostProcessorName"/&gt;
 *                 &lt;property name="supportLogicList"&gt;
 *                     &lt;list&gt;
 *                         &lt;bean class="jp.terasoluna.fw.batch.springsupport.init.AsyncJobPostLogic"&gt;
 *                             &lt;property name="jobControlTableHandler" ref="JobControlTableHandler" /&gt;
 *                         &lt;/bean&gt;
 *                     &lt;/list&gt;
 *                 &lt;/property&gt;    
 *             &lt;/bean&gt;
 *         &lt;/property&gt;
 *     &lt;/bean&gt;
 * 
 *     &lt;!-- RN^ --&gt;
 *     &lt;bean id="batchDaemonJobCollector" class="jp.terasoluna.fw.batch.init.JobRequestInfoCollector"&gt;
 *         &lt;property name="collectedDataHandlerFactory"&gt;
 *             &lt;bean class="jp.terasoluna.fw.batch.init.JobRequestInfoHandlerFactory"/&gt;
 *         &lt;/property&gt;
 *         &lt;property name="jobControlTableHandler" ref="JobControlTableHandler" /&gt;
 *         &lt;property name="intervalSeconds" value="10" /&gt;
 *         &lt;property name="refreshCount" value="20" /&gt;
 *     &lt;/bean&gt;
 *     
 * 
 *     &lt;!-- JobStatusݒ --&gt;
 *     &lt;bean id="MonitorableJobStatus" class="jp.terasoluna.fw.batch.monitor.MonitorableTransactionalJobStatus"&gt;
 *         &lt;property name="mbeanRegister" ref="MBeanRegister"/&gt;
 *         &lt;property name="transactionManager" ref="transactionManager" /&gt;
 *         &lt;property name="useSavepoint" ref="useSavepoint" /&gt;
 *         &lt;property name="partitionNo" value="-1"/&gt;
 *     &lt;/bean&gt;
 * 
 *     &lt;bean id="JobStatus" class="jp.terasoluna.fw.batch.springsupport.transaction.TransactionalJobStatus"&gt;
 *         &lt;property name="transactionManager" ref="transactionManager" /&gt;
 *         &lt;property name="useSavepoint" ref="useSavepoint" /&gt;
 *         &lt;property name="partitionNo" value="-1"/&gt;
 *     &lt;/bean&gt;
 * 
 *     &lt;!-- WuĎsH --&gt;
 *     &lt;bean id="useMonitorable" class="org.springframework.beans.factory.config.FieldRetrievingFactoryBean"&gt;
 *           &lt;property name="staticField" value="java.lang.Boolean.FALSE"/&gt;
 *     &lt;/bean&gt;
 * 
 *     &lt;!-- ===================== WuǗe[upnh ===================== --&gt;
 *     &lt;bean id="JobControlTableHandler" class="jp.terasoluna.fw.batch.init.JobControlTableHandlerImpl"&gt;
 *         &lt;property name="queryDAO" ref="queryDAO" /&gt;
 *         &lt;property name="updateDAO" ref="updateDAO" /&gt;
 *     &lt;/bean&gt;
 * 
 *     &lt;!-- ===================== Xbhv[쐬̃TCY ===================== --&gt;
 *     &lt;bean id="threadSize" class="jp.terasoluna.fw.batch.springsupport.standard.ThreadSizeFactoryBean"&gt;
 *         &lt;property name="multiplicity" ref="multiplicity"/&gt;
 *     &lt;/bean&gt;
 *     &lt;bean id="multiplicity" class="java.lang.Integer"&gt;
 *         &lt;constructor-arg&gt;
 *             &lt;value&gt;3&lt;/value&gt;
 *         &lt;/constructor-arg&gt;
 *     &lt;/bean&gt;
 *     
 * &lt;/beans&gt;
 *</code></pre>
 * </ul>
 *
 */
public class AsyncBatchDaemon {
    /**
     * ONXB
     */
    private static Log log = LogFactory.getLog(AsyncBatchDaemon.class);

    /**
     * t[[NBean`t@CB
     */
    private static final String ASYNC_BATCH_DAEMON_BEAN_DEFINITION_NAME = 
        "common/AsyncBatchDaemonBean.xml";

    /**
     * 񓯊ob`f[NpB
     */
    private static final String[] ASYNCBATCHDAEMON_START_PARAMETER = 
        {"BATCH_DAEMON", ASYNC_BATCH_DAEMON_BEAN_DEFINITION_NAME};

    /**
     * 񓯊WuNpMain\bhB
     *
     * @param args N̈igpȂj
     */
    public static void main(String[] args) {
        if (log.isDebugEnabled()) {
            log.debug("start batch daemon");
        }
        JobStarter jobStarter = new JobStarter();
        int exitCode = jobStarter.execute(ASYNCBATCHDAEMON_START_PARAMETER);

        if (log.isDebugEnabled()) {
            log.debug("end batch daemon");
        }
        System.exit(exitCode);
    }
    
}
