/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.openapi;

import java.util.LinkedHashMap;

import jp.terasoluna.fw.batch.messages.BLogicMessages;

/**
 * rWlXWbŇʂێIuWFNgB <BR>
 * rWlXWbNAWuOAWu㏈A 擪`NOAŏI`
 * N㏈
 * Rg[uCNnhł̌ʁB
 *
 */
public class BLogicResult {

    /**
     * ԋpR[hB
     */
    private ReturnCode returnCode;

    /**
     * ob`XVpMapB
     */
    private LinkedHashMap<String, Object> batchUpdateMap = null;

    /**
     * WuIR[hB
     */
    private Integer jobExitCode = null;

    /**
     * rWlXWbNŐG[pBLogicMessagesB
     */
    private BLogicMessages errors = null;

    /**
     * rWlXWbNŐ郁bZ[WpBLogicMessagesB
     */
    private BLogicMessages messages = null;

    /**
     * RXgN^B<BR>
     *
     * @param returnCode ԋpR[h
     */
    public BLogicResult(ReturnCode returnCode) {
        this.returnCode = returnCode;
    }

    /**
     * RXgN^B<BR>
     *
     * @param returnCode ԋpR[h
     * @param jobExitCode WuIR[h
     */
    public BLogicResult(ReturnCode returnCode, Integer jobExitCode) {
        this.returnCode = returnCode;
        this.jobExitCode = jobExitCode;
    }

    /**
     * RXgN^B<BR>
     *
     * @param returnCode ԋpR[h
     * @param jobExitCode WuIR[h
     * @param batchUpdateMap ob`XVXg
     */
    public BLogicResult(ReturnCode returnCode, Integer jobExitCode, 
            LinkedHashMap<String, Object> batchUpdateMap) {
        this.returnCode = returnCode;
        this.jobExitCode = jobExitCode;
        this.batchUpdateMap = batchUpdateMap;
    }

    /**
     * RXgN^B<BR>
     *  BLogicResult̃CX^X͑ʂɍ쐬邽߁A ob`XVpMap
     *  xB
     *
     * @param returnCode ԋpR[h
     * @param batchUpdateMap ob`XVXg
     */
    public BLogicResult(ReturnCode returnCode, 
            LinkedHashMap<String, Object> batchUpdateMap) {
        this.returnCode = returnCode;
        this.batchUpdateMap = batchUpdateMap;
    }

    /**
     * p[^𕶎ɐݒB
     * 
     * @return rWlXWbNʂ̕\
     */
    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("ReturnCode:");
        buffer.append(getReturnCode());
        buffer.append(" JobExitCode:");
        buffer.append(getJobExitCode());
        buffer.append(" ");
                
        return buffer.toString();
    }

    /**
     * ^[R[hԋpB
     *
     * @return ^[R[h
     */
    public ReturnCode getReturnCode() {
        return returnCode;
    }

    /**
     * ob`XVpSQLIDƃp[^ێMapԋpB
     *
     * @return SQLIDƃp[^ێMapB
     *          ob`XVpSQLIDƃp[^ݒ肳ĂȂꍇɂ 
     *          <code>null</code>
     */
    public LinkedHashMap<String, Object> getBatchUpdateMap() {
        return batchUpdateMap;
    }

    /**
     * WuIR[hԋpB
     *
     * @return WuIR[hB
     *          WuIR[hݒ肳ĂȂꍇɂ <code>null</code>
     */
    public Integer getJobExitCode() {
        return jobExitCode;
    }
    
    /**
     * rWlXWbNŐꂽAG[pBLogicMessages擾B
     *
     * @return rWlXWbNŐꂽAG[pBLogicMessages
     */
    public BLogicMessages getErrors() {
        return this.errors;
    }

    /**
     * rWlXWbNŐꂽAbZ[WpBLogicMessages擾B
     *
     * @return rWlXWbNŐꂽAbZ[WpBLogicMessages
     */
    public BLogicMessages getMessages() {
        return this.messages;
    }

    /**
     * rWlXWbNŐꂽAG[pBLogicMessagesݒ肷B
     *
     * @param paramErrors
     *            rWlXWbNŐꂽAG[pBLogicMessages
     */
    public void setErrors(BLogicMessages paramErrors) {
        this.errors = paramErrors;
    }

    /**
     * rWlXWbNŐꂽAbZ[WpBLogicMessagesݒ肷B
     *
     * @param paramMessages
     *            rWlXWbNŐꂽAbZ[WpBLogicMessages
     */
    public void setMessages(BLogicMessages paramMessages) {
        this.messages = paramMessages;
    }
}