/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.openapi;

import java.io.Serializable;
import jp.terasoluna.fw.batch.core.JobException;

public class JobContext
implements Serializable {
    private static final long serialVersionUID = 8920476023805712633L;
    protected String jobId = null;
    protected String jobRequestNo = null;
    protected String partitionKey = "NO_Partition";
    protected int partitionNo = -1;
    protected boolean restartable = false;
    protected boolean restarted = false;
    protected int restartPoint = 0;
    protected START_TYPE startType = null;
    protected String[] parameter = null;

    public JobContext getChildJobContext(Object partitionKey) {
        if (partitionKey == null || "".equals(partitionKey.toString().trim())) {
            throw new IllegalArgumentException("partitionKey is NULL or Whitespace.");
        }
        JobContext childJobContext = null;
        try {
            childJobContext = (JobContext)this.getClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new JobException(e);
        }
        catch (IllegalAccessException e) {
            throw new JobException(e);
        }
        childJobContext.setJobId(this.jobId);
        childJobContext.setJobRequestNo(this.jobRequestNo);
        childJobContext.setRestartable(this.restartable);
        childJobContext.setRestarted(this.restarted);
        childJobContext.setStartType(this.startType);
        childJobContext.setPartitionKey((String)String.class.cast(partitionKey));
        childJobContext.setParameter(this.parameter);
        return childJobContext;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getJobRequestNo() {
        return this.jobRequestNo;
    }

    public String getPartitionKey() {
        return this.partitionKey;
    }

    public int getPartitionNo() {
        return this.partitionNo;
    }

    public int getRestartPoint() {
        return this.restartPoint;
    }

    public START_TYPE getStartType() {
        return this.startType;
    }

    public String[] getParameter() {
        return this.parameter;
    }

    public boolean isRestartable() {
        return this.restartable;
    }

    public boolean isRestarted() {
        return this.restarted;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public void setJobRequestNo(String jobRequestNo) {
        this.jobRequestNo = jobRequestNo;
    }

    public void setParameter(String[] arg) {
        this.parameter = arg;
    }

    public void setPartitionNo(int partitionNo) {
        this.partitionNo = partitionNo;
    }

    public void setRestartable(boolean restartable) {
        this.restartable = restartable;
    }

    public void setRestarted(boolean restarted) {
        this.restarted = restarted;
    }

    public void setRestartPoint(int restartPoint) {
        this.restartPoint = restartPoint;
    }

    public void setStartType(START_TYPE startType) {
        this.startType = startType;
    }

    public void setPartitionKey(String partitionKey) {
        this.partitionKey = partitionKey;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum START_TYPE {
        ASYNC,
        SYNC;

    }
}

