/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.file.dao.standard;

import java.util.Map;
import jp.terasoluna.fw.file.annotation.FileFormat;
import jp.terasoluna.fw.file.dao.FileException;
import jp.terasoluna.fw.file.dao.standard.AbstractFileLineWriter;
import jp.terasoluna.fw.file.dao.standard.ColumnFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVFileLineWriter<T>
extends AbstractFileLineWriter<T> {
    private static final char DELIMITER = ',';
    private char encloseChar = '\u0000';

    public CSVFileLineWriter(String fileName, Class<T> clazz, Map<String, ColumnFormatter> columnFormatterMap) {
        super(fileName, clazz, columnFormatterMap);
        FileFormat fileFormat = clazz.getAnnotation(FileFormat.class);
        if (fileFormat.delimiter() != ',') {
            throw new FileException("Delimiter can not change.", new IllegalStateException(), fileName);
        }
        this.encloseChar = fileFormat.encloseChar();
        super.init();
    }

    @Override
    public char getDelimiter() {
        return ',';
    }

    @Override
    public char getEncloseChar() {
        return this.encloseChar;
    }
}

