/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.orm.ibatis.support;

import java.io.ByteArrayInputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.springframework.jdbc.support.lob.LobHandler;

import jp.terasoluna.utlib.UTUtil;
import jp.terasoluna.fw.orm.ibatis.support.BlobInputStreamTypeHandler;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.orm.ibatis.support.BlobInputStreamTypeHandler}
 * NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * iBATIS痘pBLOBƃXg[}bsOiBATIS̃^CvnhB
 * <p>
 * 
 * @see jp.terasoluna.fw.orm.ibatis.support.BlobInputStreamTypeHandler
 */
@SuppressWarnings("unused")
public class BlobInputStreamTypeHandlerTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(BlobInputStreamTypeHandlerTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public BlobInputStreamTypeHandlerTest(String name) {
        super(name);
    }

    /**
     * testBlobInputStreamTypeHandler01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() lobHandler:not null<br>
     *         
     * <br>
     * ҒlF(ԕω) lobHandler:lobHandlerƓlobHandler<br>
     *         
     * <br>
     * not null̏ꍇAɐݒ肷邱Ƃ̃eXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testBlobInputStreamTypeHandler01() throws Exception {
        // O
        LobHandler lob = new LobHandlerImpl01();

        // eXg{
        BlobInputStreamTypeHandler handler =
            new BlobInputStreamTypeHandler(lob);

        // 
        assertSame(lob, UTUtil.getPrivateField(handler, "lobHandler"));
    }

    /**
     * testBlobInputStreamTypeHandler02()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() lobHandler:null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalStateException<br>
     *         
     * <br>
     * null̏ꍇAIllegalStateExceptionX[邱Ƃ̃eXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testBlobInputStreamTypeHandler02() throws Exception {
        // O
        LobHandler lob = null;

        // eXg{
        try {
            BlobInputStreamTypeHandler handler =
                new BlobInputStreamTypeHandler(lob);
            fail();
        } catch (IllegalStateException e) {
            //             
        }
    }

    /**
     * testSetParameterInternal01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:InputStreamCX^X<br>
     *         () lobCreator.setBlobAsBinaryStream():<br>
     *         
     * <br>
     * ҒlF(߂l) void:<br>
     *         (ԕω) lobCreator.setBlobAsBinaryStream():ĂяoĂ邱ƂmF<br>
     *         
     * <br>
     * lobCreator.setBlobAsBinaryStream()sĂ邱Ƃ̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetParameterInternal01() throws Exception {
        // O
        LobHandler lob = new LobHandlerImpl01();
        
        PreparedStatement ps = null;
        int index = 0;
        // value : InputStream
        ByteArrayInputStream value = new ByteArrayInputStream("".getBytes());
        String jdbcType = null;
        // LobCreatorNX : ĂяomF
        LobCreatorImpl01 lobCreator = new LobCreatorImpl01();
        
        BlobInputStreamTypeHandler handler =
            new BlobInputStreamTypeHandler(lob);

        // eXg{
        handler.setParameterInternal(ps, index, value, jdbcType, lobCreator);

        // 
        boolean b = ((Boolean) lobCreator.isSetBlobAsBinaryStream).booleanValue();
        assertTrue(b);
        
        value.close();
    }

    /**
     * testSetParameterInternal02()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() value:InputStreamȊÕCX^X<br>
     *         
     * <br>
     * ҒlF(ԕω) O:ClassCastExceptinon<br>
     *         
     * <br>
     * ClassCastExceptionX[邱Ƃ̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetParameterInternal02() throws Exception {
        // O
        LobHandler lob = new LobHandlerImpl01();
        
        PreparedStatement ps = null;
        int index = 0;
        // value : InputStreamȊO
        String value = "";
        String jdbcType = null;
        // LobCreatorNX
        LobCreatorImpl01 lobCreator = new LobCreatorImpl01();
        
        BlobInputStreamTypeHandler handler =
            new BlobInputStreamTypeHandler(lob);

        // eXg{
        try {
            handler.setParameterInternal(ps, index, value, jdbcType, lobCreator);
            fail();
        } catch (ClassCastException e) {
            // 
        }
    }

    /**
     * testSetParameterInternal03()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() lobCreator.setBlobAsBinaryStream():SQLException<br>
     *         
     * <br>
     * ҒlF(ԕω) O:SQLException<br>
     *         
     * <br>
     * SQLExceptionX[邱Ƃ̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetParameterInternal03() throws Exception {
        // O
        LobHandler lob = new LobHandlerImpl01();
        
        PreparedStatement ps = null;
        int index = 0;
        // value : -
        Object value = null;
        String jdbcType = null;
        // LobCreatorNX : SQLException
        LobCreatorImpl02 lobCreator = new LobCreatorImpl02();
        
        BlobInputStreamTypeHandler handler =
            new BlobInputStreamTypeHandler(lob);

        // eXg{
        try {
            handler.setParameterInternal(ps, index, value, jdbcType, lobCreator);
            fail();
        } catch (SQLException e) {
            // 
        }
    }

    /**
     * testGetResultInternal01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() lobHandler.getBlobAsBinaryStream():not null<br>
     *         
     * <br>
     * ҒlF(߂l) Object:lobHandler.getBlobAsBinaryStream()̖߂lƓCX^X<br>
     *         (ԕω) lobHandler.getBlobAsBinaryStream():ĂяoĂ邱ƂmF<br>
     *         
     * <br>
     * lobHandler.getBlobAsBinaryStream()̖߂lƓCX^Xԋp邱Ƃ̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetResultInternal01() throws Exception {
        // O
        LobHandlerImpl01 lob = new LobHandlerImpl01();
        
        ResultSet ps = null;
        int index = 0;
        
        // LobHandlerNXgetBlobAsBinaryStream̃^[l : 
        // ByteArrayInputStreamCX^X
        ByteArrayInputStream bais = new ByteArrayInputStream("".getBytes());
        UTUtil.setPrivateField(lob, "is", bais);
        
        BlobInputStreamTypeHandler handler =
            new BlobInputStreamTypeHandler(lob);

        // eXg{
        ByteArrayInputStream input =
            (ByteArrayInputStream) handler.getResultInternal(ps, index, lob);

        // 
        boolean b = ((Boolean) lob.isGetBlobAsBinaryStream).booleanValue();
        assertTrue(b);
        assertSame(bais, input);
        
        bais.close();
    }

    /**
     * testGetResultInternal02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() lobHandler.getBlobAsBinaryStream():null<br>
     *         
     * <br>
     * ҒlF(߂l) Object:null<br>
     *         (ԕω) lobHandler.getBlobAsBinaryStream():ĂяoĂ邱ƂmF<br>
     *         
     * <br>
     * nullԋp邱Ƃ̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetResultInternal02() throws Exception {
        // O
        LobHandlerImpl01 lob = new LobHandlerImpl01();
        
        ResultSet ps = null;
        int index = 0;
        
        // LobHandlerNXgetBlobAsBinaryStream̃^[l : null
        ByteArrayInputStream bais = null;
        UTUtil.setPrivateField(lob, "is", bais);
        
        BlobInputStreamTypeHandler handler =
            new BlobInputStreamTypeHandler(lob);

        // eXg{
        ByteArrayInputStream input =
            (ByteArrayInputStream) handler.getResultInternal(ps, index, lob);

        // 
        boolean b = ((Boolean) lob.isGetBlobAsBinaryStream).booleanValue();
        assertTrue(b);
        assertNull(input);
    }

    /**
     * testGetResultInternal03()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() lobHandler.getBlobAsBinaryStream():SQLException<br>
     *         
     * <br>
     * ҒlF(ԕω) O:SQLException<br>
     *         
     * <br>
     * SQLExceptionX[邱Ƃ̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetResultInternal03() throws Exception {
        // O
        // getBlobAsBinaryStream : SQLException
        LobHandlerImpl02 lob = new LobHandlerImpl02();
        
        ResultSet ps = null;
        int index = 0;
        
        BlobInputStreamTypeHandler handler =
            new BlobInputStreamTypeHandler(lob);

        // eXg{
        try {
            ByteArrayInputStream input =
                (ByteArrayInputStream) handler.getResultInternal(ps, index, lob);
            fail();
        } catch (SQLException e) {
            // 
        }
    }

    /**
     * testValueOf01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() s:null<br>
     *         
     * <br>
     * ҒlF(߂l) Object:null<br>
     *         
     * <br>
     * nullԋp邱Ƃ̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testValueOf01() throws Exception {
        // O
        LobHandlerImpl01 lob = new LobHandlerImpl01();
        
        BlobInputStreamTypeHandler handler =
            new BlobInputStreamTypeHandler(lob);
        
        String s = null;

        // eXg{
        Object obj = handler.valueOf(s);

        // 
        assertNull(obj);
    }

    /**
     * testValueOf02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() s:""<br>
     *         
     * <br>
     * ҒlF(߂l) Object:new ByteArrayInputStream("".getBytes())<br>
     *         
     * <br>
     * ""Xg[̂ԋp邱Ƃ̃eXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testValueOf02() throws Exception {
        // O
        LobHandlerImpl01 lob = new LobHandlerImpl01();
        
        BlobInputStreamTypeHandler handler =
            new BlobInputStreamTypeHandler(lob);
        
        String s = "";

        // eXg{
        Object obj = handler.valueOf(s);

        // 
        assertEquals(ByteArrayInputStream.class.getName(),
                obj.getClass().getName());
        
        byte[] b1 = (byte[]) UTUtil.getPrivateField(obj, "buf");
        byte[] b2 = "".getBytes();
        for(int i=0; i<b1.length; i++) {
            assertEquals(b2[i], b1[i]);
        }
    }
    
    /**
     * testValueOf03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() s:"ABC"<br>
     *         
     * <br>
     * ҒlF(߂l) Object:new ByteArrayInputStream("ABC".getBytes())<br>
     *         
     * <br>
     * "ABC"Xg[̂ԋpbsƂ̃eXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testValueOf03() throws Exception {
        // O
        LobHandler lob = new LobHandlerImpl01();
        
        BlobInputStreamTypeHandler handler =
            new BlobInputStreamTypeHandler(lob);
        
        String s = "ABC";

        // eXg{
        Object obj = handler.valueOf(s);

        // 
        assertEquals(ByteArrayInputStream.class.getName(),
                obj.getClass().getName());
        
        byte[] b1 = (byte[]) UTUtil.getPrivateField(obj, "buf");
        byte[] b2 = "ABC".getBytes();
        for(int i=0; i<b1.length; i++) {
            assertEquals(b2[i], b1[i]);
        }
    }
}