/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.restart;

import java.util.List;

import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.SupportProcessor;
import jp.terasoluna.fw.batch.openapi.JobContext;
import jp.terasoluna.fw.batch.openapi.SupportLogic;

/**
 * WuX^[g̃Wu㏈pNXB<BR>
 * Wu㏈ɏI烊X^[g|CgNAsB
 * 
 */
public class RestartPostProcessor implements SupportProcessor {

    /**
     * WuX^[ge[unh̃CX^X
     */
    private JobRestartTableHandler jobRestartTableHandler = null;

    /**
     * Wu㏈pvZbT[
     */
    private SupportProcessor postProcessor = null;

    /**
     * T|[gWbÑXgB
     */
    private List<SupportLogic<JobContext>> supportLogicList = null;

    /**
     * X^[g|CgNApSQLL[B
     */
    private String sqlKey = null;
    
    /**
     * Root}lW[L
     */
    private boolean parentManager = false;

    /**
     * Wu㏈pvZbT[\bhB<BR>
     * Wu㏈ɏI烊X^[g|CgNAsB
     * 
     * @param jobContext
     *            WuReLXg
     * @param jobStatus
     *            Wu
     */
    public void process(JobContext jobContext, JobStatus jobStatus) {
        postProcessor.process(jobContext, jobStatus);

        //X^[g|Cg̃NAi폜j
        //WuُIĂȂ
        if (!isAbendOrSuspending(jobStatus)
                && (parentManager || (supportLogicList != null 
                && supportLogicList.size() > 0))) {
            jobRestartTableHandler.restartPointClear(jobStatus, sqlKey);
        }
    }

    /**
     * WuX^[ge[unh̃CX^Xݒ肷B
     * 
     * @param jobRestartTableHandler
     *            WuX^[ge[unh̃CX^X
     */
    public void setJobRestartTableHandler(
            JobRestartTableHandler jobRestartTableHandler) {
        this.jobRestartTableHandler = jobRestartTableHandler;
    }

    /**
     * XLbv]B
     * 
     * @return ]ʁiX^[ge[uNÁAƖIȌ㏈Ȃ
     * ꍇłXLbvȂj
     */
    public boolean canSkip() {
        // X^[ge[uNÁAƖIȌ㏈ȂꍇłXLbv
        // Ȃ
        return false;
    }

    /**
     * Wu㏈ݒ肷B
     * 
     * @param postProcessor
     *            Wu㏈
     */
    public void setPostProcessor(SupportProcessor postProcessor) {
        this.postProcessor = postProcessor;
    }

    /**
     * T|[gWbÑXgݒ肷B
     * 
     * @param supportLogicList T|[gWbÑXg
     */
    public void setSupportLogicList(
            List<SupportLogic<JobContext>> supportLogicList) {
        this.supportLogicList = supportLogicList;
    }
    
    /**
     * X^[g|CgNApSQLL[ݒ肷B
     * 
     * @param sqlKey X^[g|CgNApSQLL[
     */
    public void setSqlKey(String sqlKey) {
        this.sqlKey = sqlKey;
    }

    /**
     *  Root}lW[Lݒ肷B
     * 
     * @param parentManager Root}lW[L
     */
    public void setParentManager(boolean parentManager) {
        this.parentManager = parentManager;
    }
    
    /**
     *  JobStatus̏ԂmFB
     * 
     * @param jobStatus Wu
     * @return eAqJobStatus̏Ԓ<code>ENDING_ABNORMALLY</code>A
     * <code>SUSPENDING</code>ł<code>true</code>ԂB
     */
    private boolean isAbendOrSuspending(JobStatus jobStatus) {
        if (jobStatus.getChildJobStatusList() == null
                || jobStatus.getChildJobStatusList().isEmpty()) {

            if (jobStatus.getJobState() == JobStatus.STATE.ENDING_ABNORMALLY
                    || jobStatus.getJobState() == JobStatus.STATE.SUSPENDING) {
                return true;
            } else {
                return false;
            }
        }

        for (JobStatus childJobStatus : jobStatus.getChildJobStatusList()) {
            if (isAbendOrSuspending(childJobStatus)) {
                return true;
            }
        }
        return false;
    }
}
