/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.springsupport.init;

import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.init.JobRequestInfo;
import jp.terasoluna.fw.batch.springsupport.init.JobExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobStarter {
    private static Log log = LogFactory.getLog(JobStarter.class);

    public static void main(String[] args) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"start Batch");
        }
        JobStarter jobStarter = new JobStarter();
        int exitCode = jobStarter.execute(args);
        if (log.isDebugEnabled()) {
            log.debug((Object)"end Batch");
        }
        System.exit(exitCode);
    }

    protected int execute(String[] args) {
        int exitCode = 0;
        JobExecutor jobExecutor = new JobExecutor();
        JobStatus jobStatus = null;
        try {
            JobRequestInfo jobInfo = new JobRequestInfo(args);
            jobInfo.init();
            jobStatus = jobExecutor.execute(jobInfo);
            exitCode = jobStatus.getJobExitCode();
        }
        catch (RuntimeException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            jobExecutor.destroy();
        }
        return exitCode;
    }
}

