/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.monitor;

import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import jp.terasoluna.fw.batch.core.JobStatus;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MBeanRegister {
    private Log log = LogFactory.getLog(MBeanRegister.class);
    private int manageableJobSize = 0;
    private MBeanServer server = ManagementFactory.getPlatformMBeanServer();
    private Map<String, JobStatus> registerMBeanJobStatusMap = new ConcurrentHashMap<String, JobStatus>();
    private int mbeanCount = 0;
    private Queue<String> registerParentObjectName = new ConcurrentLinkedQueue<String>();
    private Queue<String> registerChildObjectName = new ConcurrentLinkedQueue<String>();

    public void registerMBean(JobStatus jobStatus) {
        if (jobStatus.getJobId() == null) {
            return;
        }
        try {
            String name;
            if (this.mbeanCount >= this.manageableJobSize) {
                this.unregisterMBean();
            }
            if (((ConcurrentMap)this.registerMBeanJobStatusMap).putIfAbsent(name = this.getRegistName(jobStatus), jobStatus) == null) {
                this.server.registerMBean(jobStatus, ObjectName.getInstance(name));
                ++this.mbeanCount;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(name + " register"));
            }
        }
        catch (MalformedObjectNameException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InstanceAlreadyExistsException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (AttributeNotFoundException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (MBeanException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (ReflectionException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private String getRegistName(JobStatus jobStatus) {
        StringBuilder name = new StringBuilder();
        name.append("JOB:name=");
        name.append(jobStatus.getJobId());
        if (!"".equals(jobStatus.getJobRequestNo())) {
            name.append("_");
            name.append(jobStatus.getJobRequestNo());
        }
        if (!this.registerParentObjectName.contains(name.toString())) {
            this.registerParentObjectName.add(name.toString());
        }
        if (jobStatus.getPartitionNo() != -1) {
            name.append(",name2=");
            name.append(jobStatus.getPartitionKey().replaceAll(":", ""));
            this.registerChildObjectName.add(name.toString());
        }
        return name.toString();
    }

    private void unregisterMBean() throws MalformedObjectNameException, NullPointerException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        if (this.registerMBeanJobStatusMap.isEmpty()) {
            return;
        }
        block0: while (this.mbeanCount > 0) {
            JobStatus jobStatus;
            for (String childName : this.registerChildObjectName) {
                jobStatus = this.registerMBeanJobStatusMap.get(childName);
                if (jobStatus == null || !jobStatus.getJobState().isEndStatus() || !this.deleteMBean(childName)) continue;
                this.registerChildObjectName.remove(childName);
                break block0;
            }
            for (String parentName : this.registerParentObjectName) {
                jobStatus = this.registerMBeanJobStatusMap.get(parentName);
                if (jobStatus == null || !jobStatus.getJobState().isEndStatus() || !this.deleteMBean(parentName)) continue;
                this.registerParentObjectName.remove(parentName);
                break block0;
            }
            if ((this.registerChildObjectName.isEmpty() || !this.deleteMBean(this.registerChildObjectName.poll())) && (this.registerParentObjectName.isEmpty() || !this.deleteMBean(this.registerParentObjectName.poll()))) continue;
            break;
        }
    }

    private boolean deleteMBean(String registerName) throws InstanceNotFoundException, MBeanRegistrationException, MalformedObjectNameException, NullPointerException {
        if (registerName == null) {
            return false;
        }
        ObjectName objectName = new ObjectName(registerName);
        if (this.server.isRegistered(objectName)) {
            this.server.unregisterMBean(objectName);
            --this.mbeanCount;
            this.registerMBeanJobStatusMap.remove(registerName);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(registerName + " unregister"));
            }
            return true;
        }
        return false;
    }

    public void setManageableJobSize(int manageableJobSize) {
        this.manageableJobSize = manageableJobSize;
    }
}

