/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.taglib;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;

import jp.terasoluna.fw.util.PropertyUtil;
import jp.terasoluna.fw.web.struts.form.ActionFormUtil;

import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.taglib.TagUtils;

/**
 * y[WPʂɃy[WJڂ@\B
 * <p/>
 * Struts<code>&lt;logic:iterate&gt;</code>vfɂĒ`ꂽꗗ
 * y[WJڂ̃N\B
 * ŃAJSPłΑΉꗗ̏㉺Êǂւł\邱Ƃ\łB
 * <p/>
 * y[WN@\gpꍇ́A
 * ANVtH[Ɉȉ̃tB[hpӂāA
 * ̋@\̑ɑ΂Ďw肷KvB
 * <p/>
 * <ul>
 * <li>\sێtB[h</li>
 * <li>\JnCfbNXێtB[h</li>
 * <li>ꗗSێtB[h</li>
 * </ul>
 * <br/><br/>
 * <strong>^OT|[g鑮</strong>
 * <p>y[WN@\ł́Aȉ̑T|[gB</p>
 * <div align="center">
 *  <table width="90%" border="1">
 *   <tr>
 *    <td><b></b></td>
 *    <td><b>ftHgl</b></td>
 *    <td><b>K{</b></td>
 *    <td><b>s</b></td>
 *    <td><b>Tv</b></td>
 *   </tr>
 *   <tr>
 *    <td><code>id</code></td>
 *    <td>-</td>
 *    <td><code>false</code></td>
 *    <td><code>true</code></td>
 *    <td align="left">
 *      ̑ɕ񂪎w肳ꂽꍇA
 *      y[WN̏o͐ʂł͂Ȃy[WReLXgɕۑB
 *      ͕̑ۑL[ƂȂB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td><code>action</code></td>
 *    <td>-</td>
 *    <td><code>false</code></td>
 *    <td><code>true</code></td>
 *    <td align="left">
 *      ꗗ\ʂ̕\sANVpXw肷B<br/>
 *      submitfalsȅꍇ͕K{ƂȂB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td><code>name</code></td>
 *    <td>-</td>
 *    <td><code>false</code></td>
 *    <td><code>true</code></td>
 *    <td align="left">
 *      \sAJnsCfbNXAꗗSs擾Beanw肷B
 *    </td>
 *   </tr>
 *   <tr>
 *    <td><code>rowProperty</code></td>
 *    <td>-</td>
 *    <td><code>true</code></td>
 *    <td><code>true</code></td>
 *    <td align="left">
 *      \sێtB[hw肷B
 *      namew肳ĂȂꍇ͒ڒl擾B
 *    </td>
 *   </tr>
 *   <tr>
 *    <td><code>indexProperty</code></td>
 *    <td>-</td>
 *    <td><code>true</code></td>
 *    <td><code>true</code></td>
 *    <td align="left">
 *      \JnCfbNXێtB[hw肷B
 *      namew肳ĂȂꍇ͒ڒl擾B
 *    </td>
 *   </tr>
 *   <tr>
 *    <td><code>totalProperty</code></td>
 *    <td>-</td>
 *    <td><code>true</code></td>
 *    <td><code>true</code></td>
 *    <td align="left">
 *      <code>&lt;logic:iterate&gt;</code>vfɂ
 *      `ꂽꗗ̑SsێtB[hw肷B
 *      namew肳ĂȂꍇ͒ڒl擾B
 *    </td>
 *   </tr>
 *   <tr>
 *    <td><code>scope</code></td>
 *    <td>-</td>
 *    <td><code>false</code></td>
 *    <td><code>true</code></td>
 *    <td align="left">
 *      nameŎw肵Bean擾XR[vw肷B
 *    </td>
 *   </tr>
 *   <tr>
 *    <td><code>submit</code></td>
 *    <td><code>false</code></td>
 *    <td><code>false</code></td>
 *    <td><code>true</code></td>
 *    <td align="left">
 *      Nł͂ȂATu~bgsꍇtruew肷BftHgfalseB
 *      falsȅꍇAactionK{ƂȂB
 *      ȂȂtrueɐݒ肷action͖ƂȂB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td><code>forward</code></td>
 *    <td><code>false</code></td>
 *    <td><code>false</code></td>
 *    <td><code>true</code></td>
 *    <td align="left">
 *      TERASOLUNADispatchActiongpătH[hɂU蕪sꍇ
 *      gp鑮Btruew肷eventɐݒ肳ꂽlHidden^Oo͂B
 *      ܂AHidden^Ovalue"forward_pageLinks"ƂB
 *      ftHgfalseB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td><code>event</code></td>
 *    <td><code>"event"</code></td>
 *    <td><code>false</code></td>
 *    <td><code>true</code></td>
 *    <td align="left">
 *      TERASOLUNADispatchActiongpătH[hɂU蕪sꍇ
 *      gp鑮BforwardtrueɂꍇȂɎw肵O
 *      Hidden^OBftHg"event"ƂȂB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td><code>resetIndex</code></td>
 *    <td><code>false</code></td>
 *    <td><code>false</code></td>
 *    <td><code>true</code></td>
 *    <td align="left">
 *      Tu~bgɗLɂȂ鑮ŁAtrueɐݒ肷
 *      w͈̓Zbgs߂startIndexendIndexHidden^Oo͂B
 *      ftHgfalseB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td><code>currentPageIndex</code></td>
 *    <td><code>"currentPageIndex"</code></td>
 *    <td><code>false</code></td>
 *    <td><code>true</code></td>
 *    <td align="left">
 *      Ήꗗ̌݃y[Wy[WReLXgɕۑۂ̃L[ƂȂB
 *      ftHg"currentPageIndex"ƂȂB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td><code>totalPageCount</code></td>
 *    <td><code>"totalPageCount"</code></td>
 *    <td><code>false</code></td>
 *    <td><code>true</code></td>
 *    <td align="left">
 *      Ήꗗ̑y[Wy[WReLXgɕۑۂ̃L[ƂȂB
 *      ftHg"totalPageCount"ƂȂB
 *    </td>
 *   </tr>
 *  </table>
 * </div>
 * <br/>
 *
 * <br/>
 *
 * <strong>JX^^ÕXNveBOϐ</strong>
 * <p>
 *  <code>PageLinksTag</code> ł͈ȉ̕ϐT|[gB
 * </p>
 * <div align="center">
 * <table width="90%" border="1">
 *  <tr>
 *   <td><b>ϐ</b></td>
 *   <td><b>^</b></td>
 *   <td><b>L͈</b></td>
 *   <td><b>Lq</b></td>
 *  </tr>
 *  <tr>
 *   <td>
 *     JX^^O<code>id</code>Ŏw肳ꂽOB
 *   </td>
 *   <td><code>java.lang.String</code></td>
 *   <td>JX^^Oȍ~</td>
 *   <td align="left">
 *    ʂ֏o͂y[WN(<a>^OȂ)ێB
 *   </td>
 *  </tr>
 *  <tr>
 *   <td>
 *     JX^^O<code>currentPageIndex</code>Ŏw肳ꂽOA
 *     ܂̓ftHglB
 *   </td>
 *   <td><code>java.lang.Integer</code></td>
 *   <td>JX^^Oȍ~</td>
 *   <td align="left">
 *    Ήꗗ݂̌̃y[WԍێB
 *   </td>
 *  </tr>
 *  <tr>
 *   <td>
 *     JX^^O<code>totalPageCount</code>Ŏw肳ꂽOA
 *     ܂̓ftHglB
 *   </td>
 *   <td><code>java.lang.Integer</code></td>
 *   <td>JX^^Oȍ~</td>
 *   <td align="left">
 *    Ήꗗ̑y[WێB
 *   </td>
 *  </tr>
 * </table>
 * </div>
 *
 * <br/>
 *
 * <strong>gp@</strong>
 * <li>vpeBt@C̐ݒ</li>
 * <p/>
 * ʂɏo͂郊N̐ݒ̓vpeBt@CɋLqsB
 * Lq̂́Ã݂y[WWvy[WƁA\L̐ݒłB
 * ȂAN͈ȉ̏ɂĂΕLq邱Ƃ\łB
 * <p/>
 * <br/>
 * <li>vpeBt@Cݒ̏</li>
 * <p>
 * &nbsp;&nbsp;<code><b>pageLinks.<i>&lt;Jڕ&gt;</i><i>&lt;J
 * y[W&gt;</i>.char=<i>&lt;\&gt;</i></b></code><br/>
 * &nbsp;&nbsp;<i>Jڕ</i>&nbspF
 * ݂̕\y[WԍOi<i>next</i>̏ꍇ͌jB<br/>
 * &nbsp;&nbsp;<i>Jڃy[W</i>&nbsp;F
 * ݂̕\y[Wԍ̃Wvy[WBl͎Rɐݒ\B<br/>
 * &nbsp;&nbsp;<i>\</i>&nbsp;F
 * ʂɕ\镶B̕NΏۂƂȂB
 * </p>
 * <br/>
 * <p>
 * &nbsp;&nbsp;<b><code>pageLinks.maxDspLinkSize =
 * <i>&lt;\y[W&gt;</i></code></b><br/>
 * &nbsp;&nbsp;<i>\y[W</i>&nbsp;F
 * y[W𒼐ڎw肷郊N̍ő\
 * </p>
 * <p/>
 * <br/>
 * <li>vpeBt@Cݒ</li>
 * <code>
 * &nbsp;&nbsp;pageLinks.prev10.char=&amp;lt;&amp;lt;<br/>
 * &nbsp;&nbsp;pageLinks.prev1.char=&amp;lt;<br/>
 * &nbsp;&nbsp;pageLinks.next1.char=&amp;gt;<br/>
 * &nbsp;&nbsp;pageLinks.next10.char=&amp;gt;&amp;gt;<br/>
 * &nbsp;&nbsp;pageLinks.maxDirectLinkCount=10
 * </code>
 * <p/>
 * <br/>
 * <br/>
 * <li>ꗗy[WPʂɃf[^x[X擾gp</li>
 * <p>
 * ȉɁAy[WN@\gpB̗́Ay[W؂ւ邲Ƃ
 * f[^x[XɃANZXs\ꗗ݂̂擾łB
 * ̗̏ꍇ́Aꗗ\ʂ֍ŏɑJڂANVƁA
 * y[WN@\̃ANV(action)łȂB
 * ȉ̗ł́Ay[WNɐݒ肷tB[hStringgpĂ邪A
 * StringȊÕIuWFNg̐ݒ\łB
 * </p>
 * <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 * <legend>
 * Strutsݒt@C̗
 * </legend>
 * <p/>
 * <code>
 * &lt;form-beans&gt;<br/>
 * &nbsp;&nbsp;&lt;form-bean name="dynaFormBean"<br/>
 * &nbsp;&nbsp;&nbsp;
 * type="org.apache.struts.action.DynaActionForm" &gt;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;!-- 擾ꗗێtB[h --&gt;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;form-property name="<b>userBeans</b>"<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
 * type="jp.terasoluna.strutspring.blogic.UserBean[]"/&gt;<br/>
 * &nbsp;&nbsp;&nbsp;
 * &lt;!-- 1y[Wɕ\錏ێtB[h --&gt;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;form-property name="<b>row</b>"<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
 * type="java.lang.String" initial="10"/&gt;<br/>
 * &nbsp;&nbsp;&nbsp;
 * &lt;!-- \y[W̊JnCfbNXێtB[h --&gt;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;form-property name="<b>startIndex</b>"<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
 * type="java.lang.String" initial="0"/&gt;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;!-- ꗗ̑SێtB[h --&gt;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;form-property name="<b>totalCount</b>"<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;type="java.lang.String"/&gt;<br/>
 * &nbsp;&nbsp;&lt;/form-bean&gt;<br/>
 * &lt;/form-beans&gt;<br/>
 * <br/>
 * &lt;!-- y[WPʂ̈ꗗ擾ANV --&gt;<br/>
 * &lt;action path="<b>/list</b>"<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
 * type="jp.terasoluna.strutspring.action.ListAction"<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
 * name="dynaFormBean" scope="session"&gt;<br/>
 * &nbsp;&nbsp;&lt;forward name="success" path="/listSRC.do"/&gt;<br/>
 * &lt;/action&gt;<br/>
 * &lt;action path="/listSRC"<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
 * type="org.apache.struts.actions.ForwardAction"<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;parameter="/daoTestList.jsp"&gt;<br/>
 * &lt;/action&gt;
 * </code>
 * </fieldset>
 * <p/>
 * <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 * <legend>
 * JSP̗
 * </legend>
 * <p/>
 * <code>
 * <b>&lt;ts:pageLinks action="/list"
 * name="dynaFormBean" rowProperty="row"<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;totalProperty="totalCount"
 * indexProperty="startIndex" /&gt;</b><br/>
 * &lt;table border="1" frame="box"&gt;<br/>
 * &nbsp;&nbsp;<b>&lt;logic:iterate id="userBean"
 * name="dynaFormBean" property="userBeans"&gt;</b><br/>
 * &nbsp;&nbsp;&lt;tr&gt;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;td&gt;&lt;bean:write
 * name="userBean" property="id"/&gt;&lt;/td&gt;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;td&gt;&lt;bean:write
 * name="userBean" property="name"/&gt;&lt;/td&gt;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;td&gt;&lt;bean:write
 * name="userBean" property="age"/&gt;&lt;/td&gt;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;td&gt;&lt;bean:write
 * name="userBean" property="param1"/&gt;&lt;/td&gt;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;td&gt;&lt;bean:write
 * name="userBean" property="param2"/&gt;&lt;/td&gt;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;td&gt;&lt;bean:write
 * name="userBean" property="param3"/&gt;&lt;/td&gt;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;td&gt;&lt;bean:write
 * name="userBean" property="param4"/&gt;&lt;/td&gt;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;td&gt;&lt;bean:write
 * name="userBean" property="param5"/&gt;&lt;/td&gt;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;td&gt;&lt;bean:write
 * name="userBean" property="param6"/&gt;&lt;/td&gt;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;td&gt;&lt;bean:write
 * name="userBean" property="param7"/&gt;&lt;/td&gt;<br/>
 * &nbsp;&nbsp;&lt;/tr&gt;<br/>
 * &nbsp;&nbsp;<b>&lt;/logic:iterate&gt;</b><br/>
 * &lt;/table&gt;
 * </code>
 * </fieldset>
 * <p/>
 * <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 * <legend>
 * T[rXw̗
 * </legend>
 * <p/>
 * <code>
 * DynaActionForm dynaForm = (DynaActionForm) form;<br/>
 * 
 * //\̎擾<br/>
 * String strRow = (String) dynaForm.get("<b>row</b>");<br/>
 * //JnsCfbNX̎擾<br/>
 * String strIndex = (String) dynaForm.get("<b>startIndex</b>");<br/>
 * int row = 10;<br/>
 * int startIndex = 0;<br/>
 * <br/>
 * //intւ̕ϊ<br/>
 * ......<br/>
 * <br/>
 * //Š擾<br/>
 * String totalCount<br/>
 *     = <b>dao.executeForObject("getUserCount", null, String.class);</b><br/>
 * <br/>
 * //ꗗ擾<br/>
 * UserBean[] bean = <b>dao.executeForObjectList("getUserList", null,
 * UserBean.class, startIndex, row);</b><br/>
 * <br/>
 * //ANVtH[ւ̐ݒ<br/>
 * dynaForm.set("<b>totalCount</b>", totalCount);<br/>
 * dynaForm.set("<b>userBeans</b>", bean);
 * </code>
 * </fieldset>
 * <p/>
 * <br/>
 * <br/>
 * <li>ꗗANVtH[擾gp</li>
 * <p>
 * ȉɁAy[WN@\gpB̗́Ay[W؂ւƂ
 * łɎ擾ς݂̈ꗗ(S)ANVtH[擾łB
 * ̗̏ꍇ́Aꗗ\ʂ֍ŏɑJڂANVƁA
 * y[WN@\̃ANV(action)͕ʂ̃ANVƂB
 * ꗗ\ʂ֍ŏɑJڂANVł́Aꗗ̑S擾A
 * y[WN@\̃ANV͂܂ŉʂ\݂̂̃ANVƂB
 * ȉ̗ł́Ay[WNɐݒ肷tB[hStringgpĂ邪A
 * StringȊÕIuWFNg̐ݒ\łB
 * </p>
 * <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 * <legend>
 * Strutsݒt@C̗
 * </legend>
 * <p/>
 * <code>
 * &lt;form-beans&gt;<br/>
 * &nbsp;&nbsp;&lt;form-bean name="dynaFormBean"<br/>
 * &nbsp;&nbsp;&nbsp;
 * type="org.apache.struts.action.DynaActionForm" &gt;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;!-- 擾ꗗێtB[h --&gt;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;form-property name="<b>userBeans</b>"<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
 * type="jp.terasoluna.strutspring.blogic.UserBean[]"/&gt;<br/>
 * &nbsp;&nbsp;&nbsp;
 * &lt;!-- 1y[Wɕ\錏ێtB[h --&gt;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;form-property name="<b>row</b>"<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
 * type="java.lang.String" initial="10"/&gt;<br/>
 * &nbsp;&nbsp;&nbsp;
 * &lt;!-- \y[W̊JnCfbNXێtB[h --&gt;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;form-property name="<b>startIndex</b>"<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
 * type="java.lang.String" initial="0"/&gt;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;!-- ꗗ̑SێtB[h --&gt;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;form-property name="<b>totalCount</b>"<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;type="java.lang.String"/&gt;<br/>
 * &nbsp;&nbsp;&lt;/form-bean&gt;<br/>
 * &lt;/form-beans&gt;<br/>
 * <br/>
 * &lt;!-- ꗗ񂷂ׂĂ擾ANV --&gt;<br/>
 * &lt;action path="/list"<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
 * type="jp.terasoluna.strutspring.action.ListAction"<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
 * name="dynaFormBean" scope="session"&gt;<br/>
 * &nbsp;&nbsp;&lt;forward name="success" path="/listSRC.do"/&gt;<br/>
 * &lt;/action&gt;<br/>
 * &lt;!-- ʕ\݂̂̃ANV --&gt;<br/>
 * &lt;action path="<b>/listSRC</b>"<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
 * type="org.apache.struts.actions.ForwardAction"<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;parameter="/daoTestList.jsp"&gt;<br/>
 * &lt;/action&gt;
 * </code>
 * </fieldset>
 * <p/>
 * <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 * <legend>
 * JSP̗
 * </legend>
 * <p/>
 * <code>
 * <b>&lt;ts:pageLinks action="/listSRC"
 * name="dynaFormBean" rowProperty="row"<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;totalProperty="totalCount"
 * indexProperty="startIndex" /&gt;</b><br/>
 * &lt;table border="1" frame="box"&gt;<br/>
 * &nbsp;&nbsp;<b>&lt;bean:define id="startIndex" name="dynaFormBean"<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;property="startIndex"
 * type="java.lang.String" /&gt;<br/>
 * &nbsp;&nbsp;&lt;logic:iterate id="userBean"
 * name="dynaFormBean" length="10"<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;property="userBeans"
 * offset="&lt;%=startIndex%&gt;"&gt;</b><br/>
 * &nbsp;&nbsp;&lt;tr&gt;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;td&gt;&lt;bean:write
 * name="userBean" property="id"/&gt;&lt;/td&gt;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;td&gt;&lt;bean:write
 * name="userBean" property="name"/&gt;&lt;/td&gt;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;td&gt;&lt;bean:write
 * name="userBean" property="age"/&gt;&lt;/td&gt;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;td&gt;&lt;bean:write
 * name="userBean" property="param1"/&gt;&lt;/td&gt;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;td&gt;&lt;bean:write
 * name="userBean" property="param2"/&gt;&lt;/td&gt;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;td&gt;&lt;bean:write
 * name="userBean" property="param3"/&gt;&lt;/td&gt;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;td&gt;&lt;bean:write
 * name="userBean" property="param4"/&gt;&lt;/td&gt;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;td&gt;&lt;bean:write
 * name="userBean" property="param5"/&gt;&lt;/td&gt;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;td&gt;&lt;bean:write
 * name="userBean" property="param6"/&gt;&lt;/td&gt;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;td&gt;&lt;bean:write
 * name="userBean" property="param7"/&gt;&lt;/td&gt;<br/>
 * &nbsp;&nbsp;&lt;/tr&gt;<br/>
 * &nbsp;&nbsp;<b>&lt;/logic:iterate&gt;</b><br/>
 * &lt;/table&gt;
 * </code>
 * </fieldset>
 * <p/>
 * <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 * <legend>
 * T[rXw̗iŏ̈ꗗʕ\̂݁j
 * </legend>
 * <p/>
 * <code>
 * DynaActionForm dynaForm = (DynaActionForm) form;<br/>
 * <br/>
 * //Š擾<br/>
 * String totalCount<br/>
 *     = <b>dao.executeForObject("getUserCount", null, String.class);</b><br/>
 * <br/>
 * //ꗗ擾<br/>
 * UserBean[] bean = <b>dao.executeForObjectList("getUserList", null,
 * UserBean.class);</b><br/>
 * <br/>
 * //ANVtH[ւ̐ݒ<br/>
 * dynaForm.set("<b>totalCount</b>", totalCount);<br/>
 * dynaForm.set("<b>userBeans</b>", bean);
 * </code>
 * </fieldset>
 * <p/>
 * <br/><br/>
 * <li>Tu~bgsꍇ̎gp</li>
 * <p/>
 * y[WN@\́AftHgł&lt;a&gt;gpāAw肳ꂽANVւ
 * N쐬邽߁ATu~bgsȂB
 * Tu~bgsꍇ́A<code>submit</code><code>true</code>ɐݒ肷B
 * ̐ݒsƁAy[WNɁAJavaScriptɂTu~bgsB
 * ȂA<code>submit</code><code>true</code>ɐݒ肷
 * <code>action</code>͖ƂȂB
 * <p/>
 * <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 * <legend>
 * JSP̗iꕔj
 * </legend>
 * <p/>
 * <code>
 * &lt;ts:pageLinks <b>submit="true"</b>
 * name="dynaFormBean" rowProperty="row"<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;totalProperty="totalCount"
 * indexProperty="startIndex" /&gt;<br/>
 * </code>
 * </fieldset>
 * <p/>
 * <br/><br/>
 * <li>DispatchActiongpătH[hsꍇ̎gp</li>
 * <p/>
 * TERASOLUNADispatchActiongpătH[hsꍇ́A
 * forward"true"ɂKvBforward"true"ƂꍇAʂ
 * u&lt;input type="hidden" name="event" value="forward_pageLinks" /&gt;v
 * o͂B܂Ao͂Hidden^Oname̒leventɎw肳ꂽlƂȂB
 * ftHg"event"ł邽߁Aw肵Ȃꍇ͏LHidden^Oo͂B
 * <p/>
 * <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 * <legend>
 * JSP̗iꕔj
 * </legend>
 * <p/>
 * <code>
 * &lt;ts:pageLinks submit="true" name="dynaFormBean"
 * rowProperty="row"<br>
 * &nbsp;&nbsp;&nbsp;&nbsp;
 * totalProperty="totalCount"
 * indexProperty="startIndex"<br>
 * &nbsp;&nbsp;&nbsp;&nbsp;
 * <b>forward="true" event="forwardParameter" /&gt;</b><br/>
 * </code>
 * </fieldset>
 * <p/>
 * <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 * <legend>
 * LJSPɂďo͂ꂽHTML̗iHidden^Oj
 * </legend>
 * <p/>
 * <code>
 * &lt;input type="hidden" name="<b>forwardParameter</b>"
 * value="<b>forward_pageLinks</b>" /&gt;
 * </code>
 * </fieldset>
 * <p/>
 * <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 * <legend>
 * Strutsݒt@C̗
 * </legend>
 * <p/>
 * <code>
 * &lt;action path="/list"<br>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
 * name="dynaFormBean" scope="request"&gt;<br>
 * &nbsp;&nbsp;&nbsp;
 * &lt;forward name="<b>pageLinks</b>" path="/pageLinks.do" /&gt;<br>
 * &nbsp;&nbsp;&nbsp;
 * &lt;forward name="regist"&nbsp;path="/regist.do"&nbsp;/&gt;<br>
 * &lt;/action&gt;<br>
 * </code>
 * </fieldset>
 * <p/>
 * <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 * <legend>
 * Bean`t@C̗
 * </legend>
 * <p/>
 * <code>
 * &lt;bean name="/list"<br>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
 * class="jp.terasoluna.fw.web.struts.actions.DispatchAction"&gt;<br>
 * &nbsp;&nbsp;&nbsp;
 * &lt;property name="event"&gt;
 * &lt;value&gt;forwardParameter&lt;/value&gt;
 * &lt;/property&gt;<br>
 * &lt;/bean&gt;<br>
 * </code>
 * </fieldset>
 * <p/>

 * <br/><br/>
 * <li>݃y[WAy[W̏o</li>
 * <p/>
 * y[WN@\ł́A݃y[WƑy[W<code>pageContext</code>
 * ۑBۑL[́A<code>currentPageIndex</code>
 * <code>totalPageCount</code>ɂĎw\łB
 * ̃ftHgl͏LQƂ̂ƁB
 * ݃y[Wёy[Wʂɕ\ꍇ́Aȉ̂悤ɎgpB
 * <p/>
 * <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 * <legend>
 * JSP̗iꕔj
 * </legend>
 * <p/>
 * <code>
 * &lt;ts:pageLinks action="/pageLink" rowProperty="row"<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;totalProperty="totalCount"
 * indexProperty="startIndex" /&gt;<br/>
 * <br>
 * ݂́m&lt;bean:write name="<b>currentPageIndex</b>"/&gt;ny[WłB<br>
 * SŁm&lt;bean:write name="<b>totalPageCount</b>"/&gt;ny[W܂B
 * </code>
 * </fieldset>
 * <br/><br/>
 * <li>id̎gp</li>
 * <p/>
 * idw肷ƁAy[WNʂɏo͂ɁAw肳ꂽL[
 * <code>pageContext</code>ɕۑ邽߁Ao͏ꏊRɕύX邱ƂłB
 * ݃y[W⑍y[Wy[WN̏㕔ɏo͂ƂȂǂɎgpB
 * <p/>
 * <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 * <legend>
 * JSP̗iꕔj
 * </legend>
 * <p/>
 * <code>
 * &lt;ts:pageLinks action="/pageLink" <b>id="reservePageLinks"</b>
 * rowProperty="row"<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;totalProperty="totalCount"
 * indexProperty="startIndex"<br>
 * &nbsp;&nbsp;&nbsp;&nbsp;currentPageIndex="reserveCurrentPageIndex"
 * totalPageCount="reserveTotalPageCount" /&gt;<br/>
 * <br>
 * ݂́m&lt;bean:write name="reserveCurrentPageIndex"/&gt;ny[WłB<br>
 * SŁm&lt;bean:write name="reserveTotalPageCount"/&gt;ny[W܂B<br>
 * &lt;bean:write name="<b>reservePageLinks</b>"/&gt;
 * </code>
 * </fieldset>
 * <p/>
 * <br/>
 * <br/>
 *
 */
public class PageLinksTag extends TagSupport {

    /**
     * VAo[WID
     */
    private static final long serialVersionUID = 9017738370826462823L;

    /**
     * ONXB
     */
    private static Log log =
         LogFactory.getLog(PageLinksTag.class);

    /**
     * o͐ύXpIDB
     */
    protected String id = null;

    /**
     * y[WNɋNANVB
     */
    protected String action = null;

    /**
     * \JnCfbNXƑSێBeanB
     */
    protected String name = null;

    /**
     * \s̃tB[hB
     */
    protected String rowProperty = null;

    /**
     * \JnCfbNX̃tB[hB
     */
    protected String indexProperty = null;

    /**
     * S̃tB[hB
     */
    protected String totalProperty = null;

    /**
     * 擾BeañXR[vB
     */
    protected String scope = null;

    /**
     * Tu~bgtOB
     */
    protected boolean submit = false;

    /**
     * tH[htOB
     */
    protected boolean forward = false;

    /**
     * Cxgp[^B
     */
    protected String event = DEFAULT_EVENT;

    /**
     * w͈̓CfbNXo̓tOB
     */
    protected boolean resetIndex = false;

    /**
     * ݃y[Wԍۑpp[^B
     */
    protected String currentPageIndex = CURRENT_PAGE_INDEX;

    /**
     * ݃y[Wԍۑpp[^B
     */
    protected String totalPageCount = TOTAL_PAGE_COUNT;

    /**
     * ݒ肳ĂidlԋpB
     * @return ݒ肳Ăl
     */
    @Override
    public String getId() {
        return this.id;
    }

    /**
     * idɒlݒ肷B
     * @param id ݒ肷l
     */
    @Override
    public void setId(String id) {
        this.id = id;
    }

    /**
     * ݒ肳ĂactionlԋpB
     * @return ݒ肳Ăl
     */
    public String getAction() {
        return this.action;
    }

    /**
     * actionɒlݒ肷B
     * @param action ݒ肷l
     */
    public void setAction(String action) {
        this.action = action;
    }

    /**
     * ݒ肳ĂidlԋpB
     * @return ݒ肳Ăl
     */
    public String getName() {
        return name;
    }

    /**
     * nameɒlݒ肷B
     * @param name ݒ肷l
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * ݒ肳ĂrowPropertylԋpB
     * @return ݒ肳Ăl
     */
    public String getRowProperty() {
        return rowProperty;
    }

    /**
     * rowPropertyɒlݒ肷B
     * @param rowProperty ݒ肷l
     */
    public void setRowProperty(String rowProperty) {
        this.rowProperty = rowProperty;
    }

    /**
     * ݒ肳ĂindexPropertylԋpB
     * @return ݒ肳Ăl
     */
    public String getIndexProperty() {
        return indexProperty;
    }

    /**
     * indexPropertyɒlݒ肷B
     * @param indexProperty ݒ肷l
     */
    public void setIndexProperty(String indexProperty) {
        this.indexProperty = indexProperty;
    }

    /**
     * ݒ肳ĂtotalPropertylԋpB
     * @return ݒ肳Ăl
     */
    public String getTotalProperty() {
        return totalProperty;
    }

    /**
     * totalPropertyɒlݒ肷B
     * @param totalProperty ݒ肷l
     */
    public void setTotalProperty(String totalProperty) {
        this.totalProperty = totalProperty;
    }

    /**
     * ݒ肳ĂscopelԋpB
     * @return ݒ肳Ăl
     */
    public String getScope() {
        return scope;
    }

    /**
     * scopeɒlݒ肷B
     * @param scope ݒ肷l
     */
    public void setScope(String scope) {
        this.scope = scope;
    }

    /**
     * ݒ肳ĂsubmitlԋpB
     * @return ݒ肳Ăl
     */
    public boolean getSubmit() {
        return submit;
    }

    /**
     * submitɒlݒ肷B
     * @param submit ݒ肷l
     */
    public void setSubmit(boolean submit) {
        this.submit = submit;
    }

    /**
     * ݒ肳ĂforwardlԋpB
     * @return ݒ肳Ăl
     */
    public boolean getForward() {
        return forward;
    }

    /**
     * forwardɒlݒ肷B
     * @param forward ݒ肷l
     */
    public void setForward(boolean forward) {
        this.forward = forward;
    }

    /**
     * ݒ肳ĂeventlԋpB
     * @return ݒ肳Ăl
     */
    public String getEvent() {
        return this.event;
    }

    /**
     * eventɒlݒ肷B
     * @param event ݒ肷l
     */
    public void setEvent(String event) {
        this.event = event;
    }

    /**
     * ݒ肳ĂresetIndexlԋpB
     * @return ݒ肳Ăl
     */
    public boolean getResetIndex() {
        return resetIndex;
    }

    /**
     * resetIndexɒlݒ肷B
     * @param resetIndex ݒ肷l
     */
    public void setResetIndex(boolean resetIndex) {
        this.resetIndex = resetIndex;
    }

    /**
     * ݒ肳ĂcurrentPageIndexlԋpB
     * @return ݒ肳Ăl
     */
    public String getCurrentPageIndex() {
        return this.currentPageIndex;
    }

    /**
     * currentPageIndexɒlݒ肷B
     * @param currentPageIndex ݒ肷l
     */
    public void setCurrentPageIndex(String currentPageIndex) {
        this.currentPageIndex = currentPageIndex;
    }

    /**
     * ݒ肳ĂtotalPageCountlԋpB
     * @return ݒ肳Ăl
     */
    public String getTotalPageCount() {
        return this.totalPageCount;
    }

    /**
     * totalPageCountɒlݒ肷B
     * @param totalPageCount ݒ肷l
     */
    public void setTotalPageCount(String totalPageCount) {
        this.totalPageCount = totalPageCount;
    }

    /**
     * ANVK{̃G[bZ[WB
     */
    protected static String ERROR_MESSAGE_ACTION_REQUIRED =
    "Action attribute is required when submit attribute is \"false\".";

    /**
     * 擾\s(row)0ȉ̏ꍇ̃G[bZ[WB
     */
    protected static String WARN_MESSAGE_ILLEGAL_ROW =
    "Row param is illegal.";

    /**
     * <code>ApplicationResources</code> t@Cɂ
     * y[WWvpÑvpeB̃vtBbNXB
     */
    protected static String PAGE_LINKS_PREFIX = "pageLinks.";

    /**
     * <code>ApplicationResources</code> t@CɂOւ
     * y[WWvpÑvpeB̍\vfB
     */
    protected static String PREV_LINKS = "prev";

    /**
     * <code>ApplicationResources</code> t@Cɂւ
     * y[WWvpÑvpeB̍\vfB
     */
    protected static String NEXT_LINKS = "next";

    /**
     * <code>ApplicationResources</code> t@CɂL\
     * y[WWvpÑvpeB̍\vfB
     */
    protected static String CHAR_LINKS = ".char";

    /**
     * <code>ApplicationResources</code> t@Cɂ
     * y[WWvpN̒ڔԍw̕\ő吔
     * vpeB̍\vfB
     */
    protected static String MAX_DSP_SIZE = "maxDirectLinkCount";

    /**
     * y[WN@\ŏo͂JavaScript̏o̓tO
     */
    protected static String PAGELINKS_JAVASCRIPT_KEY
        = "pageLinksJavaScriptKey";

    /**
     * tH[hB
     */
    protected static String FORWARD_NAME = "forward_pageLinks";

    /**
     * ftHgCxgp[^B
     */
    protected static String DEFAULT_EVENT = "event";

    /**
     * y[Wy[WReLXgɓo^L[B
     */
    protected static String TOTAL_PAGE_COUNT = "totalPageCount";

    /**
     * ݃y[Wy[WReLXgɓo^L[B
     */
    protected static String CURRENT_PAGE_INDEX = "currentPageIndex";

    /**
     * vpeBt@C̃No^IDL[Ƃĕ\Ni[}bvB
     */
    protected Map<String, String> links = new HashMap<String, String>();

    /**
     * őy[WWvB
     */
    protected int maxLinkNo = 1;

    /**
     * ő咼ڎw胊NԍB
     */
    protected int maxPageCount = 10;

    /**
     * ^O]JnɌĂ΂郁\bhB
     *
     * @return w
     * @throws JspException JSPO
     */
    @Override
    public int doStartTag() throws JspException {

        //`FbN
        if (!submit && (action == null || "".equals(action))) {
            log.error(ERROR_MESSAGE_ACTION_REQUIRED);
            throw new JspException(ERROR_MESSAGE_ACTION_REQUIRED);
        }

        // vpeBt@Cy[WWvpN^O擾
        getLinkProperty();

        //\s擾
        Object objRow = lookup(pageContext, name, rowProperty, scope);
        int row = getInt(objRow);

        //擾\s0ȉ̏ꍇ͏IB
        if (row <= 0) {
            if (log.isWarnEnabled()) {
                log.warn(WARN_MESSAGE_ILLEGAL_ROW);
            }
            return EVAL_BODY_INCLUDE;
        }

        //JnsCfbNX擾
        Object objIndex = lookup(pageContext, name, indexProperty, scope);
        int startIndex = getInt(objIndex);

        //S擾
        Object objTotal = lookup(pageContext, name, totalProperty, scope);
        int totalCount = getInt(objTotal);

        //StringBuilder̐
        StringBuilder sb = new StringBuilder();

        //݃y[WAy[Wݒ肷B
        attributePageCount(
                getPageIndex(row, startIndex), getPageCount(row, totalCount));

        if (submit) {
            //submittruêƂ́ATu~bgsy[WNo͂B

            //\sAJnCfbNX̃^Oo
            defineHtml(row, startIndex, totalCount);

            //Oy[WN̐ݒ
            addPrevSubmit(sb, row, startIndex, totalCount);

            //y[WԍN̐ݒ
            addDirectSubmit(sb, row, startIndex, totalCount);

            //y[WN̐ݒ
            addNextSubmit(sb, row, startIndex, totalCount);

        } else {
            //submitfalsȅꍇ

            //Oy[WN̐ݒ
            addPrevLink(sb, row, startIndex, totalCount);

            //y[WԍN̐ݒ
            addDirectLink(sb, row, startIndex, totalCount);

            //y[WN̐ݒ
            addNextLink(sb, row, startIndex, totalCount);
        }

        //StringBuilderɂ߂eo͂B
        if (id == null || "".equals(id)) {
            try {
                JspWriter writer = pageContext.getOut();
                writer.println(sb.toString());
            } catch (IOException e) {
                log.error(e.getMessage());
                throw new JspTagException(e.toString());
            }
        } else {
            pageContext.setAttribute(id, sb.toString());
        }

        return EVAL_BODY_INCLUDE;
    }

    /**
     * HTML̒`o͂B
     * 
     * @param row \s
     * @param startIndex \JnCfbNX
     * @param totalCount S
     * @throws JspException JSPO
     */
    protected void defineHtml(int row, int startIndex, int totalCount)
        throws JspException {

        JspWriter writer = pageContext.getOut();
        try {

            //OHidden^Oo͂Ȃ߁AtOm߂B
            if (!getPageContextFlg(pageContext, PAGELINKS_JAVASCRIPT_KEY
                    + rowProperty)) {

                //\Hidden^Oǉ
                writer.println("<input type=\"hidden\" name=\""
                        + rowProperty + "\" value=\"" + row + "\"/>");

                //o͂tO𗧂ĂB
                setPageContextFlg(pageContext, PAGELINKS_JAVASCRIPT_KEY
                        + rowProperty);
            }

            //OHidden^Oo͂Ȃ߁AtOm߂B
            if (!getPageContextFlg(pageContext, PAGELINKS_JAVASCRIPT_KEY
                    + indexProperty)) {

                //\JnCfbNXHidden^Oǉ
                writer.println("<input type=\"hidden\" name=\""
                        + indexProperty + "\" value=\"" + startIndex + "\"/>");

                //o͂tO𗧂ĂB
                setPageContextFlg(pageContext, PAGELINKS_JAVASCRIPT_KEY
                        + indexProperty);
            }

            //OHidden^Oo͂Ȃ߁AtOm߂B
            if (!getPageContextFlg(pageContext, PAGELINKS_JAVASCRIPT_KEY
                    + event) && forward) {

                //\JnCfbNXHidden^Oǉ
                writer.println("<input type=\"hidden\" name=\"" + event
                        + "\" value=\"\"/>");

                //o͂tO𗧂ĂB
                setPageContextFlg(pageContext, PAGELINKS_JAVASCRIPT_KEY
                        + event);
            }

            //OHidden^Oo͂Ȃ߁AtOm߂B
            if (!getPageContextFlg(pageContext, PAGELINKS_JAVASCRIPT_KEY
                    + "resetIndex") && resetIndex) {

                //startIndexHidden^Oǉ
                if (!"startIndex".equals(indexProperty)) {
                    writer.println("<input type=\"hidden\" name=\"" +
                            "startIndex\" value=\"" + startIndex + "\"/>");
                }

                //endIndexHidden^Oǉ
                int endIndex = startIndex + row - 1;
                if (endIndex > totalCount) {
                    writer.println("<input type=\"hidden\" name=\"" +
                            "endIndex\" value=\"" + (totalCount - 1) + "\"/>");
                } else {
                    writer.println("<input type=\"hidden\" name=\"" +
                            "endIndex\" value=\"" + endIndex + "\"/>");
                }

                //o͂tO𗧂ĂB
                setPageContextFlg(pageContext, PAGELINKS_JAVASCRIPT_KEY
                        + "resetIndex");
            }

            //tH[擾
            String formName = ActionFormUtil
                    .getActionFormName((HttpServletRequest) pageContext
                            .getRequest());

            //Tu~bgsJavaScriptǉB
            //Ay[WN^OLqĂꍇ͂P̂
            if (!getPageContextFlg(pageContext, PAGELINKS_JAVASCRIPT_KEY)) {
                writer.println("<script type=\"text/javascript\">");
                writer.println("<!--");
                writer.println("  function pageLinkSubmit(rowObj, indexObj,"
                        + " row, startIndex){");
                writer.println("    rowObj.value = row;");
                writer.println("    indexObj.value = startIndex;");

                //forwardtruȅꍇ́AeventHidden^O
                //p[^ݒ肷B
                if (forward) {
                    writer.print("    document.");
                    writer.print(formName);
                    writer.print(".");
                    writer.print(event);
                    writer.print(".value = \"");
                    writer.print(FORWARD_NAME);
                    writer.println("\";");
                }

                writer.print("    document.");
                writer.print(formName);
                writer.println(".submit();");
                writer.println("  }");
                writer.println("// -->");
                writer.println("</script>");

                //o͂tO𗧂ĂB
                setPageContextFlg(pageContext, PAGELINKS_JAVASCRIPT_KEY);
            }

        } catch (IOException e) {
            log.error(e.getMessage());
            throw new JspTagException(e.toString());
        }
    }

    /**
     * Oy[WɑJڂ郊NStringBuilderɒǉB
     * 
     * @param sb ǉΏۂStringBuilder
     * @param row \s
     * @param startIndex \JnCfbNX
     * @param totalCount ꗗ̑S
     */
    protected void addPrevSubmit(StringBuilder sb, int row, int startIndex,
            int totalCount) {

        //tH[擾
        String formName = ActionFormUtil
                .getActionFormName((HttpServletRequest) pageContext
                        .getRequest());

        //Oy[WN̐
        for (int i = maxLinkNo; i > 0; i--) {
            String linkKey = PREV_LINKS + i + CHAR_LINKS;
            String linkValue = links.get(linkKey);
            if (linkValue == null
                    || "".equals(linkValue)) {
                continue;
            }
            int index = startIndex - (i * row);
            if (index < 0) {
                sb.append(linkValue + "&nbsp;");
            } else {
                sb.append("<a href=\"#\" onclick=\"pageLinkSubmit(");
                sb.append("document.");
                sb.append(formName);
                sb.append(".");
                sb.append(rowProperty);
                sb.append(",");
                sb.append("document.");
                sb.append(formName);
                sb.append(".");
                sb.append(indexProperty);
                sb.append(",");
                sb.append(row);
                sb.append(",");
                sb.append(index);
                sb.append(")\">");
                sb.append(linkValue);
                sb.append("</a>&nbsp;");
            }
        }
    }

    /**
     * y[WԍNStringBuilderɒǉB
     * 
     * @param sb ǉΏۂStringBuilder
     * @param row \s
     * @param startIndex \JnCfbNX
     * @param totalCount ꗗ̑S
     */
    protected void addDirectSubmit(StringBuilder sb, int row, int startIndex,
            int totalCount) {

        //tH[擾
        String formName = ActionFormUtil
                .getActionFormName((HttpServletRequest) pageContext
                        .getRequest());

        //y[WWvpN̒ڔԍw̕\ő吔擾
        String directLinkNo = links.get(MAX_DSP_SIZE);
        if (directLinkNo != null) {
            try {
                maxPageCount = Integer.parseInt(directLinkNo);
            } catch (NumberFormatException e) {
                // NumberFormatExceptionꍇA
                // ̃vpeB͖maxDirectLinkCountɂ
                // ftHglgp
            }
        }

        //Sy[W擾B
        int pageCount = getPageCount(row, totalCount);

        //݂̃y[WCfbNX擾B
        int pageIndex = getPageIndex(row, startIndex);

        //\ŏIy[Wѕ\Jny[W
        int startPage = 0;
        int endPage = 0;

        //Sy[WAy[WԍN̕\傫A
        //A\y[WCfbNXAy[WԍN̕\̔
        //傫ꍇ́A\Jny[WCfbNXA\y[WCfbNX
        //킹ĕϓB
        //ƂāASy[WFPOy[WAy[WԍN̕\FTA
        //\y[WCfbNXFT̏ꍇAstartPageQƂȂ
        //endPageTƂȂB̏ꍇAʂɕ\郊Ńu3 4 5 6 7vƂȂB
        if (pageCount > maxPageCount && pageIndex > (maxPageCount / 2)) {

            //\ŏIy[Wőy[WƂB
            endPage = maxPageCount;

            startPage = (pageIndex - (endPage / 2)) - 1;
            if (startPage + endPage > pageCount) {
                startPage = pageCount - endPage;
            }
        } else {
            endPage = pageCount < maxPageCount ? pageCount : maxPageCount;
            startPage = 0;
        }

        //y[WԍN̐[v
        int size = startPage + endPage;
        for (int i = startPage; i < size; i++) {
            int idx = i + 1;
            if (pageIndex == idx) {
                sb.append("<b>");
                sb.append(idx);
                sb.append("</b>&nbsp;");
            } else {
                sb.append("<a href=\"#\" onclick=\"pageLinkSubmit(");
                sb.append("document.");
                sb.append(formName);
                sb.append(".");
                sb.append(rowProperty);
                sb.append(",");
                sb.append("document.");
                sb.append(formName);
                sb.append(".");
                sb.append(indexProperty);
                sb.append(",");
                sb.append(row);
                sb.append(",");
                sb.append(i * row);
                sb.append(")\">");
                sb.append(idx);
                sb.append("</a>&nbsp;");
            }
        }
    }

    /**
     * y[WɑJڂ郊NStringBuilderɒǉB
     * 
     * @param sb ǉΏۂStringBuilder
     * @param row \s
     * @param startIndex \JnCfbNX
     * @param totalCount ꗗ̑S
     */
    protected void addNextSubmit(StringBuilder sb, int row, int startIndex,
            int totalCount) {

        //tH[擾
        String formName = ActionFormUtil
                .getActionFormName((HttpServletRequest) pageContext
                        .getRequest());

        //y[WN̐
        for (int i = 1; i <= maxLinkNo; i++) {
            String linkKey = NEXT_LINKS + i + CHAR_LINKS;
            String linkValue = links.get(linkKey);

            if (linkValue == null
                    || "".equals(linkValue)) {
                continue;
            }

            int index = startIndex + (i * row);
            if (index > (totalCount - 1)) {
                sb.append(linkValue + "&nbsp;");
            } else {
                sb.append("<a href=\"#\" onclick=\"pageLinkSubmit(");
                sb.append("document.");
                sb.append(formName);
                sb.append(".");
                sb.append(rowProperty);
                sb.append(",");
                sb.append("document.");
                sb.append(formName);
                sb.append(".");
                sb.append(indexProperty);
                sb.append(",");
                sb.append(row);
                sb.append(",");
                sb.append(index);
                sb.append(")\">");
                sb.append(linkValue);
                sb.append("</a>&nbsp;");
            }
        }
    }

    /**
     * Oy[WɑJڂ郊NStringBuilderɒǉB
     * 
     * @param sb ǉΏۂStringBuilder
     * @param row \s
     * @param startIndex \JnCfbNX
     * @param totalCount ꗗ̑S
     */
    protected void addPrevLink(StringBuilder sb, int row, int startIndex,
            int totalCount) {

        //TagUtils̃CX^X
        TagUtils tagUtils = TagUtils.getInstance();

        // X|Xp[^̎擾
        HttpServletResponse response
            = (HttpServletResponse) pageContext.getResponse();

        //ANVURL̎擾
        String url = null;
        url = response.encodeURL(
                tagUtils.getActionMappingURL(action, pageContext));

        //Oy[WN̐
        for (int i = maxLinkNo; i > 0; i--) {
            String linkKey = PREV_LINKS + i + CHAR_LINKS;
            String linkValue = links.get(linkKey);

            if (linkValue == null
                    || "".equals(linkValue)) {
                continue;
            }

            int index = startIndex - (i * row);
            if (index < 0) {
                sb.append(linkValue + "&nbsp;");
            } else {
                sb.append("<a href=\"" + url);
                if (url.indexOf("?") < 0) {
                    sb.append("?");
                } else {
                    sb.append("&");
                }
                sb.append(rowProperty);
                sb.append("=");
                sb.append(row);
                sb.append("&");
                sb.append(indexProperty);
                sb.append("=");
                sb.append(index);
                sb.append("\">");
                sb.append(linkValue);
                sb.append("</a>&nbsp;");
            }
        }
    }

    /**
     * y[WԍNStringBuilderɒǉB
     * 
     * @param sb ǉΏۂStringBuilder
     * @param row \s
     * @param startIndex \JnCfbNX
     * @param totalCount ꗗ̑S
     */
    protected void addDirectLink(StringBuilder sb, int row, int startIndex,
            int totalCount) {

        //TagUtils̃CX^X
        TagUtils tagUtils = TagUtils.getInstance();

        // X|Xp[^̎擾
        HttpServletResponse response
            = (HttpServletResponse) pageContext.getResponse();

        //ANVURL̎擾
        String url = null;
        url = response.encodeURL(
                tagUtils.getActionMappingURL(action, pageContext));

        //y[WWvpN̒ڔԍw̕\ő吔擾
        String directLinkNo = links.get(MAX_DSP_SIZE);
        if (directLinkNo != null) {
            try {
                maxPageCount = Integer.parseInt(directLinkNo);
            } catch (NumberFormatException e) {
                // NumberFormatExceptionꍇA
                // ̃vpeB͖maxDirectLinkCountɂ
                // ftHglgp
            }
        }

        //Sy[W擾B
        int pageCount = getPageCount(row, totalCount);

        //݂̃y[WCfbNX擾B
        int pageIndex = getPageIndex(row, startIndex);

        //\ŏIy[Wѕ\Jny[W
        int startPage = 0;
        int endPage = 0;

        //Sy[WAy[WԍN̕\傫A
        //A\y[WCfbNXAy[WԍN̕\̔
        //傫ꍇ́A\Jny[WCfbNXA\y[WCfbNX
        //킹ĕϓB
        //ƂāASy[WFPOy[WAy[WԍN̕\FTA
        //\y[WCfbNXFT̏ꍇAstartPageQƂȂ
        //endPageTƂȂB̏ꍇAʂɕ\郊Ńu3 4 5 6 7vƂȂB
        if (pageCount > maxPageCount && pageIndex > (maxPageCount / 2)) {

            //\ŏIy[Wőy[WƂB
            endPage = maxPageCount;

            startPage = (pageIndex - (endPage / 2)) - 1;
            if (startPage + endPage > pageCount) {
                startPage = pageCount - endPage;
            }
        } else {
            endPage = pageCount < maxPageCount ? pageCount : maxPageCount;
            startPage = 0;
        }

        //y[WԍN̐[v
        int size = startPage + endPage;
        for (int i = startPage; i < size; i++) {
            int idx = i + 1;
            if (pageIndex == idx) {
                sb.append("<b>");
                sb.append(idx);
                sb.append("</b>&nbsp;");
            } else {
                // y[WWvpN^OZbg
                sb.append("<a href=\"" + url);
                if (url.indexOf("?") < 0) {
                    sb.append("?");
                } else {
                    sb.append("&");
                }
                sb.append(rowProperty);
                sb.append("=");
                sb.append(row);
                sb.append("&");
                sb.append(indexProperty);
                sb.append("=");
                sb.append(i * row);
                sb.append("\">");
                sb.append(idx);
                sb.append("</a>&nbsp;");
            }
        }
    }

    /**
     * y[WɑJڂ郊NStringBuilderɒǉB
     * 
     * @param sb ǉΏۂStringBuilder
     * @param row \s
     * @param startIndex \JnCfbNX
     * @param totalCount ꗗ̑S
     */
    protected void addNextLink(StringBuilder sb, int row, int startIndex,
            int totalCount) {

        //TagUtils̃CX^X
        TagUtils tagUtils = TagUtils.getInstance();

        // X|Xp[^̎擾
        HttpServletResponse response
            = (HttpServletResponse) pageContext.getResponse();

        //ANVURL̎擾
        String url = null;
        url = response.encodeURL(
                tagUtils.getActionMappingURL(action, pageContext));

        //y[WN̐
        for (int i = 1; i <= maxLinkNo; i++) {
            String linkKey = NEXT_LINKS + i + CHAR_LINKS;
            String linkValue = links.get(linkKey);

            if (linkValue == null
                    || "".equals(linkValue)) {
                continue;
            }

            int index = startIndex + (i * row);
            if (index > (totalCount - 1)) {
                sb.append(linkValue + "&nbsp;");
            } else {

                sb.append("<a href=\"" + url);
                if (url.indexOf("?") < 0) {
                    sb.append("?");
                } else {
                    sb.append("&");
                }
                sb.append(rowProperty);
                sb.append("=");
                sb.append(row);
                sb.append("&");
                sb.append(indexProperty);
                sb.append("=");
                sb.append(index);
                sb.append("\">");
                sb.append(linkValue);
                sb.append("</a>&nbsp;");
            }
        }
    }

    /**
     * vpeBt@Cɒ`Ăy[WWvpN`擾B
     * 擾NXϐɊi[B
     */
    private void getLinkProperty() {
        // vpeBt@Cɒ`Ă郊N\o^
        Enumeration enume
            = PropertyUtil.getPropertyNames(PAGE_LINKS_PREFIX);
        while (enume.hasMoreElements()) {
            String propName = (String) enume.nextElement();
            String id = propName.substring(PAGE_LINKS_PREFIX.length());
            String link = PropertyUtil.getProperty(propName);

            // őy[WWvݒ
            if ((id != null)
                    && (id.startsWith(PREV_LINKS)
                    || id.startsWith(NEXT_LINKS))) {
                String strLinkNo = id.substring(4, id.lastIndexOf(CHAR_LINKS));
                int intLinkNo = 0;
                try {
                    intLinkNo = Integer.parseInt(strLinkNo);
                } catch (NumberFormatException e) {
                    // Ȃ
                    continue;
                }
                if (intLinkNo > maxLinkNo) {
                    maxLinkNo = intLinkNo;
                }
                links.put(id, link);
            } else if (MAX_DSP_SIZE.equals(id)) {
                links.put(id, link);
            }
        }
    }

    /**
     * \y[WԍZoĕԋpB
     * 
     * @param row \s
     * @param startIndex ݕ\Ăy[W̕\JnCfbNX
     * @return Zo\y[Wԍ
     */
    protected int getPageIndex(int row, int startIndex) {

        //\y[Wԍ̎Zo
        int pageIndex = 0;
        if (row > 0) {
            pageIndex = startIndex / row + 1;
        } else {
            pageIndex = 0;
        }
        if (row > 0 && startIndex % row > 0) {
            pageIndex++;
        }

        return pageIndex;

    }

    /**
     * y[WZoĕԋpB
     * 
     * @param row \s
     * @param totalCount S
     * @return Zoy[W
     */
    protected int getPageCount(int row, int totalCount) {

        //\y[Wԍ̎Zo
        int pageCount = 0;
        if (row > 0) {
            pageCount = totalCount / row;
            if (totalCount % row > 0) {
                pageCount++;
            }
        } else {
            pageCount = 1;
        }

        return pageCount;

    }

    /**
     * w肳ꂽKEYɂĎ擾l^UlɕϊĕԋpB
     * ȂAkeynull̏ꍇ́AIllegalArgumentExceptionB
     * 
     * @param pageContext y[WReLXg
     * @param key FLG擾KEY
     * @return w肳ꂽKEYɂĎ擾o͏ԃtO
     */
    protected boolean getPageContextFlg(
            PageContext pageContext, String key) {
        //y[WReLXgtO擾B
        Object obj = pageContext.getAttribute(key);
        Boolean bol = new Boolean(false);
        if (obj != null && obj instanceof Boolean) {
           bol = (Boolean) obj;
        }
        return bol.booleanValue();
    }

    /**
     * y[WReLXgɑ΂āAw肳ꂽKEỸtOݒ肷B
     * ȂAkeynull̏ꍇ́AIllegalArgumentExceptionB
     * 
     * @param pageContext y[WReLXg
     * @param key FLGݒ肷KEY
     */
    protected void setPageContextFlg(
            PageContext pageContext, String key) {
        //y[WReLXgɃtO𗧂ĂB
        pageContext.setAttribute(key, Boolean.valueOf(true));
    }

    /**
     * namew肳ĂȂꍇ́Aproperty̒l𒼐ڎ擾B
     * 
     * @param pageContext y[WReLXg
     * @param name vpeBێBean
     * @param property vpeB
     * @param scope XR[v
     * @return 擾l
     * @throws JspException JSPO
     */
    protected Object lookup(PageContext pageContext, String name, 
            String property, String scope) throws JspException{
        if (property == null || "".equals(property)) {
            return null;
        }
        Object retObj = null;
        if (name != null && !"".equals(name)) {
            retObj = TagUtils.getInstance().lookup(pageContext, name,
                    property, scope);
        } else {
            retObj = TagUtils.getInstance().lookup(pageContext,
                    property, scope);
        }
        return retObj;
    }

    /**
     * ̃IuWFNgintɕϊĕԋpB
     * 
     * @param obj intɕϊIuWFNg 
     * @return 擾l
     * @throws JspException JSPO
     */
    protected int getInt(Object obj) throws JspException{
        int retInt = 0;
        String value = ObjectUtils.toString(obj);
        if (!"".equals(value)) {
            try {
                retInt = Integer.parseInt(value);
            } catch (NumberFormatException e) {
                log.error(e.getMessage());
                throw new JspException(e);
            }
        }
        return retInt;
    }

    /**
     * ݃y[WAy[Wy[WReLXgɕۑB
     * 
     * @param now ݃y[W
     * @param total y[W
     */
    protected void attributePageCount(
            int now, int total) {

        if (total <= 0) {
            now = 0;
        }

        //݃y[Wy[WReLXgɕۑB
        if (currentPageIndex != null && !"".equals(currentPageIndex)) {
            pageContext.setAttribute(currentPageIndex, now);
        } else {
            pageContext.setAttribute(CURRENT_PAGE_INDEX , now);
        }

        //y[Wy[WReLXgɕۑB
        if (totalPageCount != null && !"".equals(totalPageCount)) {
            pageContext.setAttribute(totalPageCount, total);
        } else {
            pageContext.setAttribute(TOTAL_PAGE_COUNT, total);
        }
    }

    /**
     * ׂẴAP[gꂽB
     */
    @Override
    public void release() {
        super.release();
        id = null;
        action = null;
        name = null;
        rowProperty = null;
        indexProperty = null;
        totalProperty = null;
        scope = null;
        submit = false;
        forward = false;
        event = DEFAULT_EVENT;
        resetIndex = false;
        currentPageIndex = CURRENT_PAGE_INDEX;
        totalPageCount = TOTAL_PAGE_COUNT;
    }

}
