/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.thin.tutorial.web.action;

import jp.terasoluna.fw.service.thin.BLogicMessage;
import jp.terasoluna.fw.service.thin.BLogicMessages;
import jp.terasoluna.fw.service.thin.BLogicResult;
import jp.terasoluna.fw.web.struts.actions.AbstractBLogicAction;
import jp.terasoluna.thin.tutorial.service.bean.UserBean;
import jp.terasoluna.thin.tutorial.service.blogic.RegisterBLogic;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.Globals;

/**
 * ͏o^ANVB
 *
 * o^srWlXWbNĂсA͂ꂽlf[^x[Xɓo^B
 *
 */
public class RegisterAction extends AbstractBLogicAction<UserBean> {

    /**
     * ONXB
     */
    private Log log = LogFactory.getLog(RegisterAction.class);

    /**
     * ͏o^rWlXWbNNXB
     */
    private RegisterBLogic registBLogic = null;

    /**
     * ͏o^rWlXWbNԋpB
     *
     * @return ێ͏o^rWlXWbN
     */
    public RegisterBLogic getRegistBLogic() {
        return registBLogic;
    }

    /**
     * ͏o^rWlXWbNݒ肷B
     *
     * @param registBLogic ͏o^rWlXWbN
     */
    public void setRegistBLogic(RegisterBLogic registBLogic) {
        this.registBLogic = registBLogic;
    }

    /**
     * rWlXWbNsAʂԋpB
     *
     * @param bean ͂ꂽlێbean
     * @return o^ʂێBLogicResult
     * @throws Exception O
     */
    @Override
    public BLogicResult doExecuteBLogic(UserBean bean) throws Exception {

        if (log.isDebugEnabled()) {
            log.debug("doExecuteBLogic Start.");
        }

        //BLogicResult̐Aʂ̐ݒ
        BLogicResult result = new BLogicResult();

        //͏rWlXWbN̎s
        //ԋplAfalsȅꍇ͏dG[B
        //truȅꍇ͓o^ɏIB
        if (!registBLogic.register(bean)) {

            //dG[̏
            setErrors(result, "errors.input.id.repeat", "error");
            result.setResultObject(bean);
            return result;
        }

        //ȏꍇ́Aʕݒ肵ĕԋpB
        result.setResultString("success");
        result.setResultObject(new UserBean());
        return result;
    }

    /**
     * BLogicResultIuWFNg
     * G[bZ[Wьʕݒ肷B
     * 
     * @param result BLogicResultIuWFNg
     * @param errorKey ݒ肷G[L[
     * @param resultString ʕ
     */
    private void setErrors(BLogicResult result, String errorKey,
            String resultString) {
        BLogicMessages errors = result.getErrors();
        if (errors == null) {
            errors = new BLogicMessages();
        }
        errors.add(Globals.ERROR_KEY,
                new BLogicMessage(errorKey));
        result.setErrors(errors);
        result.setResultString(resultString);
    }
}
