/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.thin.tutorial.service.blogic;

import java.util.HashMap;
import java.util.Map;

import jp.terasoluna.fw.service.thin.BLogic;
import jp.terasoluna.fw.service.thin.BLogicMessage;
import jp.terasoluna.fw.service.thin.BLogicMessages;
import jp.terasoluna.fw.service.thin.BLogicResult;
import jp.terasoluna.fw.web.UserValueObject;
import jp.terasoluna.thin.tutorial.web.SampleUVO;

/**
 * OIsrWlXWbNB
 *
 */
public class LogonBLogic implements BLogic<Map<String, String>> {

    /**
     * OIsB
     *
     * @param params ͂ꂽ[UIDێMap
     * @return OIʂێBLogicResult
     */
    public BLogicResult execute(Map<String, String> params) {

        //͂ꂽ[UID̎擾
        String userId = params.get("userId");

        //UVO̐
        SampleUVO uvo = (SampleUVO) UserValueObject.createUserValueObject();

        //[UIDUVOɐݒ肷B
        uvo.setUserId(userId);

        //UVOԋppMapɕێB
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("uvo", uvo);

        //BLogicResult̐Aݒ
        BLogicResult result = new BLogicResult();
        result.setResultObject(map);
        result.setResultString("success");

        //\郁bZ[W̐Aݒ
        BLogicMessages messages = new BLogicMessages();
        messages.add("logon.message",
                new BLogicMessage("logon.message", userId));
        result.setMessages(messages);

        return result;
    }

}
