/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.struts.reset;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import jp.terasoluna.fw.beans.JXPathIndexedBeanWrapperImpl;
import jp.terasoluna.fw.util.BeanUtil;
import jp.terasoluna.fw.util.PropertyAccessException;
import jp.terasoluna.fw.web.RequestUtil;
import jp.terasoluna.fw.web.struts.ModuleUtil;
import jp.terasoluna.fw.web.struts.form.FormEx;
import jp.terasoluna.fw.web.struts.reset.ActionReset;
import jp.terasoluna.fw.web.struts.reset.Resetter;
import jp.terasoluna.fw.web.struts.reset.ResetterResources;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResetterImpl
implements Resetter {
    private static Log log = LogFactory.getLog(ResetterImpl.class);

    @Override
    public void reset(FormEx form, ActionMapping mapping, HttpServletRequest request) {
        ActionReset reset;
        if (log.isDebugEnabled()) {
            log.debug((Object)(mapping.getName() + " reset() called."));
        }
        if ((reset = this.getActionReset(mapping, request)) == null) {
            return;
        }
        Iterator<String> it = reset.getFieldNames();
        JXPathIndexedBeanWrapperImpl wrapper = new JXPathIndexedBeanWrapperImpl(form);
        while (it.hasNext()) {
            String fieldName = it.next();
            if (log.isDebugEnabled()) {
                log.debug((Object)("reset[" + fieldName + "]"));
            }
            Map<String, Object> propMap = wrapper.getIndexedPropertyValues(fieldName);
            if (reset.isSelectField(fieldName) && propMap.size() > 1) {
                this.resetSelectField(form, propMap, request);
                continue;
            }
            for (Map.Entry<String, Object> e : propMap.entrySet()) {
                this.resetValue(form, e);
            }
        }
    }

    protected void resetValue(FormEx form, Map.Entry<String, Object> entry) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("resetValue(" + form + ", " + entry.getKey() + ") called."));
        }
        String propName = entry.getKey();
        try {
            Object value = entry.getValue();
            if (value == null) {
                return;
            }
            Class<?> type = null;
            type = value.getClass();
            if (type != null) {
                if (type == Boolean.TYPE || type == Boolean.class) {
                    BeanUtil.setBeanProperty(form, propName, Boolean.FALSE);
                } else if (type == Byte.TYPE || type == Byte.class) {
                    BeanUtil.setBeanProperty(form, propName, new Byte(0));
                } else if (type == Character.TYPE || type == Character.class) {
                    BeanUtil.setBeanProperty(form, propName, new Character('\u0000'));
                } else if (type == Double.TYPE || type == Double.class) {
                    BeanUtil.setBeanProperty(form, propName, new Double(0.0));
                } else if (type == Float.TYPE || type == Float.class) {
                    BeanUtil.setBeanProperty(form, propName, new Float(0.0f));
                } else if (type == Integer.TYPE || type == Integer.class) {
                    BeanUtil.setBeanProperty(form, propName, new Integer(0));
                } else if (type == Long.TYPE || type == Long.class) {
                    BeanUtil.setBeanProperty(form, propName, new Long(0L));
                } else if (type == Short.TYPE || type == Short.class) {
                    BeanUtil.setBeanProperty(form, propName, new Short(0));
                } else {
                    BeanUtil.setBeanProperty(form, propName, null);
                }
            }
        }
        catch (PropertyAccessException e) {
            log.error((Object)("cannot access property " + form + "." + propName), (Throwable)e);
        }
    }

    protected ResetterResources getResetterResources(HttpServletRequest request) {
        String prefix = ModuleUtil.getPrefix(request);
        ServletContext application = RequestUtil.getServletContext(request);
        ResetterResources resources = (ResetterResources)application.getAttribute("RESETTER_RESOURCES" + prefix);
        return resources;
    }

    protected ActionReset getActionReset(ActionMapping mapping, HttpServletRequest request) {
        ResetterResources resources = this.getResetterResources(request);
        if (resources == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"ResetterResources is null.");
            }
            return null;
        }
        ActionReset reset = resources.get(mapping.getPath());
        if (reset == null && log.isDebugEnabled()) {
            log.debug((Object)("action path:" + mapping.getPath() + " is not specified to reset."));
        }
        return reset;
    }

    protected void resetSelectField(FormEx form, Map<String, Object> propMap, HttpServletRequest request) {
        int size;
        if (log.isDebugEnabled()) {
            log.debug((Object)"resetSelectField() called.");
        }
        int startIndex = 0;
        int endIndex = size = propMap.size();
        try {
            String startIndexStr = request.getParameter("startIndex");
            String endIndexStr = request.getParameter("endIndex");
            if (startIndexStr != null) {
                startIndex = Integer.parseInt(startIndexStr);
            }
            if (endIndexStr != null) {
                endIndex = Integer.parseInt(endIndexStr);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("startIndex = [" + startIndex + "]"));
                log.debug((Object)("endIndex = [" + endIndex + "]"));
            }
        }
        catch (NumberFormatException e) {
            log.error((Object)"startIndex or endIndex is not Number.", (Throwable)e);
            return;
        }
        Set<Map.Entry<String, Object>> set = propMap.entrySet();
        int index = 0;
        for (Map.Entry<String, Object> e : set) {
            if (index >= startIndex && startIndex < size && index <= endIndex && index < size) {
                this.resetValue(form, e);
            }
            ++index;
        }
    }
}

