/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.beans.jxpath;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import org.apache.commons.jxpath.DynamicPropertyHandler;
import org.apache.commons.jxpath.MapDynamicPropertyHandler;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodePointer;

import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.beans.jxpath.DynamicPropertyPointerEx} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * nulll߂MappvpeB|C^gNXB<br>
 * OF
 * <p>
 * 
 * @see jp.terasoluna.fw.beans.jxpath.DynamicPropertyPointerEx
 */
public class DynamicPropertyPointerExTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(DynamicPropertyPointerExTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public DynamicPropertyPointerExTest(String name) {
        super(name);
    }

    /**
     * testGetLength01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() getBaseValue():null<br>
     *         
     * <br>
     * ҒlF(߂l) -:1<br>
     *         
     * <br>
     * vf̒lnull̏ꍇ̃eXgBPԂB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
	public void testGetLength01() throws Exception {
        // O
    	QName qName = new QName("name");
    	Map map = new HashMap();
    	map.put("key", null);
    	DynamicPropertyHandler handler = new MapDynamicPropertyHandler();
    	Locale locale = new Locale("ja");
    	NodePointer nodePointer = NodePointer.newNodePointer(qName, map, locale);
    	DynamicPropertyPointerEx pointer 
    		= new DynamicPropertyPointerEx(nodePointer, handler);
    	pointer.setPropertyName("key");

        // eXg{
    	assertEquals(1, pointer.getLength());
    }

    /**
     * testGetLength02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() getBaseValue():not null<br>
     *         () ValueUtils.getLength(value):ĂяomFsȂ<br>
     *         
     * <br>
     * ҒlF(߂l) -:ValueUtils.getLength(value)̌<br>
     *         
     * <br>
     * vfnullł͂Ȃꍇ̃eXgBValueUtils.getLength()ԂB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
	public void testGetLength02() throws Exception {
        // O
    	QName qName = new QName("name");
    	Map map = new HashMap();
    	map.put("key", new String[]{"a", "b", "c"});
    	DynamicPropertyHandler handler = new MapDynamicPropertyHandler();
    	Locale locale = new Locale("ja");
    	NodePointer nodePointer = NodePointer.newNodePointer(qName, map, locale);
    	DynamicPropertyPointerEx pointer 
    		= new DynamicPropertyPointerEx(nodePointer, handler);
    	pointer.setPropertyName("key");

        // eXg{
    	assertEquals(3, pointer.getLength());
    }

}
