/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.taglib;

import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import jp.terasoluna.utlib.PropertyTestCase;
import jp.terasoluna.utlib.TagUTUtil;

/**
 * JDateTag ubN{bNXeXgB<br>
 * O<br>
 * Ȃ<br>
 * <br>
 */
public class JDateTagTest extends PropertyTestCase {

    // eXgΏ
    JDateTag tag = null;

    /**
     * Constructor for JDateTagTest.
     * @param arg0
     */
    public JDateTagTest(String arg0) {
        super(arg0);
        tag = (JDateTag) TagUTUtil.create(JDateTag.class);
    }
    
    /*
     * @see PropertyTestCase#setUpData()
     */
    @Override
    protected void setUpData() throws Exception {
        /*
         * vpeBt@C̕ςƂȂMap̍쐬B
         */
        Map<String, String> m = new HashMap<String, String>();
        m.put("wareki.gengo.0.name", "");
        m.put("wareki.gengo.0.roman", "H");
        m.put("wareki.gengo.0.startDate", "1989/01/08");
        m.put("wareki.gengo.1.name", "a");
        m.put("wareki.gengo.1.roman", "S");
        m.put("wareki.gengo.1.startDate", "1926/12/25");
        m.put("wareki.gengo.2.name", "吳");
        m.put("wareki.gengo.2.roman", "T");
        m.put("wareki.gengo.2.startDate", "1912/07/30");
        m.put("wareki.gengo.3.name", "");
        m.put("wareki.gengo.3.roman", "M");
        m.put("wareki.gengo.3.startDate", "1868/09/04");
        // vpeBƂMapǉB
        addPropertyAll(m);
    }

    /*
     * @see PropertyTestCase#cleanUpData()
     */
    @Override
    protected void cleanUpData() throws Exception {}

    /**
     * testDoFormat01B<br>
     * <br>
     * (n)<br>
     * ϓ_FE<br>
     * <br>
     * ͒l<br>
     * date="2004-11-24 10:31:00.000000000"<br>
     * pattern="Gyy.MM.dd"<br>
     * <br>
     * Ғl<br>
     * ߂l:String="H16.11.24"<br>
     * <br>
     * dateсApatternNullł͂Ȃꍇ̃eXgP[X<br>
     */
    public void testDoFormat01() throws Exception {

        // eXgݒ
        Timestamp time = Timestamp.valueOf("2004-11-24 10:31:00.000000000");
        Date date = new Date(time.getTime());
        tag.pattern = "Gyy.MM.dd";

        // eXgs
        String result = tag.doFormat(date);

        // eXgʊmF
        assertEquals("H16.11.24", result);

    } /* testDoFormat01 End */

} /* JDateTagTest Class End */
