/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.PropertyTestCase;

import org.apache.commons.validator.Field;
import org.apache.commons.validator.Msg;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorResources;
import org.apache.commons.validator.Var;
import org.apache.struts.Globals;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

/**
 * {@link jp.terasoluna.fw.web.struts.form.FieldChecksEx}
 * NX̃ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * Validatorǉ[NXB
 * <p>
 *
 * @see jp.terasoluna.fw.web.struts.form.FieldChecksEx
 */
public class FieldChecksExTest05 extends PropertyTestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(FieldChecksExTest05.class);
    }

    /**
     * sB
     *
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#setUpData()
     */
    @Override
    protected void setUpData() throws Exception {
        LogUTUtil.flush();
        deleteProperty("validation.hankaku.kana.list");
        deleteProperty("validation.zenkaku.kana.list");
    }

    /**
     * IsB
     *
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#cleanUpData()
     */
    @Override
    protected void cleanUpData() throws Exception {
    }

    /**
     * RXgN^B
     *
     * @param name ̃eXgP[X̖OB
     */
    public FieldChecksExTest05(String name) {
        super(name);
    }

    /**
     * testValidateStringLength01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:null<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:stringLength=null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) O:OxF<br>
     *                    G[<br>
     *                    bZ[WF<br>
     *                    bean is null.<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * beannull̂ƂAG[Oo͂trueԋp邱Ƃ
     * mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateStringLength01() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = null;
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("stringLength");
        var.setValue(null);
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateStringLength(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());

        // G[OmF
        assertTrue(LogUTUtil.checkError("bean is null."));
    }

    /**
     * testValidateStringLength02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:""<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:stringLength="4"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * bean󕶎̂ƂAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateStringLength02() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");

        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        Var var = new Var();
        var.setName("stringLength");
        var.setValue("4");
        field.addVar(var);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateStringLength(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateStringLength03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:"abc0#"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:stringLength=null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * fieldstringLength̒lnull̂ƂAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateStringLength03() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "abc0#";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("stringLength");
        var.setValue(null);
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateStringLength(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateStringLength04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:"abc0#"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:stringLength=""<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * fieldstringLength̒l󕶎̂ƂAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateStringLength04() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "abc0#";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        Var var = new Var();
        var.setName("stringLength");
        var.setValue("");
        field.addVar(var);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateStringLength(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateStringLength05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:"abc0#"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:stringLength="A"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF<br>
     *                    "stringLength is not numeric(integer)."<br>
     *                    OFNumberFormatException<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * fieldstringLength̒llɕϊłȂƂAtrue擾ł邱Ƃ
     * mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateStringLength05() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "abc0#";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        Var var = new Var();
        var.setName("stringLength");
        var.setValue("A");
        field.addVar(var);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateStringLength(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());

        // G[OmF
        assertTrue(
            LogUTUtil.checkError("stringLength is not numeric(integer).",
                    new NumberFormatException()));
    }

    /**
     * testValidateStringLength06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:"abc"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:stringLength="4"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * fieldstringLengthŎw肳ꂽlƁAbeaňvꍇA
     * trueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateStringLength06() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "abc";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        Var var = new Var();
        var.setName("stringLength");
        var.setValue("4");
        field.addVar(var);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateStringLength(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateStringLength07()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:"abc0#"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:stringLength="4"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                ActionMessage("testMessage")<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("testMessage")<br>
     *                    ActionMessage("message")<br>
     *
     * <br>
     * fieldstringLengthŎw肳ꂽlƁAbeaňvȂꍇA
     * falseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateStringLength07() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "abc0#";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        Var var = new Var();
        var.setName("stringLength");
        var.setValue("4");
        field.addVar(var);

        // G[iActionMessage1ݒj
        ActionMessages errors = new ActionMessages();
        ActionMessage error = new ActionMessage("testMessage");
        errors.add(Globals.ERROR_KEY, error);

        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateStringLength(
                bean,
                va,
                field,
                errors,
                validator,
                request);

        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[ɃG[IuWFNg2o^Ă邱ƁB
        assertEquals(2, errors.size());
        // G[ɐݒ肳ꂽbZ[Wo^Ă邱ƁB
        // ActionMessage㏑ȂƁB
        Iterator it = errors.get();
        List<String> list = new ArrayList<String>();
        while (it.hasNext()) {
            ActionMessage retError = (ActionMessage) it.next();
            list.add(retError.getKey());
        }
        assertTrue(list.contains("testMessage"));
        assertTrue(list.contains("message"));
    }

    /**
     * testValidateStringLength08()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:Map:["field1"="a 1 "]<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:stringLength="5"<br>
     *                Msg("message","message")<br>
     *                property="field1"<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * beanString^ł͂ȂꍇAfield擾ÕvpeB
     * ΂ă`FbNsƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateStringLength08() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        Map<String, String> bean = new HashMap<String, String>();
        bean.put("field1", "a 1 ");

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("field1");
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        Var var = new Var();
        var.setName("stringLength");
        var.setValue("5");
        field.addVar(var);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateStringLength(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateStringLength09()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:Map:["field1"="1234"]<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:stringLength="5"<br>
     *                Msg("message","message")<br>
     *                property="field1"<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("message")<br>
     *
     * <br>
     * beanString^ł͂ȂꍇAfield擾ÕvpeB
     * ΂ă`FbNsƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateStringLength09() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        Map<String, String> bean = new HashMap<String, String>();
        bean.put("field1", "1234");

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("field1");
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        Var var = new Var();
        var.setName("stringLength");
        var.setValue("5");
        field.addVar(var);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateStringLength(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[ɃG[IuWFNgo^Ă邱ƁB
        assertEquals(1, errors.size());
        // G[ɐݒ肳ꂽbZ[Wo^Ă邱ƁB
        Iterator it = errors.get();
        ActionMessage error = (ActionMessage) it.next();
        assertEquals("message", error.getKey());
    }

    /**
     * testValidateStringLength10()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:Map:["field1"="123"]<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:stringLength="5"<br>
     *                Msg("message","message")<br>
     *                property="field2"<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * beanString^ł͂ȂAfield擾ÕvpeB
     * ݂ȂꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateStringLength10() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        Map<String, String> bean = new HashMap<String, String>();
        bean.put("field1", "123");

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("field2");
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        Var var = new Var();
        var.setName("stringLength");
        var.setValue("5");
        field.addVar(var);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateStringLength(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateByteLength01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:null<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:byteLength=null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) O:OxF<br>
     *                    G[<br>
     *                    bZ[WF<br>
     *                    bean is null.<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * beannull̂ƂAG[Oo͂trueԋp邱Ƃ
     * mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateByteLength01() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = null;
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("byteLength");
        var.setValue(null);
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateByteLength(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());

        // G[OmF
        assertTrue(LogUTUtil.checkError("bean is null."));
    }

    /**
     * testValidateByteLength02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:""<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:byteLength="4"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * bean󕶎̂ƂAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateByteLength02() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("byteLength");
        var.setValue("4");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateByteLength(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateByteLength03()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:String:"abc0#"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:byteLength=null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) O:OxF<br>
     *                    bZ[WF<br>
     *                    "length is not specified."<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * fieldbyteLength̒lnull̂ƂAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateByteLength03() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "abc0#";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("byteLength");
        var.setValue(null);
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateByteLength(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());

        // 񃍃O`FbN
        assertTrue(LogUTUtil.checkInfo("length is not specified."));
    }

    /**
     * testValidateByteLength04()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:String:"abc0#"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:byteLength=""<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) O:OxF<br>
     *                    bZ[WF<br>
     *                    "length is not specified."<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * fieldbyteLength̒l󕶎̂ƂAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateByteLength04() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "abc0#";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("byteLength");
        var.setValue("");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateByteLength(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());

        // 񃍃O`FbN
        assertTrue(LogUTUtil.checkInfo("length is not specified."));
    }

    /**
     * testValidateByteLength05()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:"abc0#"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:byteLength="A"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF<br>
     *                    "byteLength is not numeric(integer)."<br>
     *                    OFNumberFormatException<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * fieldbyteLength̒llɕϊłȂƂA
     * true擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateByteLength05() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "abc0#";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("byteLength");
        var.setValue("A");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateByteLength(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());

        // 񃍃O`FbN
        assertTrue(LogUTUtil.checkError("byteLength is not numeric(integer).",
                new NumberFormatException()));
    }

    /**
     * testValidateByteLength06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:""<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:byteLength="3"<br>
     *                encoding="UTF-8"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * fieldbyteLengthŎw肳ꂽlƁAbeañoCgvꍇA
     * trueԋp邱ƂmFB<br>
     * getByteLength\bh̃eXg܂B
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateByteLength06() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("byteLength");
        var.setValue("3");
        field.addVar(var);
        // GR[fBO̐ݒ
        var = new Var();
        var.setName("encoding");
        var.setValue("UTF-8");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateByteLength(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateByteLength07()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:""<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:byteLength="3"<br>
     *                encoding="Windows-31J"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                ActionMessage("testMessage")<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("testMessage")<br>
     *                    ActionMessage("message")<br>
     *
     * <br>
     * fieldbyteLengthŎw肳ꂽlƁAbeaňvȂꍇA
     * falseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateByteLength07() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("byteLength");
        var.setValue("3");
        field.addVar(var);
        // GR[fBO̐ݒ
        var = new Var();
        var.setName("encoding");
        var.setValue("Windows-31J");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);

        // G[iActionMessage1ݒj
        ActionMessages errors = new ActionMessages();
        ActionMessage error = new ActionMessage("testMessage");
        errors.add(Globals.ERROR_KEY, error);

        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateByteLength(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[1ł邱ƁB
        assertEquals(2, errors.size());
        // bZ[WIuWFNǧ
        Iterator it = errors.get();
        List<String> list = new ArrayList<String>();
        while (it.hasNext()) {
            ActionMessage retError = (ActionMessage) it.next();
            list.add(retError.getKey());
        }
        assertTrue(list.contains("testMessage"));
        assertTrue(list.contains("message"));
    }

    /**
     * testValidateByteLength08()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:""<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:byteLength="2"<br>
     *                encoding=null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                ActionMessage("testMessage")<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * fieldencodingnull̏ꍇAVM̃ftHg̃GR[fBO
     * ͕̃oCgvZ邱ƂmFB<br>
     * getByteLength\bh̃eXg܂B
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateByteLength08() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("byteLength");
        var.setValue("2");
        field.addVar(var);
        // GR[fBO̐ݒ
        var = new Var();
        var.setName("encoding");
        var.setValue(null);
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateByteLength(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪂ȂƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateByteLength09()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:""<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:byteLength="2"<br>
     *                encoding=""<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                ActionMessage("testMessage")<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * fieldencoding󕶎̏ꍇAVM̃ftHg̃GR[fBO
     * ͕̃oCgvZ邱ƂmFB<br>
     * getByteLength\bh̃eXg܂B
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateByteLength09() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("byteLength");
        var.setValue("2");
        field.addVar(var);
        // GR[fBO̐ݒ
        var = new Var();
        var.setName("encoding");
        var.setValue("");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateByteLength(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪂ȂƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateByteLength10()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:""<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:byteLength="2"<br>
     *                encoding="test-encoding"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                ActionMessage("testMessage")<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) O:OxFx<br>
     *                    bZ[WF<br>
     *                    "test-encoding is not supported."<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * fieldencodingT|[gȂGR[fBȌꍇA
     * VM̃ftHg̃GR[fBOœ͕̃oCgvZ邱ƂmFB<br>
     * getByteLength\bh̃eXg܂B
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateByteLength10() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("byteLength");
        var.setValue("2");
        field.addVar(var);
        // GR[fBO̐ݒ
        var = new Var();
        var.setName("encoding");
        var.setValue("test-encoding");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateByteLength(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪂ȂƁB
        assertTrue(errors.isEmpty());

        // xÕ`FbN
        assertTrue(LogUTUtil.checkWarn("test-encoding is not supported."));
    }

    /**
     * testValidateByteLength11()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:Map:["field1"=""]<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:byteLength="9"<br>
     *                var:encoding="UTF-8"<br>
     *                Msg("message","message")<br>
     *                property="field1"<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * beanString^ł͂ȂꍇAfield擾ÕvpeB
     * ɑ΂ă`FbNsƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateByteLength11() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        Map<String, String> bean = new HashMap<String, String>();
        bean.put("field1", "");
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("field1");
        Var var = new Var();
        var.setName("byteLength");
        var.setValue("9");
        field.addVar(var);
        // GR[fBO̐ݒ
        var = new Var();
        var.setName("encoding");
        var.setValue("UTF-8");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateByteLength(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪂ȂƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateByteLength12()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:Map:["field1"="1234"]<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:byteLength="5"<br>
     *                encoding="Windows-31J"<br>
     *                Msg("message","message")<br>
     *                property="field1"<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("message")<br>
     *
     * <br>
     * beanString^ł͂ȂꍇAfield擾ÕvpeB
     * ɑ΂ă`FbNsƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateByteLength12() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        Map<String, String> bean = new HashMap<String, String>();
        bean.put("field1", "1234");
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("field1");
        Var var = new Var();
        var.setName("byteLength");
        var.setValue("5");
        field.addVar(var);
        // GR[fBO̐ݒ
        var = new Var();
        var.setName("encoding");
        var.setValue("Windows-31J");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateByteLength(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[1邱ƁB
        assertEquals(1, errors.size());

        // bZ[WIuWFNǧ
        Iterator it = errors.get();
        ActionMessage message = (ActionMessage) it.next();
        assertEquals("message", message.getKey());
    }

    /**
     * testValidateByteLength13()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:Map:["field1"="123"]<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:byteLength="5"<br>
     *                encoding="UTF-8"<br>
     *                Msg("message","message")<br>
     *                property="field2"<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * beanString^ł͂ȂAfield擾ÕvpeB
     * ݂ȂꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateByteLength13() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        Map<String, String> bean = new HashMap<String, String>();
        bean.put("field1", "123");
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("field2");
        Var var = new Var();
        var.setName("byteLength");
        var.setValue("5");
        field.addVar(var);
        // GR[fBO̐ݒ
        var = new Var();
        var.setName("encoding");
        var.setValue("UTF-8");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateByteLength(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪂ȂƁB
        assertTrue(errors.isEmpty());
    }

}
