/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.actions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.struts.action.ActionForward;

import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.web.struts.action.ActionMappingEx;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.web.struts.actions.ClearSessionAction}
 * NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * ZbVw肳ꂽvpeB폜NX
 * <p>
 * 
 * @see jp.terasoluna.fw.web.struts.actions.ClearSessionAction
 */
@SuppressWarnings("unused")
public class ClearSessionActionTest extends TestCase {

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        LogUTUtil.flush();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public ClearSessionActionTest(String name) {
        super(name);
    }

    /**
     * testSetClearSessionKeys01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() clearSessionKeys:ArrayListIuWFNg<br>
     *         () clearSessionKeys:null<br>
     *         
     * <br>
     * ҒlF(ԕω) clearSessionKeys:ƓArrayListIuWFNg<br>
     *         
     * <br>
     * Ɏw肵ltB[hclearSessionKeysɐɊi[邱ƂmF
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetClearSessionKeys01() throws Exception {
        // O
        // clearSessionKeysݒ
        List<String> list = new ArrayList<String>();
        list.add("test");
        
        ClearSessionAction action = new ClearSessionAction();
        action.setClearSessionKeys(list);

        // eXgsEʊmF
        assertSame(list, UTUtil.getPrivateField(action, "clearSessionKeys"));
    }

    /**
     * testDoExecute01()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () clearSessionKeys:null<br>
     *         () path:null<br>
     *         () res.sendError():IOException<br>
     *         
     * <br>
     * ҒlF(ԕω) O:SystemExceptionF<br>
     *                    bZ[WL[F"error.forward.errorpage"<br>
     *                    bvOFIOException<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "Error page(404) forwarding failed."<br>
     *         
     * <br>
     * mappingp[^̎擾ʂnullłA
     * HttpServletResponse.sendError()ďoŗOꍇA
     * w肵pXɃZbVfBNgꂽmFB
     * ܂SystemException邱ƂmF
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoExecute01() throws Exception {
        // O
        ClearSessionAction action = new ClearSessionAction();
        
        // p[^̐ݒ
        ActionMappingEx mapping = new ActionMappingEx();
        
        // path : null
        String path = null;
        mapping.setParameter(path);
        
        ClearSessionAction_ActionFormStub01 form =
            new ClearSessionAction_ActionFormStub01();
        
        MockHttpServletRequest req = new MockHttpServletRequest();
        
        // sendErrořĂяomFp
        ClearSessionAction_HttpServletResponseStub02 res =
            new ClearSessionAction_HttpServletResponseStub02();
        
        ActionForward forward = null;

        // eXg{
        try {
            forward = action.doExecute(mapping, form, req, res);
            fail("O܂ł");
        } catch (SystemException e) {
            // 
            // IOExceptionbv
            assertEquals(IOException.class.getName(), e.getCause().getClass()
                    .getName());
            // G[OmF
            assertTrue(LogUTUtil.checkError(
                    "Error page(404) forwarding failed."));
            assertEquals("error.forward.errorpage", e.getErrorCode());
        }
    }

    /**
     * testDoExecute02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () clearSessionKeys:0ArrayList<br>
     *         () path:null<br>
     *         
     * <br>
     * ҒlF(߂l) actionForward:null<br>
     *         (ԕω) res.sendError():ĂяomF<br>
     *         
     * <br>
     * clearSessionKeys0ArrayListłApathnullꍇA
     * res.sendRedirect()ĂяonullԂƂmF
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoExecute02() throws Exception {
        // O
        ClearSessionAction action = new ClearSessionAction();
        
        // clearSessionKeys
        List<String> list = new ArrayList<String>();
        UTUtil.setPrivateField(action, "clearSessionKeys", list);
        
        // p[^̐ݒ
        ActionMappingEx mapping = new ActionMappingEx();
        
        // path : null
        String path = null;
        mapping.setParameter(path);
        
        ClearSessionAction_ActionFormStub01 form =
            new ClearSessionAction_ActionFormStub01();
        
        MockHttpServletRequest req = new MockHttpServletRequest();
        
        // sendErrořĂяomFp
        ClearSessionAction_HttpServletResponseStub01 res =
            new ClearSessionAction_HttpServletResponseStub01();
        
        ActionForward forward = null;

        // eXg{
        forward = action.doExecute(mapping, form, req, res);
        
        // 
        assertNull(forward);
        assertTrue(res.isSendError);
    }

    /**
     * testDoExecute03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () clearSessionKeys:vf"abc"ĂArrayList<br>
     *         () session.getAttribute():session.getAttribute("abc")"session01"<br>
     *         () path:"abc"<br>
     *         
     * <br>
     * ҒlF(߂l) actionForward:ActionForward.getPath()F"abc"<br>
     *         (ԕω) session.getAttribute():session.getAttribute("abc")null<br>
     *         
     * <br>
     * clearSessionKeys1ArrayList̏ꍇA̗vf̕ɊY
     * session̑폜Ă邱ƂƁAʑJڂsƂmF
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoExecute03() throws Exception {
        // O
        ClearSessionAction action = new ClearSessionAction();
        
        // clearSessionKeys
        List<String> list = new ArrayList<String>();
        list.add("abc");
        UTUtil.setPrivateField(action, "clearSessionKeys", list);
        
        // p[^̐ݒ
        ActionMappingEx mapping = new ActionMappingEx();
        
        // path : "abc"
        String path = "abc";
        mapping.setParameter(path);
        
        ClearSessionAction_ActionFormStub01 form =
            new ClearSessionAction_ActionFormStub01();
        
        ClearSessionAction_HttpServletRequestStub01 req =
            new ClearSessionAction_HttpServletRequestStub01();
        
        // sessionݒ
        ClearSessionAction_HttpSessionStub01 session =
            (ClearSessionAction_HttpSessionStub01) req.getSession(false);
        
        // sessionݒ
        Map<String, String> attrs = new HashMap<String, String>();
        attrs.put("abc", "session01");
        UTUtil.setPrivateField(session, "attrs", attrs);
        
        
        // sendErrořĂяomFp
        ClearSessionAction_HttpServletResponseStub01 res =
            new ClearSessionAction_HttpServletResponseStub01();
        
        ActionForward forward = null;

        // eXg{
        forward = action.doExecute(mapping, form, req, res);
        
        // 
        assertEquals("abc", forward.getPath());
        
        session = (ClearSessionAction_HttpSessionStub01) req.getSession(false);
        assertNull(session.getAttribute("abc"));
    }

    /**
     * testDoExecute04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () clearSessionKeys:vf"abc01"A"abc02"A"abc03"Lq
     *         ĂArrayList<br>
     *         () session.getAttribute():session.getAttribute("abc01")
     *         "session01"<br>
     *                session.getAttribute("abc02")"session02"<br>
     *                session.getAttribute("abc03")"session03"<br>
     *                session.getAttribute("abc04")"session04"<br>
     *         () path:"abc"<br>
     *         
     * <br>
     * ҒlF(߂l) actionForward:ActionForward.getPath()F"abc"<br>
     *         (ԕω) session.getAttribute():session.getAttribute("abc01")
     *         null<br>
     *                    session.getAttribute("abc02")null<br>
     *                    session.getAttribute("abc03")null<br>
     *                    session.getAttribute("abc04")"session04"<br>
     *         
     * <br>
     * clearSessionKeysArrayList̏ꍇA̗vf̕ɊY
     * session̑S폜Ă邱ƂƁAʑJڂsƂmF
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoExecute04() throws Exception {
        // O
        ClearSessionAction action = new ClearSessionAction();
        
        // clearSessionKeys
        List<String> list = new ArrayList<String>();
        list.add("abc01");
        list.add("abc02");
        list.add("abc03");
        
        UTUtil.setPrivateField(action, "clearSessionKeys", list);
        
        // p[^̐ݒ
        ActionMappingEx mapping = new ActionMappingEx();
        
        // path : "abc"
        String path = "abc";
        mapping.setParameter(path);
        
        ClearSessionAction_ActionFormStub01 form =
            new ClearSessionAction_ActionFormStub01();
        
        ClearSessionAction_HttpServletRequestStub01 req =
            new ClearSessionAction_HttpServletRequestStub01();
        
        // sessionݒ
        ClearSessionAction_HttpSessionStub01 session =
            (ClearSessionAction_HttpSessionStub01) req.getSession(false);
        
        // sessionݒ
        Map<String, String> attrs = new HashMap<String, String>();
        attrs.put("abc01", "session01");
        attrs.put("abc02", "session02");
        attrs.put("abc03", "session03");
        attrs.put("abc04", "session04");
        UTUtil.setPrivateField(session, "attrs", attrs);
        
        
        // sendErrořĂяomFp
        ClearSessionAction_HttpServletResponseStub01 res =
            new ClearSessionAction_HttpServletResponseStub01();
        
        ActionForward forward = null;

        // eXg{
        forward = action.doExecute(mapping, form, req, res);
        
        // 
        assertEquals("abc", forward.getPath());
        
        session = (ClearSessionAction_HttpSessionStub01) req.getSession(false);
        assertNull(session.getAttribute("abc01"));
        assertNull(session.getAttribute("abc02"));
        assertNull(session.getAttribute("abc03"));
        assertEquals("session04", session.getAttribute("abc04"));
    }
}
