/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts;

import org.apache.struts.Globals;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.impl.ModuleConfigImpl;

import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.MockHttpSession;
import jp.terasoluna.utlib.MockServletContext;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.web.struts.ModuleUtil} NX̃ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * ModuleConfig Ɋւ郆[eBeBB
 * <p>
 *
 * @see jp.terasoluna.fw.web.struts.ModuleUtil
 */
public class ModuleUtilTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(ModuleUtilTest.class);
    }

    /**
     * sB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     *
     * @param name ̃eXgP[X̖OB
     */
    public ModuleUtilTest(String name) {
        super(name);
    }

    /**
     * testGetModuleConfig01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() request:null<br>
     *
     * <br>
     * ҒlF(߂l) ModuleConfig:null<br>
     *
     * <br>
     * requestnull̏ꍇAnull擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetModuleConfig01() throws Exception {
        // eXg{
        Object result = ModuleUtil.getModuleConfig(null);

        assertNull(result);
    }

    /**
     * testGetModuleConfig02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() request:not null<br>
     *         () request.getAttribute(<br>
     *                    Globals.MODULE_KEY):null<br>
     *         () ServletContext.getAttribute(<br>
     *                    Globals.MODULE_KEY):not null<br>
     *
     * <br>
     * ҒlF(߂l) ModuleConfig:T[ubgReLXgGlobals.MODULE_KEYœo^Ă<br>
     *                  ftHgW[ԋpB<br>
     *
     * <br>
     * NGXgModuleConfig݂AT[ubgReLXgɑ݂ꍇAT[ubgReLXgModuleConfig擾ĕԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetModuleConfig02() throws Exception {
        //eXgf[^ݒ

        // [NGXg
        MockHttpServletRequest req = new MockHttpServletRequest();
        // W[RtBO
        ModuleConfig apConfig = new ModuleConfigImpl("");
        // [ZbV
        MockHttpSession session = new MockHttpSession();
        // [T[ubgReLXg
        MockServletContext context = new MockServletContext();

        // W[RtBOT[ubgReLXĝ݂ɓo^ĂB
        req.setAttribute(Globals.MODULE_KEY, null);
        context.setAttribute(Globals.MODULE_KEY, apConfig);
        session.setServletContext(context);
        req.setSession(session);

        //eXgs
        ModuleConfig retConfig = ModuleUtil.getModuleConfig(req);

        //eXgʊmF

        // T[ubgReLXgɓo^Ă郂W[RtBO
        // ԋp邱
        assertSame(apConfig, retConfig);
    }

    /**
     * testGetModuleConfig03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() request:not null<br>
     *         () request.getAttribute(<br>
     *                    Globals.MODULE_KEY):not null<br>
     *         () ServletContext.getAttribute(<br>
     *                    Globals.MODULE_KEY):null<br>
     *
     * <br>
     * ҒlF(߂l) ModuleConfig:HTTPNGXgGlobals.MODULE_KEYœo^ĂftHgW[<br>
     *                  ԋpB<br>
     *
     * <br>
     * NGXgModuleConfig݂ꍇANGXgModuleConfig擾ĕԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetModuleConfig03() throws Exception {
        //eXgf[^ݒ

        // [NGXg
        MockHttpServletRequest req = new MockHttpServletRequest();
        // W[RtBO(NGXgɓo^)
        ModuleConfig reqConfig = new ModuleConfigImpl("/sub1");
        req.setAttribute(Globals.MODULE_KEY, reqConfig);

        // [ZbV
        MockHttpSession session = new MockHttpSession();
        // [T[ubgReLXg
        MockServletContext context = new MockServletContext();
        // W[RtBO(T[ubgReLXgɓo^)
        ModuleConfig apConfig = new ModuleConfigImpl("");

        // T[ubgReLXgɂW[RtBOo^ĂB
        context.setAttribute(Globals.MODULE_KEY, apConfig);
        session.setServletContext(context);
        req.setSession(session);

        //eXgs
        ModuleConfig retConfig = ModuleUtil.getModuleConfig(req);

        //eXgʊmF

        // NGXgɓo^Ă郂W[RtBO
        // ԋp邱
        assertSame(reqConfig, retConfig);
    }

    /**
     * testGetModuleConfig04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() request:not null<br>
     *         () request.getAttribute(<br>
     *                    Globals.MODULE_KEY):null<br>
     *         () ServletContext.getAttribute(<br>
     *                    Globals.MODULE_KEY):null<br>
     *
     * <br>
     * ҒlF(߂l) ModuleConfig:null<br>
     *
     * <br>
     * NGXgAT[ubgReLXgModuleConfig݂ȂꍇAnullԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetModuleConfig04() throws Exception {
        //eXgf[^ݒ

        // [NGXg
        MockHttpServletRequest req = new MockHttpServletRequest();

        // [ZbV
        MockHttpSession session = new MockHttpSession();

        // [T[ubgReLXg
        MockServletContext context = new MockServletContext();

        session.setServletContext(context);
        req.setSession(session);

        //eXgs
        ModuleConfig retConfig = ModuleUtil.getModuleConfig(req);

        //eXgʊmF

        // T[ubgReLXgɓo^Ă郂W[RtBO
        // ԋp邱
        assertNull(retConfig);
    }

    /**
     * testGetPrefix01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() request:null<br>
     *
     * <br>
     * ҒlF(߂l) String:null<br>
     *
     * <br>
     * requestnull̏ꍇAnullԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetPrefix01() throws Exception {
        Object result = ModuleUtil.getPrefix(null);
        assertNull(result);
    }

    /**
     * testGetPrefix02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() request:not null<br>
     *         () getModuleConfiǧ:null<br>
     *
     * <br>
     * ҒlF(߂l) String:null<br>
     *
     * <br>
     * getModuleConfignullԋpꍇAnullԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetPrefix02() throws Exception {
        //eXgf[^ݒ

        // [NGXg
        MockHttpServletRequest req = new MockHttpServletRequest();

        // [ZbV
        MockHttpSession session = new MockHttpSession();

        // [T[ubgReLXg
        MockServletContext context = new MockServletContext();

        session.setServletContext(context);
        req.setSession(session);

        //eXgs
        Object result = ModuleUtil.getPrefix(req);

        //eXgʊmF
        assertNull(result);
    }

    /**
     * testGetPrefix03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() request:not null<br>
     *         () getModuleConfiǧ:not null<br>
     *                prefix="abc"<br>
     *
     * <br>
     * ҒlF(߂l) String:abc<br>
     *
     * <br>
     * ModuleConfigprefix̒lԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetPrefix03() throws Exception {
        //eXgf[^ݒ

        // [NGXg
        MockHttpServletRequest req = new MockHttpServletRequest();
        // W[RtBO
        ModuleConfig apConfig = new ModuleConfigImpl("abc");
        // [ZbV
        MockHttpSession session = new MockHttpSession();
        // [T[ubgReLXg
        MockServletContext context = new MockServletContext();

        // W[RtBOT[ubgReLXĝ݂ɓo^ĂB
        req.setAttribute(Globals.MODULE_KEY, null);
        context.setAttribute(Globals.MODULE_KEY, apConfig);
        session.setServletContext(context);
        req.setSession(session);

        //eXgs
        String prefix = ModuleUtil.getPrefix(req);

        //eXgʊmF

        // T[ubgReLXgɓo^Ă郂W[RtBO
        // ԋp邱
        assertEquals("abc", prefix);
    }

    /**
     * testGetPrefix04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() request:not null<br>
     *         () getModuleConfiǧ:not null<br>
     *                prefix=null<br>
     *
     * <br>
     * ҒlF(߂l) String:null<br>
     *
     * <br>
     * ModuleConfigprefix̒lԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetPrefix04() throws Exception {
        //eXgf[^ݒ

        // [NGXg
        MockHttpServletRequest req = new MockHttpServletRequest();
        // W[RtBO
        ModuleConfig apConfig = new ModuleConfigImpl(null);
        // [ZbV
        MockHttpSession session = new MockHttpSession();
        // [T[ubgReLXg
        MockServletContext context = new MockServletContext();

        // W[RtBOT[ubgReLXĝ݂ɓo^ĂB
        req.setAttribute(Globals.MODULE_KEY, null);
        context.setAttribute(Globals.MODULE_KEY, apConfig);
        session.setServletContext(context);
        req.setSession(session);

        //eXgs
        String prefix = ModuleUtil.getPrefix(req);

        //eXgʊmF

        // T[ubgReLXgɓo^Ă郂W[RtBO
        // ԋp邱
        assertNull(prefix);
    }

}
