/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.codelist;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.sql.DataSource;

import jp.terasoluna.utlib.MockDataSource;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.UncategorizedSQLException;

/**
 * {@link jp.terasoluna.fw.web.codelist.DBCodeListLoader} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * R[hXg̏f[^x[XpčsNX<br>
 * EO<br>
 * Eutlib.confpӂDBڑLq邱ƁB<br>
 * Ecreate_dbcodetest.sqlŐݒ肳DB񂪂炩ߐݒ肳ĂKvB<br>
 * ̃t@C̒ł͈ȉ̂悤DB쐬AeXgp^[ɉL̗vfDBɐݒ肷B<br>
 * DB̖OFDBCODETEST<br>
 * JFKEY, VALUE<br>
 * vfF <br>
 * iPjKEY = '1' , VALUE = 'abc'<br>
 * iQjKEY = '2' , VALUE = 'xyz'<br>
 * iRjKEY = '3' , VALUE = ''
 * <p>
 * 
 * @see jp.terasoluna.fw.web.codelist.DBCodeListLoader
 */
@SuppressWarnings("unchecked")
public class DBCodeListLoaderTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(DBCodeListLoaderTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        
        // DBf[^ݒ       
        UTUtil.deleteAll("DBCODETEST");
        String[][] data = { { "KEY", "VALUE" }, { "1", "abc" }, { "2", "xyz" },
                { "3", "" } };
        UTUtil.setData("DBCODETEST", data);
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        
        // DBf[^폜       
        UTUtil.deleteAll("DBCODETEST");
        
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public DBCodeListLoaderTest(String name) {
        super(name);
    }

    /**
     * testLoad01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() codeLists:not null<br>
     *         
     * <br>
     * ҒlF(ԕω) loadCodeList():sȂB<br>
     *         
     * <br>
     * codeLists݂ꍇ͉I邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLoad01() throws Exception {
        // O
        DBCodeListLoaderImpl01 loader = new DBCodeListLoaderImpl01();
        List codeLists = new ArrayList();
        UTUtil.setPrivateField(loader, "codeLists", codeLists);
        
        // eXg{
        loader.load();

        // 
        assertFalse(loader.isLoadCodeListIsCalled());
    }

    /**
     * testLoad02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() codeLists:null<br>
     *         
     * <br>
     * ҒlF(ԕω) loadCodeList():sB<br>
     *         
     * <br>
     * codeLists݂ȂꍇloadCodeList()Ăяo邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLoad02() throws Exception {
        // O
        DBCodeListLoaderImpl01 loader = new DBCodeListLoaderImpl01();
        UTUtil.setPrivateField(loader, "codeLists", null);
        
        // eXg{
        loader.load();

        // 
        assertTrue(loader.isLoadCodeListIsCalled());
    }

    /**
     * testReload01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() codeLists:not null<br>
     *         
     * <br>
     * ҒlF(ԕω) loadCodeList():sB<br>
     *         
     * <br>
     * ̃\bhĂ΂loadCodeList()Ă΂邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testReload01() throws Exception {
        // O
        DBCodeListLoaderImpl01 loader = new DBCodeListLoaderImpl01();
        List codeLists = new ArrayList();
        UTUtil.setPrivateField(loader, "codeLists", codeLists);
        
        // eXg{
        loader.reload();

        // 
        assertTrue(loader.isLoadCodeListIsCalled());
    }

    /**
     * testReload02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() codeLists:null<br>
     *         
     * <br>
     * ҒlF(ԕω) loadCodeList():sB<br>
     *         
     * <br>
     * codeListsnull̏ꍇłloadCodeList()Ă΂邱ƂmFBisynchronizedɌĂԁj
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testReload02() throws Exception {
        // O
        DBCodeListLoaderImpl01 loader = new DBCodeListLoaderImpl01();
        UTUtil.setPrivateField(loader, "codeLists", null);
        
        // eXg{
        loader.reload();

        // 
        assertTrue(loader.isLoadCodeListIsCalled());
    }

    /**
     * testLoadCodeList01()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() codeLists:null<br>
     *         () dataSource:null<br>
     *         () sql:SELECT KEY,VALUE FROM DBCODETEST WHERE KEY = '1' AND KEY = '3'<br>
     *         
     * <br>
     * ҒlF(ԕω) O:InvalidDataAccessApiUsageException<br>
     *                    bZ[WFProperty 'dataSource' is required<br>
     *         
     * <br>
     * dataSourcenull̏ꍇInvalidDataAccessApiUsageException邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLoadCodeList01() throws Exception {
        // O
        DBCodeListLoader loader = new DBCodeListLoader();
        UTUtil.setPrivateField(loader, "sql",
            "SELECT KEY,VALUE FROM DBCODETEST WHERE KEY = '1' AND KEY = '3'");
        UTUtil.setPrivateField(loader, "codeLists", null);
        UTUtil.setPrivateField(loader, "dataSource", null);
        
        // eXg{
        try {
            loader.loadCodeList();
        } catch (InvalidDataAccessApiUsageException e) {
            // 
            assertEquals("Property 'dataSource' is required", e.getMessage());   
        }
    }

    /**
     * testLoadCodeList02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_F
     * <br><br>
     * ͒lF() codeLists:null<br>
     *         () dataSource:not null<br>
     *         () sql:SELECT KEY,VALUE FROM DBCODETEST WHERE KEY = '1' AND KEY = '3' ORDER BY KEY ASC<br>
     *         
     * <br>
     * ҒlF(ԕω) codeLists:ʂ2ݒ肳B<br>
     *                    codeLists0ԖځFid = 1,name = 'abc'<br>
     *                    codeLists1ԖځFid = 3,name = ''<br>
     *         
     * <br>
     * sqlݒ肳ĂꍇɂSQLpČ邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLoadCodeList02() throws Exception {
        // O
        DBCodeListLoader loader = new DBCodeListLoader();
        DataSource ds = new MockDataSource();
        UTUtil.setPrivateField(loader, "codeLists", null);
        UTUtil.setPrivateField(loader, "dataSource", ds);
        UTUtil.setPrivateField(loader, "sql",
            "SELECT KEY,VALUE FROM DBCODETEST WHERE KEY = '1' OR KEY = '3' ORDER BY KEY ASC");
        
        // eXg{
        loader.loadCodeList();
        
        // 
        List<CodeBean> result = (List) UTUtil.getPrivateField(loader, "codeLists");
        
        assertEquals(2, result.size());
        assertEquals("1", result.get(0).getId());
        assertEquals("abc", result.get(0).getName());
        assertEquals("3", result.get(1).getId());
        assertEquals("", result.get(1).getName());

    }

    /**
     * testLoadCodeList06()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() codeLists:null<br>
     *         () dataSource:not null<br>
     *         () sql:null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:InvalidDataAccessApiUsageException<br>
     *                    bZ[WFProperty 'sql' is required<br>
     *         
     * <br>
     * SQL݂ȂꍇAInvalidDataAccessApiUsageException邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLoadCodeList06() throws Exception {
        // O
        DBCodeListLoader loader = new DBCodeListLoader();
        DataSource ds = new MockDataSource();
        UTUtil.setPrivateField(loader, "codeLists", null);
        UTUtil.setPrivateField(loader, "dataSource", ds);
        UTUtil.setPrivateField(loader, "sql", null);

        // eXg{
        try {
            loader.loadCodeList();
        } catch (InvalidDataAccessApiUsageException e) {
            // 
            assertEquals("Property 'sql' is required", e.getMessage());
        }
    }

    /**
     * testLoadCodeList07()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() codeLists:null<br>
     *         () dataSource:not null<br>
     *         () sql:SELECT KEY,VALUE FROM DBCODETEST WHERE KEY = '200' ORDER BY KEY ASC<br>
     *         () sqlł̎擾:ʂ0<br>
     *         
     * <br>
     * ҒlF(ԕω) codeLists:List<br>
     *         
     * <br>
     * ʂ0̏ꍇAListo^邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLoadCodeList07() throws Exception {
        // O
        DBCodeListLoader loader = new DBCodeListLoader();
        DataSource ds = new MockDataSource();
        UTUtil.setPrivateField(loader, "codeLists", null);
        UTUtil.setPrivateField(loader, "dataSource", ds);
        UTUtil.setPrivateField(loader, "sql", "SELECT KEY,VALUE FROM DBCODETEST WHERE KEY = '200' ORDER BY KEY ASC");

        // eXg{
        loader.loadCodeList();

        // 
        List result = (List) UTUtil.getPrivateField(loader, "codeLists");
        assertEquals(0, result.size());
    }

    /**
     * testLoadCodeList08()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() codeLists:null<br>
     *         () dataSource:not null<br>
     *         () sql:SELECT KEY,VALUE FROM DBCODETEST WHERE KEY = '1'<br>
     *         () sqlł̎擾:ʂ1<br>
     *         
     * <br>
     * ҒlF(ԕω) codeLists:ʂ1ݒ肳B<br>
     *                    codeLists0ԖځFid = 1,name = 'abc'<br>
     *         
     * <br>
     * ʂP̏ꍇɐɓo^邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLoadCodeList08() throws Exception {
        // O
        DBCodeListLoader loader = new DBCodeListLoader();
        DataSource ds = new MockDataSource();
        UTUtil.setPrivateField(loader, "codeLists", null);
        UTUtil.setPrivateField(loader, "dataSource", ds);
        UTUtil.setPrivateField(loader, "sql", "SELECT KEY,VALUE FROM DBCODETEST WHERE KEY = '1'");

        // eXg{
        loader.loadCodeList();

        // 
        List<CodeBean> result = (List) UTUtil.getPrivateField(loader,
                "codeLists");
        assertEquals(1, result.size());
        assertEquals("1", result.get(0).getId());
        assertEquals("abc", result.get(0).getName());
    }

    /**
     * testLoadCodeList09()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() codeLists:null<br>
     *         () dataSource:not null<br>
     *         () sql:SELECT KEY,VALUE FROM DBCODETEST WHERE KEY <= '3' ORDER BY KEY ASC<br>
     *         () sqlł̎擾:ʂ3<br>
     *         
     * <br>
     * ҒlF(ԕω) codeLists:ʂ3ݒ肳B<br>
     *                    codeLists0ԖځFid = 1,name = 'abc'<br>
     *                    codeLists1ԖځFid = 2,name = 'xyz'<br>
     *                    codeLists2ԖځFid = 3,name = ''<br>
     *         
     * <br>
     * ʂȐꍇɐɓo^邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLoadCodeList09() throws Exception {
        // O
        DBCodeListLoader loader = new DBCodeListLoader();
        DataSource ds = new MockDataSource();
        UTUtil.setPrivateField(loader, "codeLists", null);
        UTUtil.setPrivateField(loader, "dataSource", ds);
        UTUtil.setPrivateField(loader, "sql", "SELECT KEY,VALUE FROM DBCODETEST WHERE KEY <= '3' ORDER BY KEY ASC");

        // eXg{
        loader.loadCodeList();

        // 
        List<CodeBean> result = (List) UTUtil.getPrivateField(loader,
                "codeLists");
        assertEquals(3, result.size());
        assertEquals("1", result.get(0).getId());
        assertEquals("abc", result.get(0).getName());
        assertEquals("2", result.get(1).getId());
        assertEquals("xyz", result.get(1).getName());
        assertEquals("3", result.get(2).getId());
        assertEquals("", result.get(2).getName());
    }

    /**
     * testLoadCodeList10()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() codeLists:null<br>
     *         () dataSource:not null<br>
     *         () sql:SELECT KEY,VALUE FROM NODB<br>
     *         () sqlł̎擾:e[u݂Ȃ<br>
     *         
     * <br>
     * ҒlF(ԕω) O:BadSqlGrammarException<br>
     *                    bvꂽOFSQLException<br>
     *         
     * <br>
     * SQLŎw肵e[u݂ȂꍇBadSqlGrammarException邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLoadCodeList10() throws Exception {
        // O
        DBCodeListLoader loader = new DBCodeListLoader();
        DataSource ds = new MockDataSource();
        UTUtil.setPrivateField(loader, "codeLists", null);
        UTUtil.setPrivateField(loader, "dataSource", ds);
        UTUtil.setPrivateField(loader, "sql", "SELECT KEY,VALUE FROM NODB");

        // eXg{
        try {
            loader.loadCodeList();
            fail();
        } catch (BadSqlGrammarException e) {
            // 
            assertEquals(SQLException.class.getName(), e.getCause().getClass()
                    .getName());

        } finally {
            // PostgreSQL̏ꍇABadSqlGrammarExceptionꍇA
            // [obNsȂƁAȍ~̃eXgɉe^
        	UTUtil.getConnection().rollback();
        }
    }

    /**
     * testLoadCodeList11()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() codeLists:null<br>
     *         () dataSource:not null<br>
     *         () sql:""<br>
     *         
     * <br>
     * ҒlF(ԕω) O:UncategorizedSQLException<br>
     *         
     * <br>
     * SQL󕶎̏ꍇUncategorizedSQLException邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLoadCodeList11() throws Exception {
        // O
        DBCodeListLoader loader = new DBCodeListLoader();
        DataSource ds = new MockDataSource();
        UTUtil.setPrivateField(loader, "codeLists", null);
        UTUtil.setPrivateField(loader, "dataSource", ds);
        UTUtil.setPrivateField(loader, "sql", "");

        // eXg{
        try {
            loader.loadCodeList();
            fail();
        } catch (UncategorizedSQLException e) {
            // 
            // Oraclȅꍇ́Ae.getCause()SQLExceptionłB
            // Postgres̏ꍇ́Ae.getCause()org.postgresql.util.PSQLExceptionłB        	
        }
    }

    /**
     * testLoadCodeList12()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() codeLists:null<br>
     *         () dataSource:not null<br>
     *         () sql:UPDATE DBCODETEST SET VALUE = 'test'<br>
     *         
     * <br>
     * ҒlF(ԕω) O:DataAccessException<br>
     *
     * <br>
     * SQLSELECTł͂ȂUPDATEsꂽꍇDataAccessException邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLoadCodeList12() throws Exception {
        // O
        DBCodeListLoader loader = new DBCodeListLoader();
        DataSource ds = new MockDataSource();
        UTUtil.setPrivateField(loader, "codeLists", null);
        UTUtil.setPrivateField(loader, "dataSource", ds);
        UTUtil.setPrivateField(loader, "sql", "UPDATE DBCODETEST SET VALUE = 'test'");

        // eXg{
        try {
            loader.loadCodeList();
            fail();
        } catch (DataAccessException e) {
            // 
            // Oraclȅꍇ́AeBadSqlGrammarExceptionłA
            //           e.getCause()SQLExceptionłB
            // Postgres̏ꍇ́AeUncategorizedSQLExceptionłA
            //           e.getCause()org.postgresql.util.PSQLExceptionłB
        }
    }

    /**
     * testLoadCodeList13()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() codeLists:null<br>
     *         () dataSource:not null<br>
     *         () sql:aaaaa<br>
     *         
     * <br>
     * ҒlF(ԕω) O:BadSqlGrammarException<br>
     *                    bvꂽOFSQLException<br>
     *         
     * <br>
     * SQL̕@ԈĂꍇABadSqlGrammarException邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLoadCodeList13() throws Exception {
        // O
        DBCodeListLoader loader = new DBCodeListLoader();
        DataSource ds = new MockDataSource();
        UTUtil.setPrivateField(loader, "codeLists", null);
        UTUtil.setPrivateField(loader, "dataSource", ds);
        UTUtil.setPrivateField(loader, "sql", "aaaaa");

        // eXg{
        try {
            loader.loadCodeList();
            fail();
        } catch (BadSqlGrammarException e) {
            // 
            assertEquals(SQLException.class.getName(), e.getCause().getClass()
                    .getName());
            
        } finally {
        	// PostgreSQL̏ꍇABadSqlGrammarExceptionꍇA
            // [obNsȂƁAȍ~̃eXgɉe^
        	UTUtil.getConnection().rollback();
        }
    }

    /**
     * testGetCodeBeans01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() codeLists:null<br>
     *         
     * <br>
     * ҒlF(߂l) CodeBean[]:̔z<br>
     *         
     * <br>
     * codeListsnull̏ꍇ̔z񂪕Ԃ邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetCodeBeans01() throws Exception {
        // O
        DBCodeListLoader loader = new DBCodeListLoader();
        UTUtil.setPrivateField(loader, "codeLists", null);

        // eXg{
        CodeBean[] result = loader.getCodeBeans();

        // 
        assertEquals(0, result.length);
    }

    /**
     * testGetCodeBeans02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() codeLists:̃Xg<br>
     *         
     * <br>
     * ҒlF(߂l) CodeBean[]:̔z<br>
     *         
     * <br>
     * codeLists̃Xg̏ꍇ̔z񂪕Ԃ邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetCodeBeans02() throws Exception {
        // O
        DBCodeListLoader loader = new DBCodeListLoader();
        List<CodeBean> codeLists = new ArrayList<CodeBean>();
        UTUtil.setPrivateField(loader, "codeLists", codeLists);

        // eXg{
        CodeBean[] result = loader.getCodeBeans();

        // 
        assertEquals(0, result.length);
    }

    /**
     * testGetCodeBeans03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() codeLists:CodeBean1XgBg͈ȉ̂ƂB<br>
     *                iPjid = "id1"@name="name1"<br>
     *         
     * <br>
     * ҒlF(߂l) CodeBean[]:id = "id1"@name="name1"CodeBeanzB<br>
     *         
     * <br>
     * codeListsPvfꍇcodeListsɓĂPvfz񂪕Ԃ邱ƂmFB炪V[Rs[łȂfB[vRs[ł邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetCodeBeans03() throws Exception {
        // O
        DBCodeListLoader loader = new DBCodeListLoader();
        List<CodeBean> codeLists = new ArrayList<CodeBean>();
        CodeBean codeBean = new CodeBean();
        codeBean.setId("id1");
        codeBean.setName("name1");
        codeLists.add(codeBean);
        UTUtil.setPrivateField(loader, "codeLists", codeLists);

        // eXg{
        CodeBean[] result = loader.getCodeBeans();

        // 
        assertEquals(1, result.length);
        assertEquals("id1", result[0].getId());
        assertEquals("name1", result[0].getName());
        assertNotSame(codeBean, result[0]);
    }

    /**
     * testGetCodeBeans04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() codeLists:CodeBean3XgBg͈ȉ̂ƂB<br>
     *                iPjid = "id1"@name="name1"<br>
     *                iQjid = "id2"@name="name2"<br>
     *                iRjid = "id3"@name="name3"<br>
     *         
     * <br>
     * ҒlF(߂l) CodeBean[]:iPjid = "id1"@name="name1"<br>
     *                  iQjid = "id2"@name="name2"<br>
     *                  iRjid = "id3"@name="name3"<br>
     *                  ̂RCodeBeanzB<br>
     *         
     * <br>
     * codeListsRvfꍇcodeListsɓĂRvfz񂪕Ԃ邱ƂmFB炪V[Rs[łȂfB[vRs[ł邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetCodeBeans04() throws Exception {
        // O
        DBCodeListLoader loader = new DBCodeListLoader();
        List<CodeBean> codeLists = new ArrayList<CodeBean>();
        CodeBean codeBean = new CodeBean();
        codeBean.setId("id1");
        codeBean.setName("name1");
        CodeBean codeBean2 = new CodeBean();
        codeBean2.setId("id2");
        codeBean2.setName("name2");
        CodeBean codeBean3 = new CodeBean();
        codeBean3.setId("id3");
        codeBean3.setName("name3");
        codeLists.add(codeBean);
        codeLists.add(codeBean2);
        codeLists.add(codeBean3);
        UTUtil.setPrivateField(loader, "codeLists", codeLists);

        // eXg{
        CodeBean[] result = loader.getCodeBeans();

        // 
        assertEquals(3, result.length);
        assertEquals("id1", result[0].getId());
        assertEquals("name1", result[0].getName());
        assertNotSame(codeBean, result[0]);
        assertEquals("id2", result[1].getId());
        assertEquals("name2", result[1].getName());
        assertNotSame(codeBean2, result[1]);
        assertEquals("id3", result[2].getId());
        assertEquals("name3", result[2].getName());
        assertNotSame(codeBean3, result[2]);
    }

    /**
     * testGetDataSource01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() this.dataSource:not null<br>
     *         
     * <br>
     * ҒlF(߂l) DataSource:not null<br>
     *         
     * <br>
     * nꌏ̂݃eXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetDataSource01() throws Exception {
        // O
        DBCodeListLoader loader = new DBCodeListLoader();
        DataSource ds = new MockDataSource();
        UTUtil.setPrivateField(loader, "dataSource", ds);
        
        // eXg{E
        assertSame(ds, loader.getDataSource());
    }

    /**
     * testSetDataSource01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() dataSource:not null<br>
     *         () this.dataSource:null<br>
     *         
     * <br>
     * ҒlF(ԕω) this.dataSource:not null<br>
     *         
     * <br>
     * nꌏ̂݃eXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetDataSource01() throws Exception {
        // O
        DBCodeListLoader loader = new DBCodeListLoader();
        DataSource ds = new MockDataSource();
        
        // eXg{
        loader.setDataSource(ds);

        // 
        assertSame(ds, UTUtil.getPrivateField(loader, "dataSource"));
    }

    /**
     * testGetSQL01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() sql:"abc"<br>
     *         
     * <br>
     * ҒlF(߂l) String:"abc"<br>
     *         
     * <br>
     * nꌏ̂݃eXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSql01() throws Exception {
        // O
        DBCodeListLoader loader = new DBCodeListLoader();
        UTUtil.setPrivateField(loader, "sql", "abc");
        
        // eXg{E
        assertEquals("abc", loader.getSql());
    }

    /**
     * testSetSql01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() sql:"abc"<br>
     *         () this.sql:null<br>
     *         
     * <br>
     * ҒlF(ԕω) this.sql:"abc"<br>
     *         
     * <br>
     * nꌏ̂݃eXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetSql01() throws Exception {
        // O
        DBCodeListLoader loader = new DBCodeListLoader();
        
        // eXg{
        loader.setSql("abc");

        // 
        assertEquals("abc", UTUtil.getPrivateField(loader, "sql"));
    }

}
