/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.service.thin;

import java.util.HashMap;
import java.util.Map;

import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.service.thin.BLogicResources} NX
 * ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * rWlXWbNo͏ێNXB<br>
 * blogic-io.xmlǂݍ܂ꂽݒ͂̃NXeƂȂێB
 * X̐ݒBLogicIOABLogicPropertỹCX^XƂĕێB
 * <p>
 * 
 * @see jp.terasoluna.fw.service.thin.BLogicResources
 */
public class BLogicResourcesTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(BLogicResourcesTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public BLogicResourcesTest(String name) {
        super(name);
    }

    /**
     * testGetBLogicIO01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() path:"path"<br>
     *         () bLogicIO:keyF"path"AvalueFBLogicIOi[path="path"]j<br>
     *         
     * <br>
     * ҒlF(߂l) BLogicIO:[path="path"]<br>
     *         
     * <br>
     * BLogicResourcesɊi[ĂblogicIOw肳ꂽKey̓e𐳏Ɏ擾邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetBLogicIO01() throws Exception {
        //rWlXWbN̕ێ
        BLogicResources blogicResources = new BLogicResources();

        //eXglݒ
        Map<String, BLogicIO> map = new HashMap<String, BLogicIO>();
        BLogicIO bLogicIO = new BLogicIO();
        UTUtil.setPrivateField(bLogicIO, "path", "path");
        map.put("path", bLogicIO);

        //blogicIOݒ
        UTUtil.setPrivateField(blogicResources, "blogicIO", map);

        //eXgsEʊmF
        BLogicIO resultBLogicIO = blogicResources.getBLogicIO("path");
        assertEquals("path", UTUtil.getPrivateField(resultBLogicIO, "path"));
    }

    /**
     * testGetBLogicIO02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() path:"path"<br>
     *         () bLogicIO:keyF"path"AvalueFnull<br>
     *         
     * <br>
     * ҒlF(߂l) BLogicIO:null<br>
     *         
     * <br>
     * BLogicResourcesɊi[ĂblogicIOw肳ꂽKey̓enull̏ꍇA
     * null𐳏Ɏ擾邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetBLogicIO02() throws Exception {
        //rWlXWbN̕ێ
        BLogicResources blogicResources = new BLogicResources();

        //eXglݒ
        Map<String, BLogicIO> map = new HashMap<String, BLogicIO>();
        map.put("path", null);

        //blogicIOݒ
        UTUtil.setPrivateField(blogicResources, "blogicIO", map);

        //eXgsEʊmF
        assertNull(blogicResources.getBLogicIO("path"));
    }

    /**
     * testGetBLogicIO03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() path:null<br>
     *         () bLogicIO:keyF"path"AvalueFBLogicIOi[path="path"]j<br>
     *         
     * <br>
     * ҒlF(߂l) BLogicIO:null<br>
     *         
     * <br>
     * null̏ꍇAɏI邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetBLogicIO03() throws Exception {
        //rWlXWbN̕ێ
        BLogicResources blogicResources = new BLogicResources();

        //eXglݒ
        Map<String, BLogicIO> map = new HashMap<String, BLogicIO>();
        BLogicIO bLogicIO = new BLogicIO();
        UTUtil.setPrivateField(bLogicIO, "path", "path");
        map.put("path", bLogicIO);

        //blogicIOݒ
        UTUtil.setPrivateField(blogicResources, "blogicIO", map);
        
        //eXgsEʊmF
        assertNull(blogicResources.getBLogicIO(null));
    }

    /**
     * testGetBLogicIO04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() path:""<br>
     *         () bLogicIO:keyF"path"AvalueFBLogicIOi[path="path"]j<br>
     *         
     * <br>
     * ҒlF(߂l) BLogicIO:null<br>
     *         
     * <br>
     * 󕶎̏ꍇAɏI邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetBLogicIO04() throws Exception {
        //rWlXWbN̕ێ
        BLogicResources blogicResources = new BLogicResources();
        
        //eXglݒ
        Map<String, BLogicIO> map = new HashMap<String, BLogicIO>();
        BLogicIO bLogicIO = new BLogicIO();
        UTUtil.setPrivateField(bLogicIO, "path", "path");
        map.put("path", bLogicIO);

        //blogicIOݒ
        UTUtil.setPrivateField(blogicResources, "blogicIO", map);

        //eXgsEʊmF
        assertNull(blogicResources.getBLogicIO(""));
    }

    /**
     * testSetBLogicIO01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() blogicIO:not nulli[path="path"])<br>
     *         () blogicIO:null<br>
     *         
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) O:|<br>
     *         (ԕω) blogicIO:keyF"path"AvalueFBLogicIO([path="path"])ݒ肳B<br>
     *         
     * <br>
     * Ɏw肵BlogicIOpath"path"̎ABLogicResourcesblogicIOKey"path"ƂĐɊi[邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetBLogicIO01() throws Exception {
        //rWlXWbN̕ێ
        BLogicResources blogicResources = new BLogicResources();

        //eXglݒ
        BLogicIO bLogicIO = new BLogicIO();
        UTUtil.setPrivateField(bLogicIO, "path", "path");

        //eXgs
        blogicResources.setBLogicIO(bLogicIO);

        //eXgʊmF
        BLogicIO resultBLogicIO =
            (BLogicIO)
                ((Map) UTUtil.getPrivateField(blogicResources, "blogicIO")).get(
                "path");
        assertEquals("path", UTUtil.getPrivateField(resultBLogicIO, "path"));
    }

    /**
     * testSetBLogicIO02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() blogicIO:not nulli[path=null])<br>
     *         () blogicIO:null<br>
     *         
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) O:|<br>
     *         (ԕω) blogicIO:keyFnullABLogicIO([path=null])ݒ肳B<br>
     *         
     * <br>
     * Ɏw肵BlogicIOpathnull̎ABLogicResourcesblogicIOKeynullƂĐɊi[邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetBLogicIO02() throws Exception {
        //rWlXWbN̕ێ
        BLogicResources blogicResources = new BLogicResources();

        //eXglݒ
        BLogicIO bLogicIO = new BLogicIO();
        UTUtil.setPrivateField(bLogicIO, "path", null);

        //eXgs
        blogicResources.setBLogicIO(bLogicIO);

        //eXgʊmF
        Map resultMap = (Map) UTUtil.getPrivateField(blogicResources,
                "blogicIO");
        assertTrue(resultMap.containsKey(null));

        BLogicIO resultBLogicIO = (BLogicIO) resultMap.get(null);
        assertNull(UTUtil.getPrivateField(resultBLogicIO, "path"));
    }

    /**
     * testSetBLogicIO03()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FCAG
     * <br><br>
     * ͒lF() blogicIO:null<br>
     *         () blogicIO:null<br>
     *         
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) O:NullPointerException<br>
     *         (ԕω) blogicIO:|<br>
     *         
     * <br>
     * null̏ꍇANullPointerException邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetBLogicIO03() throws Exception {
        //rWlXWbN̕ێ
        BLogicResources blogicResources = new BLogicResources();

        //eXgs
        try {
            blogicResources.setBLogicIO(null);
            fail();
        } catch (NullPointerException e) {
            // eXgʊmF
        	return;
        }
    }

}
