/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.taglib;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * <p>
 *  <code>HTML</code>  <code>body</code> ^Og
 *  <code>body</code> ^O̎NXB
 * </p>
 * <p>
 *  <code>PageContext</code>  <code>&quot;ON_LOAD&quot;</code> L[
 *  ߍ܂ꂽXNvg <code>onLoad</code> CxgɒǉB<br>
 *  ̃^OŐ<code>HTML &lt;body&gt;</code> ^Oł́A<code>onLoad
 *  </code>Cxg̃XNvgƂāAJavaScript֐ <code>__onLoad__()
 *  </code>ĂяoBJavaScript֐ <code>__onLoad__()</code> ̒`́A
 *  ̃^OŐ邽߁AHTMLɓJavaScriptLqĂ͂ȂȂB
 * </p>
 * <p>
 *  <code>&quot;styleClass&quot;</code>A<code>&quot;bgcolor&quot;</code>A
 *  <code>&quot;text&quot;</code>A<code>&quot;link&quot;</code>A
 *  <code>&quot;vlink&quot;</code>A<code>&quot;alink&quot;</code> Ƃ
 *  ̃^Ȏ́Â܂܂̃^OHTML <code>&lt;body&gt;</code>
 *  ^ȎƂēWJB
 * </p>
 *
 * <br>
 *
 * <h5>^OT|[g鑮</h5>
 * <p><code>body</code> ^Oł́Aȉ̑T|[gB</p>
 * <br><br>
 * <div align="center">
 *  <table width="90%" border="1" bgcolor="#FFFFFF">
 *   <tr>
 *    <td> <b></b> </td>
 *    <td> <b>ftHgl</b> </td>
 *    <td> <b>K{</b> </td>
 *    <td> <b>s</b> </td>
 *    <td> <b>Tv</b> </td>
 *   </tr>
 *   <tr>
 *    <td> <code>onload</code> </td>
 *    <td> - </td>
 *    <td> <code>false</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left">
 *     ʕ\ɎsJavaScriptB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td> <code>onunload</code> </td>
 *    <td> - </td>
 *    <td> <code>false</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left">
 *     ʃA[hɎsJavaScriptB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td> <code>styleClass</code> </td>
 *    <td> - </td>
 *    <td> <code>false</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left">
 *     X^CV[g̃NXB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td> <code>bgcolor</code> </td>
 *    <td> - </td>
 *    <td> <code>false</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left">
 *     wiFB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td> <code>background</code> </td>
 *    <td> - </td>
 *    <td> <code>false</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left">
 *     wiɐݒ肷摜B
 *    </td>
 *   </tr>
 *   <tr>
 *    <td> <code>text</code> </td>
 *    <td> - </td>
 *    <td> <code>false</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left">
 *     eLXg̐FB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td> <code>link</code> </td>
 *    <td> - </td>
 *    <td> <code>false</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left">
 *     N̐FB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td> <code>vlink</code> </td>
 *    <td> - </td>
 *    <td> <code>false</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left">
 *     ɑIꂽN̐FB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td> <code>alink</code> </td>
 *    <td> - </td>
 *    <td> <code>false</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left">
 *     I𒆂̃N̐FB
 *    </td>
 *   </tr>
 *  </table>
 * </div>
 * <br><br>
 * <h5>JX^^ÕXNveBOϐ</h5>
 * <p>̃^OɂĐݒ肳XNveBOϐ͂܂B</p>
 * <br>
 * <h5>gp@</h5>
 * <li>JSP</li>
 * <code><pre>
 *  &lt;%
 *    String&nbsp;script=&quot;Cӂ̃XNvg&quot;;
 *    pageContext.setAttribute(&quot;ON_LOAD&quot;,&nbsp;script);
 *  %&gt;
 *  EEE
 *  &lt;ts:body&gt;
 *  EEE
 *  &lt;/ts:body&gt;
 * </pre></code>
 * <li>ꂽHTML</li>
 * <code><pre>
 *  &lt;body onLoad="__onLoad__()"&gt;
 *    &lt;script type="text/javascript"&gt;
 *      &lt;!--
 *        function __onLoad__() {
 *          //L["ON_LOAD"pageContextɊi[ꂽXNvg
 *        }
 *      //-->
 *    &lt;/script&gt;
 *  EEE
 *  &lt;/body&gt;
 * </pre></code>
 *
 * @see jp.terasoluna.fw.web.struts.taglib.MessagesPopupTag
 *
 */
public class BodyTag extends TagSupport {

    /**
	 * VAo[WID
	 */
	private static final long serialVersionUID = -3249997220773531400L;

	/**
     * ONXB
     */
    private static Log log = LogFactory.getLog(BodyTag.class);
    
    /**
     * <code>onLoad</code> Cxg̏ɒǉXNvgo߂
     * NGXg̃L[B
     */
    public static final String ON_LOAD_KEY = "ON_LOAD";

    /**
     * ʕ\ɎsJavaScriptB
     */
    private String onload = null;

    /**
     * ʃA[hɎsJavaScriptB
     */
    private String onunload = null;

    /**
     * X^CV[g̃NXB
     */
    private String styleClass = null;

    /**
     * wiFB
     */
    private String bgcolor = null;

    /**
     * wiɐݒ肷摜B
     */
    private String background = null;

    /**
     * eLXg̐FB
     */
    private String text = null;

    /**
     * N̐FB
     */
    private String link = null;

    /**
     * ɑIꂽN̐FB
     */
    private String vlink = null;

    /**
     * I𒆂̃N̐FB
     */
    private String alink = null;

    /**
     * ʕ\ɎsJavaScriptݒ肷B
     *
     * @param value JavaScript
     */
    public void setOnload(String value) {
        this.onload = value;
    }

    /**
     * ʃA[hɎsJavaScriptݒ肷B
     *
     * @param value JavaScript
     */
    public void setOnunload(String value) {
        this.onunload = value;
    }

    /**
     * X^CV[g̃NXݒ肷B
     *
     * @param value NX
     */
    public void setStyleClass(String value) {
        this.styleClass = value;
    }

    /**
     * wiFݒ肷B
     *
     * @param value wiF
     */
    public void setBgcolor(String value) {
        this.bgcolor = value;
    }

    /**
     * wi摜ݒ肷B
     *
     * @param value wiF
     */
    public void setBackground(String value) {
        this.background = value;
    }

    /**
     * eLXg̐Fݒ肷B
     *
     * @param value eLXg̐F
     */
    public void setText(String value) {
        this.text = value;
    }

    /**
     * N̐Fݒ肷B
     *
     * @param value N̐F
     */
    public void setLink(String value) {
        this.link = value;
    }

    /**
     * ɑIꂽN̐Fݒ肷B
     *
     * @param value ɑIꂽN̐F
     */
    public void setVlink(String value) {
        this.vlink = value;
    }

    /**
     * I𒆂̃N̐Fݒ肷B
     *
     * @param value I𒆂̃N̐F
     */
    public void setAlink(String value) {
        this.alink = value;
    }

    /**
     * ^O]JnɌĂ΂郁\bhB
     *
     * @return wB <code>EVAL_BODY_INCLUDE</code>
     * @throws JspException JSPO
     */
    @Override
    public int doStartTag() throws JspException {

        HttpServletRequest req
            = (HttpServletRequest) pageContext.getRequest();
        String onLoadBody = (String) req.getAttribute(ON_LOAD_KEY);

        StringBuilder tag = new StringBuilder();
        tag.append("<body");
        if (onLoadBody != null || onload != null) {
            tag.append(" onLoad=\"__onLoad__()\"");
        }
        if (this.onunload != null) {
            tag.append(" onUnLoad=\"" + this.onunload + "\"");
        }
        if (this.styleClass != null) {
            tag.append(" class=\"" + this.styleClass + "\"");
        }
        if (this.bgcolor != null) {
            tag.append(" bgcolor=\"" + this.bgcolor + "\"");
        }
        if (this.background != null) {
            if (this.background.startsWith("/")) {
                this.background = req.getContextPath() + this.background;
            } else {
                this.background = req.getContextPath() + "/" + this.background;
            }
            tag.append(" background=\"" + this.background + "\"");
        }
        if (this.text != null) {
            tag.append(" text=\"" + this.text + "\"");
        }
        if (this.link != null) {
            tag.append(" link=\"" + this.link + "\"");
        }
        if (this.vlink != null) {
            tag.append(" vlink=\"" + this.vlink + "\"");
        }
        if (this.alink != null) {
            tag.append(" alink=\"" + this.alink + "\"");
        }
        tag.append(">" + System.getProperty("line.separator"));

        StringBuilder func = null;
        if (onLoadBody != null || onload != null) {
            func = new StringBuilder();
            func.append("<script type=\"text/javascript\">"
                        + System.getProperty("line.separator"));
            func.append("<!--" + System.getProperty("line.separator"));
            func.append("function __onLoad__() {"
                        + System.getProperty("line.separator"));
            if (onload != null) {
                func.append("  ");
                func.append(onload);
                if (!onload.endsWith(";")) {
                    func.append(";");
                }
                func.append(System.getProperty("line.separator"));
            }
            if (onLoadBody != null) {
                func.append(onLoadBody);
            }
            func.append("}" + System.getProperty("line.separator"));
            func.append("//-->" + System.getProperty("line.separator"));
            func.append("</script>" + System.getProperty("line.separator"));
        }

        try {
            JspWriter out = pageContext.getOut();
            out.print(tag.toString());
            if (func != null) {
                out.print(func.toString());
            }
        } catch (IOException e) {
            log.error("Output failed.");
            throw new JspTagException(e.toString());
        }

        return EVAL_BODY_INCLUDE;
    }

    /**
     * ^O]IɌĂ΂郁\bhB
     *
     * @return wB <code>EVAL_PAGE</code>
     * @throws JspException JSPO
     */
    @Override
    public int doEndTag() throws JspException {
        try {
            JspWriter out = pageContext.getOut();
            out.print("</body>");
        } catch (IOException e) {
            log.error("Output failed");
            throw new JspTagException(e.toString());
        }

        return EVAL_PAGE;
    }

    /**
     * ^Onh̏B
     */
    @Override
    public void release() {
        super.release();
        this.onload = null;
        this.onunload = null;
        this.styleClass = null;
        this.bgcolor = null;
        this.background = null;
        this.text = null;
        this.link = null;
        this.vlink = null;
        this.alink = null;
    }

}
