/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.codelist;

import java.io.Serializable;

/**
 * R[hƃR[hl(\)ێBeanNXB
 *
 */
public class CodeBean implements Serializable {

    /**
	 * VAo[WID
	 */
	private static final long serialVersionUID = -6727581752645857389L;

	/**
     * id\tB[hlB
     */
    private String id = "";

    /**
     * name\tB[hlB
     */
    private String name = "";

    /**
     * idݒ肷B
     *
     * @param id id\tB[hl
     */
    public void setId(String id) {
        this.id = (id == null) ? "" : id;
    }

    /**
     * idԋpB
     *
     * @return id\tB[hl
     */
    public String getId() {
        return this.id;
    }

    /**
     * nameݒ肷B
     *
     * @param name name\tB[hl
     */
    public void setName(String name) {
        this.name = (name == null) ? "" : name;
    }

    /**
     * nameԋpB
     *
     * @return name\tB[hl
     */
    public String getName() {
        return name;
    }

    /**
     * R[hƃR[hl(\)𔼊pXy[XŘA擾B
     *
     * <p>o͂錋ʂ́AL̂ƂɂȂB<br>
     *  <code>id</code>+(pXy[X)+ <code>name</code>
     * </p>
     *
     * @return R[hƃR[hl(\)𔼊pXy[XŘA
     */
    public String getLabel() {
        return id + " " + name;
    }

    /**
     * R[hƃR[hl(\)J}(",")ŘA擾B
     *
     * <p>o͂錋ʂ́AL̂ƂɂȂB<br>
     *  <code>id</code> + , + <code>name</code>
     * </p>
     *
     * @return R[hƃR[hl(\)J}ŘA
     */
    public String getCodeCommaName() {
        return id + "," + name;
    }
}
