/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich.springmvc.controller;

import java.lang.reflect.Type;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import jp.terasoluna.fw.service.rich.BLogic;
import jp.terasoluna.fw.util.GenericsUtil;
import jp.terasoluna.fw.util.ProxyUtil;
/**
 * BLogicC^tF[XNXspNGXgRg[B
 *
 * <p>
 * <code>DispatcherServlet</code>NA
 * <code>BLogic</code>C^tF[XƖWbNNXsB
 * </p>
 *
 * <p>
 * ƖWbN̎śA{NXs邪A
 * gUNVǗ̐Ӗ́ABLogic󂯎B
 * ƖWbNN̈JavaBeańANGXgoChJavaBeaniR}hjƂȂB
 * </p>
 *
 * <p>
 * ƂāATuNX̍쐬͕svłA{NX𒼐ڗpB
 * AvWFNgƂ̗vɂāA
 * ƖOA㏈Kvȏꍇ́AvWFNgPʂŃTuNX쐬B
 * </p>
 * 
 * <p>
 * 炩TERASOLUNA񋟂Ă
 * NGXgRg[̃x[X`
 * xmlRequestBLogicExecuteController܂
 * queryRequestBLogicExecuteControllerpBean`sƁB
 * ܂Aȉ̃vpeBݒ肷邱ƁB
 * </p>
 * 
 * <p>
 *   <table border="1" CELLPADDING="8">
 *     <th></th>
 *     <th>K{</th>
 *     <th></th>
 *     
 *     <tr>
 *       <td align=center><b>blogic</b></td>
 *       <td></td>
 *       <td>NBLogicBean</td>
 *     </tr>
 *  
 *  </table>
 * 
 * </p>
 * 
 * y<code>Bean`t@C</code>̐ݒz<br>
 * <code><pre>
 *   &lt;bean name="/secure/blogic/max.do"
 *       parent="xmlRequestBLogicExecuteController" scope="singleton"&gt;
 *     &lt;property name="blogic" ref="maxBLogic"/&gt;
 *   &lt;/bean&gt;
 *    xmlRequestBLogicExecuteControlleŕA
 *   BLogicN郊NGXgRg[̒ے`B
 *   ڍׂ́ATerasolunaControllerQƁB
 * </pre></code>
 * </p>
 * 
 *@@see jp.terasoluna.fw.service.rich.BLogic
 *
 * 
 */
public class BLogicController extends TerasolunaController<Object, Object> {
    /**
     * ONXB
     */
    private static Log log = LogFactory.getLog(BLogicController.class);
    
    /**
     * Bean`t@Cɐݒ肳ĂBLogicNXB
     */
    protected BLogic<Object, Object> blogic = null;

    /**
     * BLogicNXݒ肷B
     * @param blogic BLogicNXB
     */
    public void setBlogic(BLogic<Object, Object> blogic) {
        this.blogic = blogic;
    }
    
    /**
     * BLogicNXݒ肷B
     * 
     * @param blogic
     *            BLogicNXB
     */
    public void setBusinessLogic(BLogic<Object, Object> blogic) {

        this.blogic = blogic;
    }
    
    /**
     * DIReiɂăCX^XꂽɌĂ΂郁\bhB
     * K{Null`FbNsB
     */
    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (this.blogic == null) {
            String message = "Cannot create BLogicController "
                + "without blogic(BLogic) being set. "
                + "Check Bean definition file.";
            log.error(message);
            throw new IllegalStateException(message);
        }
    }

    /**
     * R}hIuWFNǧ^擾B
     * {@link jp.terasoluna.fw.service.rich.BLogic}NX
     * execute\bḧ̌^ԂB
     * execute\bhI[o[[hĂꍇAOԂB
     * @return R}hIuWFNǧ^B
     */
    @SuppressWarnings("unchecked")
    @Override
    protected Type getCommandType() {
        return GenericsUtil.resolveParameterizedClass(BLogic.class, ProxyUtil
                .getTargetClass(blogic))[0];
    }
    
    /**
     *  BLogic#execute()𒼐ڌĂяoAƖWbNsB
     *
     * @param command R}hIuWFNg
     * @return fIuWFNg
     * @throws Exception ƖWbNX[ꂽO
     */
    @Override
    protected Object executeService(Object command) throws Exception {
        return this.blogic.execute(command);
    }
}
