/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.rich.functionsample.controllerex.controller;

import jp.terasoluna.fw.web.rich.springmvc.controller.TerasolunaController;
import jp.terasoluna.rich.functionsample.controllerex.bean.ControllerExInputData;
import jp.terasoluna.rich.functionsample.controllerex.bean.ControllerExResultData;
import jp.terasoluna.rich.functionsample.controllerex.service.SumService;

/**
 * Rg[g̃Rg[
 *
 */
public class ControllerExController extends
        TerasolunaController<ControllerExInputData, ControllerExResultData> {
    
    /**
     * Rg[g̃T[rXNX
     */
    protected SumService sumService = null;

    /**
     * Rg[g̃T[rXNX̎s\bhsB
     *
     * @param command ̓NX
     * @return ʃNX
     * @throws Exception O
     */
    @Override
    protected ControllerExResultData executeService(ControllerExInputData 
                                    command) throws Exception {
        return sumService.sum(command);
    }

    /**
     * Rg[g̃T[rXNXݒ肷B
     * @param sumService Rg[g̃T[rXNX
     */
    public void setSumService(SumService sumService) {
        this.sumService = sumService;
    }

}
