/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common.util;

import com.ibatis.common.util.Throttle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ThrottledPool {
    private Throttle throttle;
    private Class type;
    private List pool;

    public ThrottledPool(Class type, int size) {
        try {
            this.throttle = new Throttle(size);
            this.type = type;
            this.pool = Collections.synchronizedList(new ArrayList(size));
            for (int i = 0; i < size; ++i) {
                this.pool.add(type.newInstance());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating class.  Cause: " + e, e);
        }
    }

    public Object pop() {
        this.throttle.increment();
        return this.pool.remove(0);
    }

    public void push(Object o) {
        if (o != null && o.getClass() == this.type) {
            this.pool.add(o);
            this.throttle.decrement();
        }
    }
}

