/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.binding;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import org.exolab.castor.builder.binding.Binding;
import org.exolab.castor.builder.binding.BindingException;
import org.exolab.castor.builder.binding.ComponentBindingType;
import org.exolab.castor.builder.binding.ExtendedBinding;
import org.exolab.castor.builder.binding.IncludeType;
import org.exolab.castor.builder.binding.NamingXMLType;
import org.exolab.castor.builder.binding.PackageType;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class BindingLoader {
    private ExtendedBinding _binding;
    private BindingResolver _resolver = new BindingResolver();
    static /* synthetic */ Class class$org$exolab$castor$builder$binding$Binding;

    public void loadBinding(String url) throws BindingException {
        try {
            InputSource source = this._resolver.resolveEntity(null, url);
            if (source == null) {
                source = new InputSource(url);
            }
            if (source.getSystemId() == null) {
                source.setSystemId(url);
            }
            this.loadBinding(source);
        }
        catch (SAXException ex) {
            throw new BindingException(ex);
        }
        catch (IOException ioe) {
            throw new BindingException(ioe);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadBinding(InputSource source) throws BindingException {
        Binding loaded = null;
        if (this._binding == null) {
            this._binding = new ExtendedBinding();
        }
        Unmarshaller unmarshaller = new Unmarshaller(class$org$exolab$castor$builder$binding$Binding == null ? (class$org$exolab$castor$builder$binding$Binding = BindingLoader.class$("org.exolab.castor.builder.binding.Binding")) : class$org$exolab$castor$builder$binding$Binding);
        unmarshaller.setValidation(true);
        try {
            loaded = (Binding)unmarshaller.unmarshal(source);
            this._binding.setDefaultBindingType(loaded.getDefaultBindingType());
            Enumeration packages = loaded.enumeratePackage();
            while (packages.hasMoreElements()) {
                PackageType tempPackage = (PackageType)packages.nextElement();
                this._binding.addPackage(tempPackage);
            }
            NamingXMLType naming = loaded.getNamingXML();
            if (naming != null) {
                this._binding.setNamingXML(naming);
            }
            Enumeration elements = loaded.enumerateElementBinding();
            while (elements.hasMoreElements()) {
                ComponentBindingType tempComp = (ComponentBindingType)elements.nextElement();
                this._binding.addElementBinding(tempComp);
            }
            Enumeration attributes = loaded.enumerateAttributeBinding();
            while (attributes.hasMoreElements()) {
                ComponentBindingType tempComp = (ComponentBindingType)attributes.nextElement();
                this._binding.addAttributeBinding(tempComp);
            }
            Enumeration complexTypes = loaded.enumerateComplexTypeBinding();
            while (complexTypes.hasMoreElements()) {
                ComponentBindingType tempComp = (ComponentBindingType)complexTypes.nextElement();
                this._binding.addComplexTypeBinding(tempComp);
            }
            Enumeration groups = loaded.enumerateGroupBinding();
            while (groups.hasMoreElements()) {
                ComponentBindingType tempComp = (ComponentBindingType)groups.nextElement();
                this._binding.addGroupBinding(tempComp);
            }
            Enumeration includes = loaded.enumerateInclude();
            while (includes.hasMoreElements()) {
                IncludeType tempInclude = (IncludeType)includes.nextElement();
                try {
                    this.loadBinding(tempInclude.getURI());
                }
                catch (Exception except) {
                    throw new BindingException(except);
                    return;
                }
            }
        }
        catch (MarshalException e) {
            throw new BindingException(e);
        }
        catch (ValidationException e) {
            throw new BindingException(e);
        }
    }

    public ExtendedBinding getBinding() {
        return this._binding;
    }

    public void setBaseURL(String url) {
        try {
            this._resolver.setBaseURL(new URL(url));
        }
        catch (MalformedURLException except) {
            throw new IllegalArgumentException(except.getMessage());
        }
    }

    public static ExtendedBinding createBinding(InputSource source) throws BindingException {
        BindingLoader loader = new BindingLoader();
        loader.loadBinding(source);
        return loader.getBinding();
    }

    public static ExtendedBinding createBinding(String fileName) throws BindingException {
        BindingLoader loader = new BindingLoader();
        InputSource source = new InputSource(fileName);
        loader.loadBinding(source);
        return loader.getBinding();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class BindingResolver
    implements EntityResolver {
        private static final String BINDING_PUBLICID = "-//EXOLAB/Castor Binding Schema Version 1.0//EN";
        private static final String BINDING_SYSTEMID = "http://exolab.castor.org/binding.xsd";
        private static final String BINDING_RESOURCE = "/org/exolab/castor/builder/binding/binding.xsd";
        private URL _baseUrl;

        BindingResolver() {
        }

        public void setBaseURL(URL baseUrl) {
            this._baseUrl = baseUrl;
        }

        public URL getBaseURL() {
            return this._baseUrl;
        }

        public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
            InputSource source = null;
            if (publicId != null && publicId.equals(BINDING_PUBLICID)) {
                source = new InputSource(this.getClass().getResourceAsStream(BINDING_RESOURCE));
                source.setPublicId(publicId);
                return source;
            }
            if (systemId != null && systemId.equals(BINDING_SYSTEMID)) {
                source = new InputSource(this.getClass().getResourceAsStream(BINDING_RESOURCE));
                source.setSystemId(systemId);
                return source;
            }
            if (systemId != null && this._baseUrl != null) {
                try {
                    URL url = new URL(systemId);
                    source = new InputSource(url.openStream());
                    source.setSystemId(systemId);
                    return source;
                }
                catch (MalformedURLException except) {
                    try {
                        URL url = new URL(this._baseUrl, systemId);
                        source = new InputSource(url.openStream());
                        source.setSystemId(systemId);
                        return source;
                    }
                    catch (MalformedURLException ex2) {
                        throw new SAXException(ex2);
                    }
                }
            }
            return null;
        }
    }
}

