/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich.springmvc.servlet.handler;

import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import org.springframework.web.servlet.ModelAndView;
/**
 * G[X|Xwb_ModelAndViewɔf邽߂̃C^tF[XB
 * <p>
 * ێeAX|Xwb_yModelAndViewɐݒ肷@\񋟂B
 * </p>
 * 
 */
public interface ExceptionResolveDelegator {
    
    /**
     * Ǒ^ƃr[iG[j𑮐Ɋi[B
     * @param mappingKey  Ǒ^
     * @param mappingValues r[ƃG[
     * @param params ʂ̏̃L[ƒli[Map
     */
    void initMapping (String mappingKey, Object mappingValues, 
            Map<String, String> params);
    
    /**
     * X|Xwb_ɃG[ݒ肷B
     * @param response HTTPX|X
     */
    void setHeader(HttpServletResponse response);
    
    /**
     * ModelAndViewɃG[ݒ肷B
     * @param mv ModelAndView ModelAndViewIuWFNg
     */
    void addObjectToModel(ModelAndView mv);
    
    /**
     * r[擾B
     * @return r[
     */    
    String getViewName();

}
