/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich.springmvc.bind.creator;

import javax.servlet.http.HttpServletRequest;
import jp.terasoluna.fw.oxm.mapper.OXMapper;
import jp.terasoluna.fw.oxm.xsd.SchemaValidator;
import jp.terasoluna.fw.web.rich.springmvc.bind.XMLServletRequestDataBinder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.bind.ServletRequestDataBinder;

/**
 * XML`Œ`ꂽNGXgf[^oChNX𐶐NXB
 * <p>
 * Springɒ`ĂServletRequestDataBinderNXƂĕԋpB
 * </p>
 * <p>
 * {NXgpꍇ́AoChs{@link jp.terasoluna.fw.oxm.mapper.OXMapper}̎NXDI邱ƁB<br>
 * XMLXL[}gp``FbNsꍇ́A{@link jp.terasoluna.fw.oxm.xsd.SchemaValidator}̎NXDI邱ƁB
 * </p>
 * <p>
 * yBean`t@C̐ݒi``FbNsꍇjz<br>
 * <code><pre>
 * &lt;bean id=&quot;oxmapper&quot; class=&quot;jp.terasoluna.fw.oxm.mapper.castor.CastorOXMapperImpl&quot; /&gt;
 * 
 * &lt;bean id=&quot;schemaValidator&quot; class=&quot;jp.terasoluna.fw.oxm.xsdvalidator.impl.SchemaValidatorImpl&quot; /&gt;
 * 
 * &lt;bean id=&quot;xmlDataBinderCreator&quot;
 *   class=&quot;jp.terasoluna.fw.web.rich.springmvc.bind.creator.XMLServletRequestDataBinderCreator&quot;&gt;
 *   &lt;property name=&quot;oxmapper&quot;&gt;&lt;ref local=&quot;oxmapper&quot;/&gt;&lt;/property&gt;
 *   &lt;property name=&quot;schemaValidator&quot;&gt;&lt;ref local=&quot;schemaValidator&quot;/&gt;&lt;/property&gt;
 * &lt;/bean&gt;
 * </pre></code>
 * </p>
 * <p>
 * {NX̎gp@́A{@link jp.terasoluna.fw.web.rich.springmvc.controller.TerasolunaController}QƂ邱ƁB
 * </p>
 * 
 * @see jp.terasoluna.fw.web.rich.springmvc.controller.TerasolunaController
 * @see jp.terasoluna.fw.web.rich.springmvc.bind.XMLServletRequestDataBinder
 */
public class XMLServletRequestDataBinderCreator implements
        ServletRequestDataBinderCreator, InitializingBean {
    /**
     * ONXB
     */
    private static Log log = LogFactory
            .getLog(XMLServletRequestDataBinderCreator.class);

    /**
     * OXMapperB
     */
    private OXMapper oxmapper = null;

    /**
     * SchemaValidatorB
     */
    private SchemaValidator schemaValidator = null;

    /**
     * XML`̃NGXgf[^ɑΉServletRequestDataBinderNXԋpB
     * 
     * @param request XML`̃NGXg
     * @param command R}hIuWFNg
     * @param requestName NGXg
     * @return XMLServletRequestDataBinder
     */
    public ServletRequestDataBinder create(HttpServletRequest request,
            Object command, String requestName) {
        return new XMLServletRequestDataBinder(command, oxmapper,
                schemaValidator, requestName);
    }
    
    /**
     * DIReiNA{NXCX^XꂽɌĂ΂郁\bhB
     * OXMapperiXML`̃f[^oChNXjݒ肳ĂȂꍇA O𓊂B
     */
    public void afterPropertiesSet() {
        // XMLDataBinderݒ肳ĂȂꍇAOƂ
        if (oxmapper == null) {
            log.error("OXMapper isn't set in ServletRequestDataBinder. "
                    + "Check Spring Bean definition file.");
            throw new IllegalStateException(
                    "OXMapper isn't set in ServletRequestDataBinder. "
                    + "Check Spring Bean definition file.");
        }
    }

    /**
     * OXMapper擾B
     * 
     * @return OXMapper OXMapper
     */
    public OXMapper getOxmapper() {
        return oxmapper;
    }

    /**
     * OXMapperݒ肷B
     * 
     * @param oxmapper OXMapper
     */
    public void setOxmapper(OXMapper oxmapper) {
        this.oxmapper = oxmapper;
    }

    /**
     * SchemaValidator擾B
     * 
     * @return SchemaValidator SchemaValidator
     */
    public SchemaValidator getSchemaValidator() {
        return schemaValidator;
    }

    /**
     * SchemaValidatorݒ肷
     * 
     * @param schemaValidator SchemaValidator
     */
    public void setSchemaValidator(SchemaValidator schemaValidator) {
        this.schemaValidator = schemaValidator;
    }
            
}
