/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.rich.context.support;

import javax.servlet.http.HttpServletRequest;
import jp.terasoluna.fw.web.rich.context.RequestContext;
import jp.terasoluna.fw.web.rich.context.RequestContextManager;
import jp.terasoluna.fw.web.rich.context.exception.IllegalContextPropertyClassTypeException;
import jp.terasoluna.fw.web.rich.context.support.RequestContextSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRequestContextSupport
implements RequestContextSupport {
    @Override
    public String getRequestName() {
        return this.getRequestContext().getRequestName();
    }

    @Override
    public Object getProperty(String key) {
        return this.getRequestContext().getProperty(key);
    }

    @Override
    public <E> E getProperty(String key, Class<E> clazz) {
        E propertyObject = null;
        if (clazz == null) {
            String message = "Must not use null for clazz of an argument.";
            throw new IllegalArgumentException(message);
        }
        try {
            propertyObject = clazz.cast(this.getProperty(key));
        }
        catch (ClassCastException e) {
            throw new IllegalContextPropertyClassTypeException(e);
        }
        return propertyObject;
    }

    @Override
    public String getPropertyString(String key) {
        return this.getProperty(key, String.class);
    }

    @Override
    public void generateContext(HttpServletRequest request) {
        RequestContext ctx = this.doGenerateContext(request);
        RequestContextManager.bindRequestContext(ctx);
    }

    protected abstract RequestContext doGenerateContext(HttpServletRequest var1);

    @Override
    public void destroyContext() {
        if (RequestContextManager.hasRequestContext()) {
            RequestContextManager.unbindRequestContext();
        }
    }

    protected RequestContext getRequestContext() {
        return RequestContextManager.getRequestContext();
    }
}

