/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.annotation;

import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Controller;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.handler.AbstractDetectingUrlHandlerMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAnnotationHandlerMapping
extends AbstractDetectingUrlHandlerMapping {
    private boolean useDefaultSuffixPattern = true;

    public void setUseDefaultSuffixPattern(boolean useDefaultSuffixPattern) {
        this.useDefaultSuffixPattern = useDefaultSuffixPattern;
    }

    @Override
    protected String[] determineUrlsForHandler(String beanName) {
        LinkedHashSet<String> urls;
        AbstractBeanDefinition abd;
        ConfigurableApplicationContext cac;
        BeanDefinition bd;
        ApplicationContext context = this.getApplicationContext();
        Class handlerType = context.getType(beanName);
        RequestMapping mapping = (RequestMapping)AnnotationUtils.findAnnotation((Class)handlerType, RequestMapping.class);
        if (mapping == null && context instanceof ConfigurableApplicationContext && context.containsBeanDefinition(beanName) && (bd = (cac = (ConfigurableApplicationContext)context).getBeanFactory().getMergedBeanDefinition(beanName)) instanceof AbstractBeanDefinition && (abd = (AbstractBeanDefinition)bd).hasBeanClass()) {
            Class beanClass = abd.getBeanClass();
            mapping = (RequestMapping)AnnotationUtils.findAnnotation((Class)beanClass, RequestMapping.class);
        }
        if (mapping != null) {
            String[] paths;
            if (mapping.method().length > 0 || mapping.params().length > 0) {
                throw new IllegalStateException("Only path value supported for RequestMapping annotation at the type level - map HTTP method and/or parameters at the method level! Offending type: " + handlerType);
            }
            urls = new LinkedHashSet();
            for (String path : paths = mapping.value()) {
                this.addUrlsForPath(urls, path);
            }
            return StringUtils.toStringArray(urls);
        }
        if (AnnotationUtils.findAnnotation((Class)handlerType, Controller.class) != null) {
            urls = new LinkedHashSet<String>();
            ReflectionUtils.doWithMethods((Class)handlerType, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                public void doWith(Method method) {
                    RequestMapping mapping = method.getAnnotation(RequestMapping.class);
                    if (mapping != null) {
                        String[] mappedPaths = mapping.value();
                        for (int i = 0; i < mappedPaths.length; ++i) {
                            DefaultAnnotationHandlerMapping.this.addUrlsForPath(urls, mappedPaths[i]);
                        }
                    }
                }
            });
            return StringUtils.toStringArray(urls);
        }
        return null;
    }

    protected void addUrlsForPath(Set<String> urls, String path) {
        urls.add(path);
        if (this.useDefaultSuffixPattern && path.indexOf(46) == -1) {
            urls.add(path + ".*");
        }
    }
}

