/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.rich.functionsample.informationcontrol.service;

import java.util.Date;

import jp.terasoluna.fw.web.rich.context.support.
        RequestContextSupport;
import jp.terasoluna.rich.functionsample.common.bean.DummyIOData;
import jp.terasoluna.rich.functionsample.common.context.support.RequestContextSupportImpl;
import jp.terasoluna.rich.functionsample.informationcontrol.bean.InformationControlResultData;

/**
 * 擾T[rX̎NX
 *
 */
public class InformationControlServiceImpl
        implements InformationControlService
        <DummyIOData, InformationControlResultData> {
    
    /**
     * NX
     */
    protected RequestContextSupport ctxSupport = null;
    
    /**
     * [UI
     *
     * @param params OI
     * @return 
     */
    public InformationControlResultData getContextData(DummyIOData params) {
        
        //ʃIuWFNg
        InformationControlResultData result =
            new InformationControlResultData();
        
        //NGXg擾Aݒ
        result.setRequestName(ctxSupport.getRequestName());

        //[UId擾Aݒ
        result.setUserId((String) ctxSupport.getProperty(
                RequestContextSupportImpl.USERID_KEY));
        
        //pX[h擾Aݒ
        result.setPassword(ctxSupport.getPropertyString(
                RequestContextSupportImpl.PASSWORD_KEY));
        
        //ANZX擾Aݒ
        result.setAccessDate(ctxSupport.getProperty(
                RequestContextSupportImpl.ACCESS_DATE_KEY, Date.class));
        
        return result;
    }

    /**
     * NXݒ肷B
     * @param ctxSupport NX
     */
    public void setCtxSupport(RequestContextSupport ctxSupport) {
        this.ctxSupport = ctxSupport;
    }
}
