/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.rich.functionsample.common;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import jp.terasoluna.fw.exception.SystemException;

/**
 * NGXgwb_ɓlꍇɗO𔭐tB^[NX
 *
 */
public class ExceptionHandlerFilter implements Filter {
    
    /**
     * OÕG[R[h
     */
    public static final String ERROR_CODE = "8004C029";
    
    /**
     * tB^̏sB
     * ȂɂȂB
     * 
     * @param config tB^ݒ
     * @throws ServletException T[ubgO
     */
    public void init(FilterConfig config) throws ServletException {
    }

    /**
     * NGXg̃wb_ɗOlꍇɗO𔭐B
     *
     * @param req HTTPNGXg
     * @param res HTTPX|X
     * @param chain `FCꂽtB^
     * @throws IOException o͗O
     * @throws ServletException T[ubgO
     */
    public void doFilter
    (ServletRequest req, ServletResponse res, FilterChain chain) 
    throws IOException, ServletException {
        // NGXgwb_ɐݒ肳Ăreigail擾
        String className =
            ((HttpServletRequest) req).getHeader("exceptionhandler");
        
        // O񂪂ꍇO𔭐        
        if (className == null) {
            chain.doFilter(req, res);            
        } else {
            try {
                Class clazz = Class.forName(className);
                Object exception = clazz.newInstance();
                if (exception instanceof IOException) {
                    throw (IOException) exception;
                } else if (exception instanceof ServletException) {
                    throw (ServletException) exception;
                } else if (exception instanceof RuntimeException) {
                    throw (RuntimeException) exception;
                } else {
                    throw new SystemException(
                            (Exception) exception, ERROR_CODE);
                }
            } catch (ClassNotFoundException e) {
                throw new SystemException(e, ERROR_CODE);
            } catch (IllegalAccessException e) {
                throw new SystemException(e, ERROR_CODE);
            } catch (InstantiationException e) {
                throw new SystemException(e, ERROR_CODE);
            } catch (ClassCastException e) {
                throw new SystemException(e, ERROR_CODE);
            }
        }
    }

    /**
     * tB^̔jsB
     * ȂɂȂB
     */
    public void destroy() {
    }

}
