//-*- Mode: C++ -*-
#ifndef _TEOPP_TEOFILE_INLINE_H_
#define _TEOPP_TEOFILE_INLINE_H_
#include <iostream>
inline TeoFile::TeoFile()
  :teofile(NULL),ref(new int){(*ref) = 1;}
inline TeoFile::TeoFile(TEOFILE *const file)
  :teofile(file),ref(new int){(*ref) = 1;}

inline TeoFile::TeoFile(const TeoFile &seq)
  :teofile(seq.teofile),ref(seq.ref){(*ref)++;}

inline TeoFile::operator TEOFILE*()const{return teofile;}
inline TEOFILE *TeoFile::operator->()const{return teofile;}
inline TEOFILE &TeoFile::operator*()const{return *teofile;}

inline int TeoFile::Width()const{return TeoWidth(teofile);}
inline int TeoFile::Height()const{return TeoHeight(teofile);}
inline int TeoFile::Type()const{return TeoType(teofile);}
inline int TeoFile::Bit()const{return TeoBit(teofile);}
inline int TeoFile::Plane()const{return TeoPlane(teofile);}
inline int TeoFile::Frame()const{return TeoFrame(teofile);}
inline int TeoFile::Fsize()const{return TeoFsize(teofile);}
  
inline int TeoFile::Xoffset()const{return TeoXoffset(teofile);}
inline int TeoFile::Yoffset()const{return TeoYoffset(teofile);}
inline int TeoFile::Xstart()const{return TeoXstart(teofile);}
inline int TeoFile::Xend()const{return TeoXend(teofile);}
inline int TeoFile::Ystart()const{return TeoXstart(teofile);}
inline int TeoFile::Yend()const{return TeoYend(teofile);}
inline FILE *TeoFile::Fp()const{return TeoFp(teofile);}

inline int TeoFile::Ac_type()const{return teofile->ac_type;}
inline int TeoFile::Current()const{return TeoCurrent(teofile);}

inline int TeoFile::Extc()const{return TeoExtc(teofile);}
inline char **TeoFile::Extv()const{return TeoExtv(teofile);}

inline bool TeoFile::CheckFrame()const
{return ((Current() >= 0) && (Current() < Frame()));}

inline const char *TeoFile::GetUserExtension(const char *keyword)const
{return TeoGetUserExtension(teofile,(char *)keyword);}
inline bool TeoFile::SetAbsFrame(int fnum)
{return (TeoSetAbsFrame(teofile,fnum)==1);}
inline bool TeoFile::SetRelFrame(int fnum)
{return (TeoSetRelFrame(teofile,fnum)==1);}

inline void TeoFile::Close(){
  if(teofile != NULL) TeoCloseFile(teofile);
  teofile = NULL;
}

inline void TeoFile::Open(const char *fname){
  if((--(*ref)) == 0){
    Close();
    delete ref;
  }
  teofile = TeoOpenFile((char *)fname);
  ref = new int;
  *ref = 1;
}

#endif
