//-*- Mode: C++ -*-
#ifndef _TEOPP_TEOBIN_INLINE_H_
#define _TEOPP_TEOBIN_INLINE_H_
inline TeoBin::TeoBin():data(0),mask(0x01),ptr(&data){}
inline TeoBin::TeoBin(const TeoBin &b):data(b.data),mask(b.mask),ptr(b.ptr){}
inline TeoBin::TeoBin(TeoUint8 b):mask(0x01){
  data = (b == 0)? 0x00:0x01;
  ptr = &data;
}
inline TeoBin::TeoBin(TeoSint8 b):mask(0x01){
  data = (b == 0)? 0x00:0x01;
  ptr = &data;
}
inline TeoBin::TeoBin(TeoUint16 b):mask(0x01){
  data = (b == 0)? 0x00:0x01;
  ptr = &data;
}
inline TeoBin::TeoBin(TeoSint16 b):mask(0x01){
  data = (b == 0)? 0x00:0x01;
  ptr = &data;
}
inline TeoBin::TeoBin(TeoUint32 b):mask(0x01){
  data = (b == 0)? 0x00:0x01;
  ptr = &data;
}
inline TeoBin::TeoBin(TeoSint32 b):mask(0x01){
  data = (b == 0)? 0x00:0x01;
  ptr = &data;
}
inline TeoBin::TeoBin(TeoFloat32 b):mask(0x01){
  data = (b == 0.0)? 0x00:0x01;
  ptr = &data;
}
inline TeoBin::TeoBin(TeoFloat64 b):mask(0x01){
  data = (b == 0.0)? 0x00:0x01;
  ptr = &data;
}
inline TeoBin::TeoBin(char d,int s):data(d),mask(0x01),ptr(&data){
  mask <<= s;
}
inline TeoBin::TeoBin(char *d,int s):data(*d),mask(0x01),ptr(d){
  mask <<= s;
}
inline TeoBin::TeoBin(const char *d,int s):data(*d),mask(0x01),ptr(&data){
  mask <<= s;
}
inline TeoBin::~TeoBin(){}

inline bool TeoBin::IsSetBit()const{
  return ((mask & (*ptr)) != 0);
}
inline TeoBin TeoBin::Set(){
  (*ptr) |= mask;
  return TeoBin(*ptr);
}
inline TeoBin TeoBin::Unset(){
  (*ptr) &= (~mask);
  return TeoBin(*ptr);
}
inline TEO_BIT TeoBin::GetBit()const{
  return (IsSetBit())? (TEO_BIT)1:(TEO_BIT)0;
}

inline TeoBin &TeoBin::operator()(const TeoBin &b){
  data  = b.data;
  ptr   = b.ptr;
  mask  = b.mask;
  return *this;
}

// $BBeF~1i;;;R(B
inline TeoBin &TeoBin::operator=(const TeoBin &b){
  if(b.IsSetBit()) Set();
  else Unset();
  return *this;
}
inline TeoBin &TeoBin::operator=(TEO_BIT b){
  if(b==0) Unset();
  else Set();
  return *this;
}
inline TeoBin &TeoBin::operator|=(const TeoBin &b){
  if(b.IsSetBit()) Set();
  return *this;
}
inline TeoBin &TeoBin::operator+=(const TeoBin &b){
  if(b.IsSetBit()) Set();
  return *this;
}
inline TeoBin &TeoBin::operator&=(const TeoBin &b){
  if(!b.IsSetBit()) Unset();
  return *this;
}
inline TeoBin &TeoBin::operator*=(const TeoBin &b){
  if(!b.IsSetBit()) Unset();
  return *this;
}
inline TeoBin &TeoBin::operator-=(const TeoBin &b){
  if(b.IsSetBit()) Unset();
  return *this;
}
inline TeoBin &TeoBin::operator/=(const TeoBin &b){
  return *this;
}

// $BC19`1i;;;R(B
inline TeoBin TeoBin::operator~()const{
  if(IsSetBit()) return TeoBin(0);
  else return TeoBin(1);
}
inline TeoBin TeoBin::operator-()const{
  if(IsSetBit()) return TeoBin(0);
  else return TeoBin(1);
}

// $B;MB'1i;;(B
inline TeoBin TeoBin::operator|(const TeoBin &x)const{
  if(IsSetBit()||x.IsSetBit()) return TeoBin(1);
  else return TeoBin(0);
}
inline TeoBin TeoBin::operator+(const TeoBin &x)const{
  if(IsSetBit()||x.IsSetBit()) return TeoBin(1);
  else return TeoBin(0);
}
inline TeoBin TeoBin::operator&(const TeoBin &x)const{
  if(IsSetBit()&&x.IsSetBit()) return TeoBin(1);
  else return TeoBin(0);
}
inline TeoBin TeoBin::operator*(const TeoBin &x)const{
  if(IsSetBit()&&x.IsSetBit()) return TeoBin(1);
  else return TeoBin(0);
}
inline TeoBin TeoBin::operator-(const TeoBin &x)const{
  if(x.IsSetBit()) return TeoBin(1);
  else return GetBit();
}
inline TeoBin TeoBin::operator/(const TeoBin &x)const{
  return GetBit();
}

// $BHf3S1i;;;R(B
inline bool TeoBin::operator==(const TeoBin &b)const{
  bool x=IsSetBit();
  bool y=b.IsSetBit();
  return ((x&&y) || (!x&&!y));
}
inline bool TeoBin::operator!=(const TeoBin &b)const{
  bool x=IsSetBit();
  bool y=b.IsSetBit();
  return ((!x&&y) || (!x&&y));
}
inline bool TeoBin::operator<(const TeoBin &b)const{
  bool x=IsSetBit();
  bool y=b.IsSetBit();
  return (!x&&y);
}
inline bool TeoBin::operator<=(const TeoBin &b)const{
  bool x=IsSetBit();
  bool y=b.IsSetBit();
  return (!x||y);
}
inline bool TeoBin::operator>(const TeoBin &b)const{
  bool x=IsSetBit();
  bool y=b.IsSetBit();
  return (x&&!y);
}
inline bool TeoBin::operator>=(const TeoBin &b)const{
  bool x=IsSetBit();
  bool y=b.IsSetBit();
  return (x||!y);
}

// $B%-%c%9%H1i;;;R(B
inline TeoBin::operator TeoUint8()const{
  return (TeoUint8)(GetBit());
}
inline TeoBin::operator TeoSint8()const{
  return (TeoSint8)(GetBit());
}
inline TeoBin::operator TeoUint16()const{
  return (TeoUint16)(GetBit());
}
inline TeoBin::operator TeoSint16()const{
  return (TeoSint16)(GetBit());
}
inline TeoBin::operator TeoUint32()const{
  return (TeoUint32)(GetBit());
}
inline TeoBin::operator TeoSint32()const{
  return (TeoSint32)(GetBit());
}
inline TeoBin::operator TeoFloat32()const{
  return (TeoFloat32)(GetBit());
}
inline TeoBin::operator TeoFloat64()const{
  return (TeoFloat64)(GetBit());
}
#endif
