/* ====================================================== */
/*  TEO$B2hA|$G$N%F%/%9%A%c%^%C%T%s%0(B                       */
/*                                            Y.Mukaigaw  */
/* ====================================================== */

#include <stdio.h>
#include <teo.h>
#include <teoutil.h>

/*--< Static Function >--*/
static int max3(int a, int b, int c);
static int min3(int a, int b, int c);
static int line_flag(int x1, int y1, int x2, int y2, float px, float py);

void TeoUtilTextureMapping_UINT8(TEOIMAGE *in,TEOIMAGE *out,
		 int ix1, int iy1, int ix2, int iy2, int ix3, int iy3,
		 int ox1, int oy1, int ox2, int oy2, int ox3, int oy3){

  TeoUtilTextureMappingWithAlpha_UINT8(
	in,out, 1.0, ix1,iy1,ix2,iy2,ix3,iy3,ox1,oy1,ox2,oy2,ox3,oy3);
}

void TeoUtilTextureMappingWithAlpha_UINT8(
	TEOIMAGE *in,TEOIMAGE *out,float alpha,
	int ix1, int iy1, int ix2, int iy2, int ix3, int iy3,
	int ox1, int oy1, int ox2, int oy2, int ox3, int oy3){
  int		x,y,plane;
  int		x_max,y_max,x_min,y_min;
  float		x_center,y_center;
  int		f1,f2,f3,t1,t2,t3;
  int		det;
  float		xx,yy;
  float		a,b,c,d;
  int		pixel;

  /*****************************************/
  /* f1 is flag of line(ox1,oy1)-(ox2,oy2) */
  /* f2 is flag of line(ox2,oy2)-(ox3,oy3) */
  /* f3 is flag of line(ox3,oy3)-(ox1,oy1) */
  /*****************************************/

  /*--< $B30@\6k7A$r5a$a$k(B >--*/
  x_max = max3(ox1,ox2,ox3);
  x_min = min3(ox1,ox2,ox3);
  y_max = max3(oy1,oy2,oy3);
  y_min = min3(oy1,oy2,oy3);

  /*--< $B30@\6k7A$NCf?4(B >--*/
  x_center = (ox1+ox2+ox3) / 3.0;
  y_center = (oy1+oy2+oy3) / 3.0;
  
  /*--< $BCf?4$H;0JU$H$N0LCV4X78$r;;=P(B >--*/
  f1 = line_flag(ox1,oy1,ox2,oy2,x_center,y_center);
  f2 = line_flag(ox2,oy2,ox3,oy3,x_center,y_center);
  f3 = line_flag(ox3,oy3,ox1,oy1,x_center,y_center);

  /*--< $B@8@.B&$N#33Q7A$NLL@Q$,$J$$(B($B5U9TNs$,B8:_$7$J$$(B)$B>l9g$N=hM}(B >--*/
  det = (ox2-ox1)*(oy3-oy1)-(ox3-ox1)*(oy2-oy1);
  if (det==0){
    /*
      fprintf(stderr,"ERROR: can not make inverse matrix.\n");
      */
    return;
  }

  /*--< $B5UJQ499TNs$N:n@.(B >--*/
  a = ((ix2-ix1)*(oy3-oy1)+(ix3-ix1)*(oy1-oy2))/(float)det;
  b = ((ix2-ix1)*(ox1-ox3)+(ix3-ix1)*(ox2-ox1))/(float)det;
  c = ((iy2-iy1)*(oy3-oy1)+(iy3-iy1)*(oy1-oy2))/(float)det;
  d = ((iy2-iy1)*(ox1-ox3)+(iy3-iy1)*(ox2-ox1))/(float)det;

  /*--< $B%^%C%T%s%0(B >--*/
  for (x=x_min;x<=x_max;x++){
    for (y=y_min;y<=y_max;y++){
      t1 = line_flag(ox1,oy1,ox2,oy2,(float)x,(float)y);
      t2 = line_flag(ox2,oy2,ox3,oy3,(float)x,(float)y);
      t3 = line_flag(ox3,oy3,ox1,oy1,(float)x,(float)y);
      if (((t1==0)||(t1==f1))&&((t2==0)||(t2==f2))&&((t3==0)||(t3==f3))){
	xx = (a*(x-ox1)+b*(y-oy1))+ix1;
	yy = (c*(x-ox1)+d*(y-oy1))+iy1;
	
	/*--< $B:BI8$,2hA|$NHO0O$rD6$($F$$$J$$$+$N%A%'%C%/(B >--*/
	if ((x<TeoXstart(out))||(x>TeoXend(out))||
	    (y<TeoYstart(out))||(y>TeoYend(out))||
	    ((int)xx<TeoXstart(in))||
	    ((int)xx>TeoXend(in))||
	    ((int)yy<TeoYstart(in))||
	    ((int)yy>TeoYend(in))){
	  /*
	    fprintf(stderr,"ERROR: out of range.\n");
	    fprintf(stderr,"(IN)  x = %5d , y = %5d\n",xx,yy);
	    fprintf(stderr,"(OUT) x = %5d , y = %5d\n",x,y);
	    */
	}	
	else {
	  for(plane=0;plane<TeoPlane(in);plane++){
	    pixel = (int)(TeoUtilLinearPixel_UINT8(in,xx,yy,plane) * alpha);
	    if (pixel > 255) pixel = 255;
	    else if (pixel < 0) pixel = 0;
	    TeoPutPixel(out,x,y,plane,TEO_UINT8,pixel);
	  }
	}
      }
    }
  }
}

static int max3(int a, int b, int c){
  if (a>b){
    if (a>c) return a;
    else if (b>c) return b;
    return c;
  }
  else{
    if (b>c) return b;
    else if (a>c) return a;
    return c;
  }
}

static int min3(int a, int b, int c){
  return(-max3(-a,-b,-c));
}

static int line_flag(int x1, int y1, int x2, int y2, float px, float py){
  float f;

  f = ((x1-x2)*(py-y1)-(y1-y2)*(px-x1));
  if (f >0.0) return 1;
  if (f==0.0) return 0;
  return -1;
}
