/*******************/
/* TEO$B2hA|$X$NIA2h(B */
/*     By F.Sakaue */
/*******************/

#include <stdio.h>
#include <teo.h>

/*-----< Clipping $B$J$7(B >----------*/

void __inline__ TeoUtilDrawPoint_UINT8(TEOIMAGE *img, 
				       int x, int y, TEO_UINT8 *color){
  int p;
  for(p=0; p<TeoPlane(img); p++) TeoPutPixel(img,x,y,p,TEO_UINT8,color[p]);

}

void TeoUtilDrawLine_UINT8(TEOIMAGE *img, int x1, int y1,
			   int x2, int y2, TEO_UINT8 *color){

  int E,x,y;
  int dx,dy,sx,sy,i;

  if( x2>x1 ) {
    sx = 1;
    dx = x2 - x1;
  } else {
    sx = -1;
    dx = x1 - x2;
  }
  if( y2>y1 ) {
    sy = 1;
    dy = y2 - y1;
  } else {
    sy = -1;
    dy = y1 - y2;
  }

  x = x1;
  y = y1;
  if( dx >= dy ) {
    E = -dx;
    for( i=0; i<=dx; i++    ) {
      TeoUtilDrawPoint_UINT8(img,x,y,color);
      x += sx;
      E += 2*dy;
      if( E >= 0 ) {
	y += sy;
	E -= 2*dx;
      }
    }
  } else {
    E = -dy;
    for( i=0; i<=dy; i++) {
      TeoUtilDrawPoint_UINT8(img,x,y,color);
      y += sy;
      E += 2*dx;
      if( E >= 0 ) {
	x += sx;
	E -= 2*dy;
      }
    }
  }
  return;
}

void TeoUtilDrawRectangle_UINT8(TEOIMAGE *img, int x, int y,
				int width, int height,TEO_UINT8 *color){
  int l,ex,ey;
  
  ex=x+width-1;
  ey=y+height-1;
  for (l=x;l<=ex;l++){
    TeoUtilDrawPoint_UINT8(img,l,y,color);
    TeoUtilDrawPoint_UINT8(img,l,ey,color);
  }

  for (l=y;l<=ey;l++){
    TeoUtilDrawPoint_UINT8(img,x,l,color);
    TeoUtilDrawPoint_UINT8(img,ex,l,color);
  }

  return;
}

void TeoUtilDrawFillRectangle_UINT8(TEOIMAGE *img, int x, int y,
				int width, int height,TEO_UINT8 *color){
  int l,m,ex,ey;
  
  ex=x+width-1;
  ey=y+height-1;

  for (l=y;l<=ey;l++)
    for (m=x;m<=ex;m++)
      TeoUtilDrawPoint_UINT8(img,m,l,color);
  
  return;
}

void TeoUtilDrawCircle_UINT8(TEOIMAGE *img, int x, int y, int r,
			     TEO_UINT8 *color){
  /* $B??1_$rIA$/(B */
  int i,j,F;
  
  i = r;
  j = 0;
  F = -2*r + 3;
  
  while( i >= j ) {
    TeoUtilDrawPoint_UINT8(img,x+i,y+j,color);
    TeoUtilDrawPoint_UINT8(img,x-i,y+j,color);
    TeoUtilDrawPoint_UINT8(img,x+i,y-j,color);
    TeoUtilDrawPoint_UINT8(img,x-i,y-j,color);
    TeoUtilDrawPoint_UINT8(img,x+j,y+i,color);
    TeoUtilDrawPoint_UINT8(img,x-j,y+i,color);
    TeoUtilDrawPoint_UINT8(img,x+j,y-i,color);
    TeoUtilDrawPoint_UINT8(img,x-j,y-i,color);
    if( F>=0 ) {
      i--;
      F -= 4*i;
    }
    j++;
    F += 4*j + 2;
  }
  return;
}

void TeoUtilDrawFillCircle_UINT8(TEOIMAGE *img, int x, int y, int r,
				 TEO_UINT8 *color){
  /* $B??1_$rIA$/(B($BEI$j$D$V$9(B) */
  int i,j,F;
  int l,ex;
  
  i = r;
  j = 0;
  F = -2*r + 3;
  
  while( i >= j ) {
    ex=x+i;
    for (l=x-i;l<=ex;l++){
      TeoUtilDrawPoint_UINT8(img,l,y+j,color);
      TeoUtilDrawPoint_UINT8(img,l,y-j,color);
    }
    if( F>=0 ) {
    ex=x+j;
    for (l=x-j;l<=ex;l++){
      TeoUtilDrawPoint_UINT8(img,l,y+i,color);
      TeoUtilDrawPoint_UINT8(img,l,y-i,color);
    }
      i--;
      F -= 4*i;
    }
    j++;
    F += 4*j + 2;
  }
  return;
}

/*-----< Clipping $B$"$j(B >----------*/
  
void __inline__ TeoUtilDrawPointClipping_UINT8(TEOIMAGE *img, 
				       int x, int y, TEO_UINT8 *color){
  int p;
  
  if ( x < TeoXstart(img) || TeoXend(img) < x ||
       y < TeoYstart(img) || TeoYend(img) < y )
    return;

  for(p=0; p<TeoPlane(img); p++) TeoPutPixel(img,x,y,p,TEO_UINT8,color[p]);

}

void TeoUtilDrawLineClipping_UINT8(TEOIMAGE *img, int x1, int y1,
			   int x2, int y2, TEO_UINT8 *color){

  int E,x,y;
  int dx,dy,sx,sy,i;

  if( x2>x1 ) {
    sx = 1;
    dx = x2 - x1;
  } else {
    sx = -1;
    dx = x1 - x2;
  }
  if( y2>y1 ) {
    sy = 1;
    dy = y2 - y1;
  } else {
    sy = -1;
    dy = y1 - y2;
  }

  x = x1;
  y = y1;
  if( dx >= dy ) {
    E = -dx;
    for( i=0; i<=dx; i++    ) {
      TeoUtilDrawPointClipping_UINT8(img,x,y,color);
      x += sx;
      E += 2*dy;
      if( E >= 0 ) {
	y += sy;
	E -= 2*dx;
      }
    }
  } else {
    E = -dy;
    for( i=0; i<=dy; i++) {
      TeoUtilDrawPointClipping_UINT8(img,x,y,color);
      y += sy;
      E += 2*dx;
      if( E >= 0 ) {
	x += sx;
	E -= 2*dy;
      }
    }
  }
  return;
}

void TeoUtilDrawRectangleClipping_UINT8(TEOIMAGE *img, int x, int y,
				int width, int height,TEO_UINT8 *color){
  int l,sx,sy,ex,ey;

  if (x>TeoXend(img) || y>TeoYend(img)) return;

  sx=x;  
  if (sx<TeoXstart(img)) sx=TeoXstart(img);

  ex=x+width-1;
  if (ex>TeoXend(img)) ex=TeoXend(img);

  sy=y;
  if (sy<TeoYstart(img)) sy=TeoYstart(img);

  ey=y+height-1;
  if (ey>TeoYend(img)) ey=TeoYend(img);

  if (y>=TeoYstart(img))
    for (l=sx;l<=ex;l++)
      TeoUtilDrawPoint_UINT8(img,l,sy,color);
  if (y+height<=TeoYend(img))
    for (l=sx;l<=ex;l++)
      TeoUtilDrawPoint_UINT8(img,l,ey,color);
  if (x>=TeoXstart(img))
    for (l=sy;l<=ey;l++)
      TeoUtilDrawPoint_UINT8(img,sx,l,color);
  if (x+width<=TeoXend(img))
    for (l=sy;l<=ey;l++)
      TeoUtilDrawPoint_UINT8(img,ex,l,color);

  return;
}

void TeoUtilDrawFillRectangleClipping_UINT8(TEOIMAGE *img, int x, int y,
				int width, int height,TEO_UINT8 *color){
  int l,m,ex,ey;

  ex=x+width-1;
  if (ex > TeoXend(img)) ex=TeoXend(img);

  ey=y+height-1;
  if (ey > TeoYend(img)) ey=TeoYend(img);

  for (l=y;l<=ey;l++)
    for (m=x;m<=ex;m++)
      TeoUtilDrawPoint_UINT8(img,m,l,color);
  
  return;
}

void TeoUtilDrawCircleClipping_UINT8(TEOIMAGE *img, int x, int y, int r,
			     TEO_UINT8 *color){
  /* $B??1_$rIA$/(B */
  int i,j,F;
  
  i = r;
  j = 0;
  F = -2*r + 3;
  
  while( i >= j ) {
    TeoUtilDrawPointClipping_UINT8(img,x+i,y+j,color);
    TeoUtilDrawPointClipping_UINT8(img,x-i,y+j,color);
    TeoUtilDrawPointClipping_UINT8(img,x+i,y-j,color);
    TeoUtilDrawPointClipping_UINT8(img,x-i,y-j,color);
    TeoUtilDrawPointClipping_UINT8(img,x+j,y+i,color);
    TeoUtilDrawPointClipping_UINT8(img,x-j,y+i,color);
    TeoUtilDrawPointClipping_UINT8(img,x+j,y-i,color);
    TeoUtilDrawPointClipping_UINT8(img,x-j,y-i,color);
    if( F>=0 ) {
      i--;
      F -= 4*i;
    }
    j++;
    F += 4*j + 2;
  }
  return;
}

void TeoUtilDrawFillCircleClipping_UINT8(TEOIMAGE *img, int x, int y, int r,
				 TEO_UINT8 *color){
  /* $B??1_$rIA$/(B($BEI$j$D$V$9(B) */
  int i,j,F;
  int l,ex;
  
  i = r;
  j = 0;
  F = -2*r + 3;
  
  while( i >= j ) {
    ex=x+i;
    for (l=x-i;l<=ex;l++){
      TeoUtilDrawPointClipping_UINT8(img,l,y+j,color);
      TeoUtilDrawPointClipping_UINT8(img,l,y-j,color);
    }
    if( F>=0 ) {
    ex=x+j;
    for (l=x-j;l<=ex;l++){
      TeoUtilDrawPointClipping_UINT8(img,l,y+i,color);
      TeoUtilDrawPointClipping_UINT8(img,l,y-i,color);
    }
      i--;
      F -= 4*i;
    }
    j++;
    F += 4*j + 2;
  }
  return;
}
