/* ************************************************************* draw+.c *** */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <teo.h>

/* ͼθ **************************************************************** */
#define DOUBLE_TO_INT(a) (((a) > 0) ? ((int)((a)+0.5)):((int)((a)-0.5)))

/* ************************************************************************* */
void	TeoUtilDrawPoint_UINT8		(TEOIMAGE	*img, 
					 int		x,
					 int		y,
					 TEO_UINT8 	*color);

void	TeoUtilDrawPointClipping_UINT8	(TEOIMAGE	*img, 
					 int 		x,
					 int 		y,
					 TEO_UINT8 	*color);

void 	TeoUtilDrawLine_UINT8		(TEOIMAGE	*img,
					 int 		x1,
					 int 		y1,
					 int 		x2,
					 int 		y2,
					 TEO_UINT8 	*color);

void 	TeoUtilDrawLineClipping_UINT8	(TEOIMAGE 	*img,
					 int 		x1,
					 int 		y1,
					 int 		x2,
					 int 		y2,
					 TEO_UINT8 	*color);

/* ************************************************************************* *
 * åԥ󥰤ʤδؿ
 * ************************************************************************* */

/* ֥ǥ ************************************************ */
void __inline__
TeoUtilDrawPointWithAlpha_UINT8 (TEOIMAGE	*img,
				 int		x,
				 int		y,
				 unsigned char	alpha,
				 TEO_UINT8	*color) {
  int		p;
  unsigned char	alpha_;

  alpha_ = 255 - alpha;
  
  if (alpha == 255) {
    for (p = TeoPlane (img) - 1; p >= 0; p--) {
      TeoPutPixel (img, x, y, p, TEO_UINT8, color[p]);
    }
  } else {
    for (p = TeoPlane (img) - 1; p >= 0; p--) {
      TeoPutPixel (img, x, y, p, TEO_UINT8,
		   (TEO_UINT8) ((color[p] * alpha / 255) +
				(TeoGetPixel (img, x, y, p, TEO_UINT8)
				 * alpha_ / 255)));
    }
  }
}

/* Ϣľ ********************************************************** */
void
TeoUtilDrawLines_UINT8 (TEOIMAGE	*img,
			int		*data,
			int		pnum,	      
			TEO_UINT8	*color) {
  int		xs, xe, ys, ye;
  int		n;
  
  xs = data[0];
  ys = data[1];
  for (n = 1; n < pnum; n++) {
    xe = data[n * 2];
    ye = data[n * 2 + 1];
    TeoUtilDrawLine_UINT8 (img, xs, ys, xe, ye, color);
    xs = xe;
    ys = ye;
  }
}

/* ʣľ ********************************************************** */
void
TeoUtilDrawSegments_UINT8 (TEOIMAGE	*img,
			   int		*data,
			   int		pnum,
			   TEO_UINT8	*color) {
  int		xs, xe, ys, ye;
  int		n;
  
  for (n = 0; n < pnum; n++) {
    xs = data[n * 4];
    ys = data[n * 4 + 1];
    xe = data[n * 4 + 2];
    ye = data[n * 4 + 3];
    TeoUtilDrawLine_UINT8 (img, xs, ys, xe, ye, color);
  }
}

/* ɤĤ֤ (֥ǥ) ************************************* */
void
TeoUtilDrawFillRectangleWithAlpha_UINT8 (TEOIMAGE	*img,
					 int		x,
					 int		y,
					 int		width,
					 int		height,
					 unsigned char	alpha,
					 TEO_UINT8 	*color) {
  int l,m,ex,ey;
  
  ex=x+width-1;
  if (ex > TeoXend(img)) ex=TeoXend(img);

  ey=y+height-1;
  if (ey > TeoYend(img)) ey=TeoYend(img);

  for (l=y;l<=ey;l++)
    for (m=x;m<=ex;m++)
      TeoUtilDrawPointWithAlpha_UINT8(img,m,l,alpha,color);
  
  return;
}

/* ߤɤĤ֤ (֥ǥ) *************************************** */
void
TeoUtilDrawFillCircleWithAlpha_UINT8 (TEOIMAGE		*img,
				      int		x0,
				      int 		y0,
				      int 		r,
				      unsigned char	alpha,
				      TEO_UINT8 	*color) {
  int	x, y, F, dx;

  x = r;
  y = 0;
  F = -2 * r + 3;

  while (x >= y) {
    for (dx = x; dx > y; dx--) {
      TeoUtilDrawPointWithAlpha_UINT8 (img, x0+dx,   y0+y, alpha,   color);
      TeoUtilDrawPointWithAlpha_UINT8 (img, x0-dx+1, y0+y, alpha,   color);
      TeoUtilDrawPointWithAlpha_UINT8 (img, x0+dx+1, y0-y-1, alpha, color);
      TeoUtilDrawPointWithAlpha_UINT8 (img, x0-dx,   y0-y-1, alpha, color);
      TeoUtilDrawPointWithAlpha_UINT8 (img, x0+y+1,  y0+dx, alpha,  color);
      TeoUtilDrawPointWithAlpha_UINT8 (img, x0+y+1,  y0-dx, alpha,  color);
      TeoUtilDrawPointWithAlpha_UINT8 (img, x0-y,    y0+dx, alpha,  color);
      TeoUtilDrawPointWithAlpha_UINT8 (img, x0-y,    y0-dx, alpha,  color);      
    }
    if (F >= 0) {
      x--;
      F -= 4 * x;
    }
    y++;
    F += 4 * y + 2;
  }
}

/* ************************************************************************* *
 * ʱߤؿ
 * ************************************************************************* */

/* ʱߤYɸ׻ ********************************************************* */
static double
ellipse (double	*q,
	 double	k1,
	 double	k2,
	 double	k3,
	 double	x,
	 int	sgn) {
  double	b, D;

  b = q[1] * x + q[7];  
  D = -k2 * x * x + 2 * k1 * x - k3;

  return (-b + sqrt (D) * sgn) / q[4];
}

/* ʱߤ ************************************************************** */
static void
_TeoDrawArc_UINT8 (TEOIMAGE	*img,
		   double	*q,
		   TEO_UINT8	*color) {
  double	D, xs, xe, ys, ye, k1, k2, k3, pre_y;
  double	e = 1.0e-05;
  int		x, y, step;

  k1 = q[1] * q[7] - q[4] * q[2];
  k2 = q[0] * q[4] - q[1] * q[1];
  k3 = q[4] * q[8] - q[5] * q[5];
  D  = k1 * k1  - k2 * k3;
  xs = (k1 - sqrt (D)) / k2;
  xe = (k1 + sqrt (D)) / k2;
  xs += e;
  xe -= e;  
  ys = ellipse (q, k1, k2, k3, xs, 1);
  ye = ellipse (q, k1, k2, k3, xe, 1);

  /* ʱߤ򺸲塤4ĸ̤ʬ䤷褹 */

  /* θ */
  x = DOUBLE_TO_INT (xs);
  y = DOUBLE_TO_INT (ys);
  
  while (x <= DOUBLE_TO_INT(xs + (xe-xs) * 0.5)) {
    /*  */
    TeoUtilDrawPoint_UINT8 (img, x, y, color);
    /* Υå */
    pre_y = ellipse (q, k1, k2, k3, x+1, 1);
    if (DOUBLE_TO_INT(pre_y) == y) {
      x = x + 1;
    } else {
      step = (pre_y > y) ? 1 : -1;
      y = y + step;
      if (((y - DOUBLE_TO_INT(pre_y)) * step + 1) > 0) {
	x = x + 1;
      }
    }
  }

  /* θ */
  x = DOUBLE_TO_INT (xs);
  y = DOUBLE_TO_INT (ys);
  
  while (x <= DOUBLE_TO_INT(xs + (xe-xs) * 0.5)) {
    /*  */
    TeoUtilDrawPoint_UINT8 (img, x, y, color);
    /* Υå */
    pre_y = ellipse (q, k1, k2, k3, x+1, -1);
    if (DOUBLE_TO_INT(pre_y) == y) {
      x = x + 1;
    } else {
      step = (pre_y > y) ? 1 : -1;
      y = y + step;
      if (((y - DOUBLE_TO_INT(pre_y)) * step + 1) > 0) {
	x = x + 1;
      }
    }
  }

  /* θ */    
  x = DOUBLE_TO_INT (xe);
  y = DOUBLE_TO_INT (ye);

  while (x >= DOUBLE_TO_INT(xs + (xe-xs) * 0.5)) {
    /*  */
    TeoUtilDrawPoint_UINT8 (img, x, y, color);
    /* Υå */
    pre_y = ellipse (q, k1, k2, k3, x-1, 1);
    if (DOUBLE_TO_INT(pre_y) == y) {
      x = x - 1;
    } else {
      step = (pre_y > y) ? 1 : -1;
      y = y + step;
      if (((y - DOUBLE_TO_INT(pre_y)) * step + 1) > 0) {
	x = x - 1;
      }
    }
  }

  /* θ */    
  x = DOUBLE_TO_INT (xe);
  y = DOUBLE_TO_INT (ye);

  while (x >= DOUBLE_TO_INT(xs + (xe-xs) * 0.5)) {
    /*  */
    TeoUtilDrawPoint_UINT8 (img, x, y, color);
    /* Υå */
    pre_y = ellipse (q, k1, k2, k3, x-1, -1);
    if (DOUBLE_TO_INT(pre_y) == y) {
      x = x - 1;
    } else {
      step = (pre_y > y) ? 1 : -1;
      y = y + step;
      if (((y - DOUBLE_TO_INT(pre_y)) * step + 1) > 0) {
	x = x - 1;
      }
    }
  }
}

/* ʱߤ ************************************************************** */
static void
_TeoDrawFillArc_UINT8 (TEOIMAGE		*img,
		       double		*q,
		       TEO_UINT8	*color) {
  double	D, xs, xe, ys, ye, k1, k2, k3, pre_y;
  double	e = 1.0e-05;
  int		w, x, y, step;

  k1 = q[1] * q[7] - q[4] * q[2];
  k2 = q[0] * q[4] - q[1] * q[1];
  k3 = q[4] * q[8] - q[5] * q[5];
  D  = k1 * k1  - k2 * k3;
  xs = (k1 - sqrt (D)) / k2;
  xe = (k1 + sqrt (D)) / k2;
  xs += e;
  xe -= e;  
  ys = ellipse (q, k1, k2, k3, xs, 1);
  ye = ellipse (q, k1, k2, k3, xe, 1);

  /* ʱߤ򺸲塤4ĸ̤ʬ䤷褹 */

  /* θ */
  x = DOUBLE_TO_INT (xs);
  y = DOUBLE_TO_INT (ys);
  
  while (x <= DOUBLE_TO_INT(xs + (xe-xs) * 0.5)) {
    /*  */
    TeoUtilDrawPoint_UINT8 (img, x, y, color);
    w = x + 1;
    while (w <= DOUBLE_TO_INT (xs + (xe-xs) * 0.5) &&
	   DOUBLE_TO_INT (ellipse (q, k1, k2, k3, w, 1)) >= y) {
      TeoUtilDrawPoint_UINT8 (img, w, y, color);
      w = w + 1;
    }
    /* Υå */
    pre_y = ellipse (q, k1, k2, k3, x+1, 1);
    if (DOUBLE_TO_INT(pre_y) == y) {
      x = x + 1;
    } else {
      step = (pre_y > y) ? 1 : -1;
      y = y + step;
      if (((y - DOUBLE_TO_INT(pre_y)) * step + 1) > 0) {
	x = x + 1;
      }
    }
  }

  /* θ */
  x = DOUBLE_TO_INT (xs);
  y = DOUBLE_TO_INT (ys);
  
  while (x <= DOUBLE_TO_INT(xs + (xe-xs) * 0.5)) {
    /*  */
    TeoUtilDrawPoint_UINT8 (img, x, y, color);
    w = x + 1;
    while (w <= DOUBLE_TO_INT (xs + (xe-xs) * 0.5) &&
	   DOUBLE_TO_INT (ellipse (q, k1, k2, k3, w, -1)) <= y ) {
      TeoUtilDrawPoint_UINT8 (img, w, y, color);
      w = w + 1;
    }
    /* Υå */
    pre_y = ellipse (q, k1, k2, k3, x+1, -1);
    if (DOUBLE_TO_INT(pre_y) == y) {
      x = x + 1;
    } else {
      step = (pre_y > y) ? 1 : -1;
      y = y + step;
      if (((y - DOUBLE_TO_INT(pre_y)) * step + 1) > 0) {
	x = x + 1;
      }
    }
  }

  /* θ */    
  x = DOUBLE_TO_INT (xe);
  y = DOUBLE_TO_INT (ye);

  while (x >= DOUBLE_TO_INT(xs + (xe-xs) * 0.5)) {
    /*  */
    TeoUtilDrawPoint_UINT8 (img, x, y, color);
    w = x - 1;
    while (w >= DOUBLE_TO_INT (xs + (xe-xs) * 0.5) &&
	   DOUBLE_TO_INT (ellipse (q, k1, k2, k3, w, 1)) >= y) {
      TeoUtilDrawPoint_UINT8 (img, w, y, color);
      w = w - 1;
    }
    /* Υå */
    pre_y = ellipse (q, k1, k2, k3, x-1, 1);
    if (DOUBLE_TO_INT(pre_y) == y) {
      x = x - 1;
    } else {
      step = (pre_y > y) ? 1 : -1;
      y = y + step;
      if (((y - DOUBLE_TO_INT(pre_y)) * step + 1) > 0) {
	x = x - 1;
      }
    }
  }

  /* θ */    
  x  = DOUBLE_TO_INT (xe);
  y  = DOUBLE_TO_INT (ye);

  while (x >= DOUBLE_TO_INT(xs + (xe-xs) * 0.5)) {
    /*  */
    TeoUtilDrawPoint_UINT8 (img, x, y, color);
    w = x - 1;
    while (w >= DOUBLE_TO_INT (xs + (xe-xs) * 0.5) &&
	   DOUBLE_TO_INT (ellipse (q, k1, k2, k3, w, -1)) <= y) {
      TeoUtilDrawPoint_UINT8 (img, w, y, color);
      w = w - 1;
    }
    /* Υå */
    pre_y = ellipse (q, k1, k2, k3, x-1, -1);
    if (DOUBLE_TO_INT(pre_y) == y) {
      x = x - 1;
    } else {
      step = (pre_y > y) ? 1 : -1;
      y = y + step;
      if (((y - DOUBLE_TO_INT(pre_y)) * step + 1) > 0) {
	x = x - 1;
      }
    }
  }
}

/* ʱߤ ************************************************************** */
static void
_TeoDrawFillArcWithAlpha_UINT8 (TEOIMAGE	*img,
				double		*q,
				unsigned char	alpha,
				TEO_UINT8	*color) {
  double	D, xs, xe, ys, ye, k1, k2, k3, pre_y;
  double	e = 1.0e-05;
  int		w, x, y, old_y, step;

  k1 = q[1] * q[7] - q[4] * q[2];
  k2 = q[0] * q[4] - q[1] * q[1];
  k3 = q[4] * q[8] - q[5] * q[5];
  D  = k1 * k1  - k2 * k3;
  xs = (k1 - sqrt (D)) / k2;
  xe = (k1 + sqrt (D)) / k2;
  xs += e;
  xe -= e;  
  ys = ellipse (q, k1, k2, k3, xs, 1);
  ye = ellipse (q, k1, k2, k3, xe, 1);

  /* ʱߤ򺸲塤4ĸ̤ʬ䤷褹 */

  /* θ */
  x     = DOUBLE_TO_INT (xs);
  y     = DOUBLE_TO_INT (ys);
  old_y = y + 1;
  while (x <= DOUBLE_TO_INT(xs + (xe-xs) * 0.5)) {
    /*  */
    TeoUtilDrawPointWithAlpha_UINT8 (img, x, y, alpha, color);
    w = x + 1;
    while (w <= DOUBLE_TO_INT (xs + (xe-xs) * 0.5) &&
	   DOUBLE_TO_INT (ellipse (q, k1, k2, k3, w, 1)) >= y &&
	   y != old_y) {
      TeoUtilDrawPointWithAlpha_UINT8 (img, w, y, alpha, color);
      w = w + 1;
    }
    /* Υå */
    pre_y = ellipse (q, k1, k2, k3, x+1, 1);
    old_y = y;    
    if (DOUBLE_TO_INT(pre_y) == y) {
      x = x + 1;
    } else {
      step = (pre_y > y) ? 1 : -1;
      y     = y + step;
      if (((y - DOUBLE_TO_INT(pre_y)) * step + 1) > 0) {
	x = x + 1;
      }
    }
  }

  /* θ */
  x     = DOUBLE_TO_INT (xs);
  y     = DOUBLE_TO_INT (ys) - 1;
  old_y = y + 1;  
  while (x <= DOUBLE_TO_INT(xs + (xe-xs) * 0.5)) {
    /*  */
    TeoUtilDrawPointWithAlpha_UINT8 (img, x, y, alpha, color);
    w = x + 1;
    while (w <= DOUBLE_TO_INT (xs + (xe-xs) * 0.5) &&
	   DOUBLE_TO_INT (ellipse (q, k1, k2, k3, w, -1)) <= y &&
	   y != old_y) {
      TeoUtilDrawPointWithAlpha_UINT8 (img, w, y, alpha, color);
      w = w + 1;
    }
    /* Υå */
    pre_y = ellipse (q, k1, k2, k3, x+1, -1);
    old_y = y;
    if (DOUBLE_TO_INT(pre_y) == y) {
      x = x + 1;
    } else {
      step = (pre_y > y) ? 1 : -1;
      y = y + step;
      if (((y - DOUBLE_TO_INT(pre_y)) * step + 1) > 0) {
	x = x + 1;
      }
    }
  }

  /* θ */    
  x     = DOUBLE_TO_INT (xe);
  y     = DOUBLE_TO_INT (ye);
  old_y = y + 1;  
  while (x >= DOUBLE_TO_INT(xs + (xe-xs) * 0.5)) {
    /*  */
    TeoUtilDrawPointWithAlpha_UINT8 (img, x, y, alpha, color);
    w = x - 1;
    while (w > DOUBLE_TO_INT (xs + (xe-xs) * 0.5) &&
	   DOUBLE_TO_INT (ellipse (q, k1, k2, k3, w, 1)) >= y &&
	   y != old_y) {
      TeoUtilDrawPointWithAlpha_UINT8 (img, w, y, alpha, color);
      w = w - 1;
    }
    /* Υå */
    pre_y = ellipse (q, k1, k2, k3, x-1, 1);
    old_y = y;
    if (DOUBLE_TO_INT(pre_y) == y) {
      x = x - 1;
    } else {
      step = (pre_y > y) ? 1 : -1;
      y = y + step;
      if (((y - DOUBLE_TO_INT(pre_y)) * step + 1) > 0) {
	x = x - 1;
      }
    }
  }

  /* θ */    
  x     = DOUBLE_TO_INT (xe);
  y     = DOUBLE_TO_INT (ye) - 1;
  old_y = y + 1;
  while (x >= DOUBLE_TO_INT(xs + (xe-xs) * 0.5)) {
    /*  */
    TeoUtilDrawPointWithAlpha_UINT8 (img, x, y, alpha, color);
    w = x - 1;
    while (w > DOUBLE_TO_INT (xs + (xe-xs) * 0.5) &&
	   DOUBLE_TO_INT (ellipse (q, k1, k2, k3, w, -1)) <= y &&
	   y != old_y) {
      TeoUtilDrawPointWithAlpha_UINT8 (img, w, y, alpha, color);
      w = w - 1;
    }
    /* Υå */
    pre_y = ellipse (q, k1, k2, k3, x-1, -1);
    old_y = y;
    if (DOUBLE_TO_INT(pre_y) == y) {
      x = x - 1;
    } else {
      step = (pre_y > y) ? 1 : -1;
      y = y + step;
      if (((y - DOUBLE_TO_INT(pre_y)) * step + 1) > 0) {
	x = x - 1;
      }
    }
  }
}

/* ʱߤ ************************************************************** *
 * ʱߤ濴XȾ¡YȾ¡ž()ꤷʱߤ
 * ؿ
 * ************************************************************************* */
void
TeoUtilDrawArc_UINT8 (TEOIMAGE	*img,
		      int	x0,	/* 濴Xɸ */
		      int	y0,	/* 濴Yɸ */
		      int	xl,	/* XȾ */
		      int	yl,	/* YȾ */
		      double	theta,	/* ž() */
		      TEO_UINT8	*color) {
  double	Q[9];
  double	a, b, C, S, C2, S2;

  theta = -theta * M_PI / 180.0;
  C = cos (theta);
  S = sin (theta);
  C2 = C * C;
  S2 = S * S;
  
  a = 1.0 / (xl * xl);
  b = 1.0 / (yl * yl);

  Q[0] = a * C2 + b * S2;
  Q[1] = Q[3] = C * S * (a - b);
  Q[2] = Q[6] =-(Q[0] * x0 + Q[1] * y0);  
  Q[4] = a * S2 + b * C2;
  Q[5] = Q[7] =-(Q[1] * x0 + Q[4] * y0);  
  Q[8] = Q[0] * x0 * x0 + Q[4] * y0 * y0 + 2.0 * Q[1] * x0 * y0 - 1.0;

  _TeoDrawArc_UINT8 (img, Q, color);
}

/* ʱߤ (ɤĤ֤) ************************************************* *
 * ʱߤ濴XȾ¡YȾ¡ž()ꤷʱߤ
 * ؿ
 * ************************************************************************* */
void
TeoUtilDrawFillArc_UINT8 (TEOIMAGE	*img,
			  int		x0,	/* 濴Xɸ */
			  int		y0,	/* 濴Yɸ */
			  int		xl,	/* XȾ */
			  int		yl,	/* YȾ */
			  double	theta,	/* ž() */
			  TEO_UINT8	*color) {
  double	Q[9];
  double	a, b, C, S, C2, S2;

  theta = -theta * M_PI / 180.0;
  C = cos (theta);
  S = sin (theta);
  C2 = C * C;
  S2 = S * S;
  
  a = 1.0 / (xl * xl);
  b = 1.0 / (yl * yl);

  Q[0] = a * C2 + b * S2;
  Q[1] = Q[3] = C * S * (a - b);
  Q[2] = Q[6] =-(Q[0] * x0 + Q[1] * y0);  
  Q[4] = a * S2 + b * C2;
  Q[5] = Q[7] =-(Q[1] * x0 + Q[4] * y0);  
  Q[8] = Q[0] * x0 * x0 + Q[4] * y0 * y0 + 2.0 * Q[1] * x0 * y0 - 1.0;

  _TeoDrawFillArc_UINT8 (img, Q, color);
}

/* ʱߤ (ɤĤ֤+֥ǥ) ******************************** *
 * ʱߤ濴XȾ¡YȾ¡ž()ꤷʱߤ
 * ؿ
 * ************************************************************************* */
void
TeoUtilDrawFillArcWithAlpha_UINT8 (TEOIMAGE		*img,
				   int			x0,
				   int			y0,
				   int			xl,
				   int			yl,
				   double		theta,
				   unsigned char	alpha,
				   TEO_UINT8		*color) {
  double	Q[9];
  double	a, b, C, S, C2, S2;

  theta = -theta * M_PI / 180.0;
  C = cos (theta);
  S = sin (theta);
  C2 = C * C;
  S2 = S * S;
  
  a = 1.0 / (xl * xl);
  b = 1.0 / (yl * yl);

  Q[0] = a * C2 + b * S2;
  Q[1] = Q[3] = C * S * (a - b);
  Q[2] = Q[6] =-(Q[0] * x0 + Q[1] * y0);  
  Q[4] = a * S2 + b * C2;
  Q[5] = Q[7] =-(Q[1] * x0 + Q[4] * y0);  
  Q[8] = Q[0] * x0 * x0 + Q[4] * y0 * y0 + 2.0 * Q[1] * x0 * y0 - 1.0;

  _TeoDrawFillArcWithAlpha_UINT8 (img, Q, alpha, color);
}

/* ************************************************************************* *
 * åԥ󥰤δؿ
 * ************************************************************************* */

/* ֥ǥ ************************************************ */
void __inline__
TeoUtilDrawPointWithAlphaClipping_UINT8 (TEOIMAGE	*img,
					 int		x,
					 int		y,
					 unsigned char	alpha,
					 TEO_UINT8	*color) {
  int		p;
  unsigned char	alpha_;

  alpha_ = 255 - alpha;
  
  if (alpha == 255) {
    if (x < TeoXstart (img) || x > TeoXend (img) ||
	y < TeoYstart (img) || y > TeoYend (img)) return;
    for (p = TeoPlane (img) - 1; p >= 0; p--) {
      TeoPutPixel (img, x, y, p, TEO_UINT8, color[p]);
    }
  } else {
    if (x < TeoXstart (img) || x > TeoXend (img) ||
	y < TeoYstart (img) || y > TeoYend (img)) return;
    for (p = TeoPlane (img) - 1; p >= 0; p--) {
      TeoPutPixel (img, x, y, p, TEO_UINT8,
		   (TEO_UINT8) ((color[p] * alpha / 255) +
				(TeoGetPixel (img, x, y, p, TEO_UINT8)
				 * alpha_ / 255)));
    }
  }
}

/* Ϣľ ********************************************************** */
void
TeoUtilDrawLinesClipping_UINT8 (TEOIMAGE	*img,
				int		*data,
				int		pnum,	      
				TEO_UINT8	*color) {
  int		xs, xe, ys, ye;
  int		n;
  
  xs = data[0];
  ys = data[1];
  for (n = 1; n < pnum; n++) {
    xe = data[n * 2];
    ye = data[n * 2 + 1];
    TeoUtilDrawLineClipping_UINT8 (img, xs, ys, xe, ye, color);
    xs = xe;
    ys = ye;
  }
}

/* ʣľ ********************************************************** */
void
TeoUtilDrawSegmentsClipping_UINT8 (TEOIMAGE	*img,
				   int		*data,
				   int		pnum,
				   TEO_UINT8	*color) {
  int		xs, xe, ys, ye;
  int		n;
  
  for (n = 0; n < pnum; n++) {
    xs = data[n * 4];
    ys = data[n * 4 + 1];
    xe = data[n * 4 + 2];
    ye = data[n * 4 + 3];
    TeoUtilDrawLineClipping_UINT8 (img, xs, ys, xe, ye, color);
  }
}

/* ɤĤ֤ (֥ǥ) ************************************* */
void
TeoUtilDrawFillRectangleWithAlphaClipping_UINT8 (TEOIMAGE	*img,
						 int		x,
						 int		y,
						 int		width,
						 int		height,
						 unsigned char	alpha,
						 TEO_UINT8 	*color) {
  int l,m,ex,ey;
  
  ex=x+width-1;
  if (ex > TeoXend(img)) ex=TeoXend(img);

  ey=y+height-1;
  if (ey > TeoYend(img)) ey=TeoYend(img);

  for (l=y;l<=ey;l++)
    for (m=x;m<=ex;m++)
      TeoUtilDrawPointWithAlphaClipping_UINT8(img,m,l,alpha,color);
  
  return;
}

/* ߤɤĤ֤ (֥ǥ) *************************************** */
void
TeoUtilDrawFillCircleWithAlphaClipping_UINT8 (TEOIMAGE		*img,
					      int		x0,
					      int 		y0,
					      int 		r,
					      unsigned char	alpha,
					      TEO_UINT8 	*color) {
  int	x, y, F, dx;

  x = r;
  y = 0;
  F = -2 * r + 3;

  while (x >= y) {
    for (dx = x; dx > y; dx--) {
      TeoUtilDrawPointWithAlphaClipping_UINT8 (img,
					       x0+dx,   y0+y,   alpha, color);
      TeoUtilDrawPointWithAlphaClipping_UINT8 (img,
					       x0-dx+1, y0+y,   alpha, color);
      TeoUtilDrawPointWithAlphaClipping_UINT8 (img,
					       x0+dx+1, y0-y-1, alpha, color);
      TeoUtilDrawPointWithAlphaClipping_UINT8 (img,
					       x0-dx,   y0-y-1, alpha, color);
      TeoUtilDrawPointWithAlphaClipping_UINT8 (img,
					       x0+y+1,  y0+dx,  alpha, color);
      TeoUtilDrawPointWithAlphaClipping_UINT8 (img,
					       x0+y+1,  y0-dx,  alpha, color);
      TeoUtilDrawPointWithAlphaClipping_UINT8 (img,
					       x0-y,    y0+dx,  alpha, color);
      TeoUtilDrawPointWithAlphaClipping_UINT8 (img,
					       x0-y,    y0-dx,  alpha, color);
    }
    if (F >= 0) {
      x--;
      F -= 4 * x;
    }
    y++;
    F += 4 * y + 2;
  }
}

/* ************************************************************************* *
 * ʱߤؿ
 * ************************************************************************* */

/* ʱߤ ************************************************************** */
static void
_TeoDrawArcClipping_UINT8 (TEOIMAGE	*img,
			   double	*q,
			   TEO_UINT8	*color) {
  double	D, xs, xe, ys, ye, k1, k2, k3, pre_y;
  double	x, y;
  double	e = 1.0e-05;
  int		step;

  k1 = q[1] * q[7] - q[4] * q[2];
  k2 = q[0] * q[4] - q[1] * q[1];
  k3 = q[4] * q[8] - q[5] * q[5];
  D  = k1 * k1  - k2 * k3;
  xs = (k1 - sqrt (D)) / k2;
  xe = (k1 + sqrt (D)) / k2;
  xs += e;
  xe -= e;  
  ys = ellipse (q, k1, k2, k3, xs, 1);
  ye = ellipse (q, k1, k2, k3, xe, 1);

  /* ʱߤ򺸲塤4ĸ̤ʬ䤷褹 */

  /* θ */
  x  = DOUBLE_TO_INT (xs);
  y  = DOUBLE_TO_INT (ys);
  
  while (x <= DOUBLE_TO_INT(xs + (xe-xs) * 0.5)) {
    /*  */
    TeoUtilDrawPointClipping_UINT8 (img, x, y, color);
    /* Υå */
    pre_y = ellipse (q, k1, k2, k3, x+1, 1);
    if (DOUBLE_TO_INT(pre_y) == y) {
      x = x + 1;
    } else {
      step = (pre_y > y) ? 1 : -1;
      y = y + step;
      if (((y - DOUBLE_TO_INT(pre_y)) * step + 1) > 0) {
	x = x + 1;
      }
    }
  }

  /* θ */
  x  = xs;
  y  = ys;
  
  while (x <= DOUBLE_TO_INT(xs + (xe-xs) * 0.5)) {
    /*  */
    TeoUtilDrawPointClipping_UINT8 (img, x, y, color);
    /* Υå */
    pre_y = ellipse (q, k1, k2, k3, x+1, -1);
    if (DOUBLE_TO_INT(pre_y) == y) {
      x = x + 1;
    } else {
      step = (pre_y > y) ? 1 : -1;
      y = y + step;
      if (((y - DOUBLE_TO_INT(pre_y)) * step + 1) > 0) {
	x = x + 1;
      }
    }
  }

  /* θ */    
  x  = xe;
  y  = ye;

  while (x >= DOUBLE_TO_INT(xs + (xe-xs) * 0.5)) {
    /*  */
    TeoUtilDrawPointClipping_UINT8 (img, x, y, color);
    /* Υå */
    pre_y = ellipse (q, k1, k2, k3, x-1, 1);
    if (DOUBLE_TO_INT(pre_y) == y) {
      x = x - 1;
    } else {
      step = (pre_y > y) ? 1 : -1;
      y = y + step;
      if (((y - DOUBLE_TO_INT(pre_y)) * step + 1) > 0) {
	x = x - 1;
      }
    }
  }

  /* θ */    
  x  = xe;
  y  = ye;

  while (x >= DOUBLE_TO_INT(xs + (xe-xs) * 0.5)) {
    /*  */
    TeoUtilDrawPointClipping_UINT8 (img, x, y, color);
    /* Υå */
    pre_y = ellipse (q, k1, k2, k3, x-1, -1);
    if (DOUBLE_TO_INT(pre_y) == y) {
      x = x - 1;
    } else {
      step = (pre_y > y) ? 1 : -1;
      y = y + step;
      if (((y - DOUBLE_TO_INT(pre_y)) * step + 1) > 0) {
	x = x - 1;
      }
    }
  }
}

/* ʱߤ ************************************************************** */
static void
_TeoDrawFillArcClipping_UINT8 (TEOIMAGE		*img,
			       double		*q,
			       TEO_UINT8	*color) {
  double	D, xs, xe, ys, ye, k1, k2, k3, pre_y;
  double	w, x, y;
  double	e = 1.0e-05;
  int		step;

  k1 = q[1] * q[7] - q[4] * q[2];
  k2 = q[0] * q[4] - q[1] * q[1];
  k3 = q[4] * q[8] - q[5] * q[5];
  D  = k1 * k1  - k2 * k3;
  xs = (k1 - sqrt (D)) / k2;
  xe = (k1 + sqrt (D)) / k2;
  xs += e;
  xe -= e;  
  ys = ellipse (q, k1, k2, k3, xs, 1);
  ye = ellipse (q, k1, k2, k3, xe, 1);

  /* ʱߤ򺸲塤4ĸ̤ʬ䤷褹 */

  /* θ */
  x  = DOUBLE_TO_INT (xs);
  y  = DOUBLE_TO_INT (ys);
  
  while (x <= DOUBLE_TO_INT(xs + (xe-xs) * 0.5)) {
    /*  */
    TeoUtilDrawPointClipping_UINT8 (img, x, y, color);
    w = x + 1;
    while (w <= DOUBLE_TO_INT (xs + (xe-xs) * 0.5) &&
	   DOUBLE_TO_INT (ellipse (q, k1, k2, k3, w, 1)) >= y) {
      TeoUtilDrawPointClipping_UINT8 (img, w, y, color);
      w = w + 1;
    }
    /* Υå */
    pre_y = ellipse (q, k1, k2, k3, x+1, 1);
    if (DOUBLE_TO_INT(pre_y) == y) {
      x = x + 1;
    } else {
      step = (pre_y > y) ? 1 : -1;
      y = y + step;
      if (((y - DOUBLE_TO_INT(pre_y)) * step + 1) > 0) {
	x = x + 1;
      }
    }
  }

  /* θ */
  x  = xs;
  y  = ys;
  
  while (x <= DOUBLE_TO_INT(xs + (xe-xs) * 0.5)) {
    /*  */
    TeoUtilDrawPointClipping_UINT8 (img, x, y, color);
    w = x + 1;
    while (w <= DOUBLE_TO_INT (xs + (xe-xs) * 0.5) &&
	   DOUBLE_TO_INT (ellipse (q, k1, k2, k3, w, -1)) <= y ) {
      TeoUtilDrawPointClipping_UINT8 (img, w, y, color);
      w = w + 1;
    }
    /* Υå */
    pre_y = ellipse (q, k1, k2, k3, x+1, -1);
    if (DOUBLE_TO_INT(pre_y) == y) {
      x = x + 1;
    } else {
      step = (pre_y > y) ? 1 : -1;
      y = y + step;
      if (((y - DOUBLE_TO_INT(pre_y)) * step + 1) > 0) {
	x = x + 1;
      }
    }
  }

  /* θ */    
  x  = xe;
  y  = ye;

  while (x >= DOUBLE_TO_INT(xs + (xe-xs) * 0.5)) {
    /*  */
    TeoUtilDrawPointClipping_UINT8 (img, x, y, color);
    w = x - 1;
    while (w >= DOUBLE_TO_INT (xs + (xe-xs) * 0.5) &&
	   DOUBLE_TO_INT (ellipse (q, k1, k2, k3, w, 1)) >= y) {
      TeoUtilDrawPointClipping_UINT8 (img, w, y, color);
      w = w - 1;
    }
    /* Υå */
    pre_y = ellipse (q, k1, k2, k3, x-1, 1);
    if (DOUBLE_TO_INT(pre_y) == y) {
      x = x - 1;
    } else {
      step = (pre_y > y) ? 1 : -1;
      y = y + step;
      if (((y - DOUBLE_TO_INT(pre_y)) * step + 1) > 0) {
	x = x - 1;
      }
    }
  }

  /* θ */    
  x  = DOUBLE_TO_INT (xe);
  y  = DOUBLE_TO_INT (ye);

  while (x >= DOUBLE_TO_INT(xs + (xe-xs) * 0.5)) {
    /*  */
    TeoUtilDrawPointClipping_UINT8 (img, x, y, color);
    w = x - 1;
    while (w >= DOUBLE_TO_INT (xs + (xe-xs) * 0.5) &&
	   DOUBLE_TO_INT (ellipse (q, k1, k2, k3, w, -1)) <= y) {
      TeoUtilDrawPointClipping_UINT8 (img, w, y, color);
      w = w - 1;
    }
    /* Υå */
    pre_y = ellipse (q, k1, k2, k3, x-1, -1);
    if (DOUBLE_TO_INT(pre_y) == y) {
      x = x - 1;
    } else {
      step = (pre_y > y) ? 1 : -1;
      y = y + step;
      if (((y - DOUBLE_TO_INT(pre_y)) * step + 1) > 0) {
	x = x - 1;
      }
    }
  }
}

/* ʱߤ ************************************************************** */
static void
_TeoDrawFillArcWithAlphaClipping_UINT8 (TEOIMAGE	*img,
					double		*q,
					unsigned char	alpha,
					TEO_UINT8	*color) {
  double	D, xs, xe, ys, ye, k1, k2, k3, pre_y;
  double	e = 1.0e-05;
  int		w, x, y, old_y;
  int		step;

  k1 = q[1] * q[7] - q[4] * q[2];
  k2 = q[0] * q[4] - q[1] * q[1];
  k3 = q[4] * q[8] - q[5] * q[5];
  D  = k1 * k1  - k2 * k3;
  xs = (k1 - sqrt (D)) / k2;
  xe = (k1 + sqrt (D)) / k2;
  xs += e;
  xe -= e;  
  ys = ellipse (q, k1, k2, k3, xs, 1);
  ye = ellipse (q, k1, k2, k3, xe, 1);

  /* ʱߤ򺸲塤4ĸ̤ʬ䤷褹 */

  /* θ */
  x     = DOUBLE_TO_INT (xs);
  y     = DOUBLE_TO_INT (ys);
  old_y = y + 1;
  while (x <= DOUBLE_TO_INT(xs + (xe-xs) * 0.5)) {
    /*  */
    TeoUtilDrawPointWithAlphaClipping_UINT8 (img, x, y, alpha, color);
    w = x + 1;
    while (w <= DOUBLE_TO_INT (xs + (xe-xs) * 0.5) &&
	   DOUBLE_TO_INT (ellipse (q, k1, k2, k3, w, 1)) >= y &&
	   y != old_y) {
      TeoUtilDrawPointWithAlphaClipping_UINT8 (img, w, y, alpha, color);
      w = w + 1;
    }
    /* Υå */
    pre_y = ellipse (q, k1, k2, k3, x+1, 1);
    old_y = y;    
    if (DOUBLE_TO_INT(pre_y) == y) {
      x = x + 1;
    } else {
      step = (pre_y > y) ? 1 : -1;
      y     = y + step;
      if (((y - DOUBLE_TO_INT(pre_y)) * step + 1) > 0) {
	x = x + 1;
      }
    }
  }

  /* θ */
  x     = DOUBLE_TO_INT (xs);
  y     = DOUBLE_TO_INT (ys) - 1;
  old_y = y + 1;  
  while (x <= DOUBLE_TO_INT(xs + (xe-xs) * 0.5)) {
    /*  */
    TeoUtilDrawPointWithAlphaClipping_UINT8 (img, x, y, alpha, color);
    w = x + 1;
    while (w <= DOUBLE_TO_INT (xs + (xe-xs) * 0.5) &&
	   DOUBLE_TO_INT (ellipse (q, k1, k2, k3, w, -1)) <= y &&
	   y != old_y) {
      TeoUtilDrawPointWithAlphaClipping_UINT8 (img, w, y, alpha, color);
      w = w + 1;
    }
    /* Υå */
    pre_y = ellipse (q, k1, k2, k3, x+1, -1);
    old_y = y;
    if (DOUBLE_TO_INT(pre_y) == y) {
      x = x + 1;
    } else {
      step = (pre_y > y) ? 1 : -1;
      y = y + step;
      if (((y - DOUBLE_TO_INT(pre_y)) * step + 1) > 0) {
	x = x + 1;
      }
    }
  }

  /* θ */    
  x     = DOUBLE_TO_INT (xe);
  y     = DOUBLE_TO_INT (ye);
  old_y = y + 1;  
  while (x >= DOUBLE_TO_INT(xs + (xe-xs) * 0.5)) {
    /*  */
    TeoUtilDrawPointWithAlphaClipping_UINT8 (img, x, y, alpha, color);
    w = x - 1;
    while (w > DOUBLE_TO_INT (xs + (xe-xs) * 0.5) &&
	   DOUBLE_TO_INT (ellipse (q, k1, k2, k3, w, 1)) >= y &&
	   y != old_y) {
      TeoUtilDrawPointWithAlphaClipping_UINT8 (img, w, y, alpha, color);
      w = w - 1;
    }
    /* Υå */
    pre_y = ellipse (q, k1, k2, k3, x-1, 1);
    old_y = y;
    if (DOUBLE_TO_INT(pre_y) == y) {
      x = x - 1;
    } else {
      step = (pre_y > y) ? 1 : -1;
      y = y + step;
      if (((y - DOUBLE_TO_INT(pre_y)) * step + 1) > 0) {
	x = x - 1;
      }
    }
  }

  /* θ */    
  x     = DOUBLE_TO_INT (xe);
  y     = DOUBLE_TO_INT (ye) - 1;
  old_y = y + 1;
  while (x >= DOUBLE_TO_INT(xs + (xe-xs) * 0.5)) {
    /*  */
    TeoUtilDrawPointWithAlphaClipping_UINT8 (img, x, y, alpha, color);
    w = x - 1;
    while (w > DOUBLE_TO_INT (xs + (xe-xs) * 0.5) &&
	   DOUBLE_TO_INT (ellipse (q, k1, k2, k3, w, -1)) <= y &&
	   y != old_y) {
      TeoUtilDrawPointWithAlphaClipping_UINT8 (img, w, y, alpha, color);
      w = w - 1;
    }
    /* Υå */
    pre_y = ellipse (q, k1, k2, k3, x-1, -1);
    old_y = y;
    if (DOUBLE_TO_INT(pre_y) == y) {
      x = x - 1;
    } else {
      step = (pre_y > y) ? 1 : -1;
      y = y + step;
      if (((y - DOUBLE_TO_INT(pre_y)) * step + 1) > 0) {
	x = x - 1;
      }
    }
  }
}

/* ʱߤ ************************************************************** *
 * ʱߤ濴XȾ¡YȾ¡ž()ꤷʱߤ
 * ؿ
 * ************************************************************************* */
void
TeoUtilDrawArcClipping_UINT8 (TEOIMAGE	*img,
			      int	x0,	/* 濴Xɸ */
			      int	y0,	/* 濴Yɸ */
			      int	xl,	/* XȾ */
			      int	yl,	/* YȾ */
			      double	theta,	/* ž() */
			      TEO_UINT8	*color) {
  double	Q[9];
  double	a, b, C, S, C2, S2;

  theta = -theta * M_PI / 180.0;
  C = cos (theta);
  S = sin (theta);
  C2 = C * C;
  S2 = S * S;
  
  a = 1.0 / (xl * xl);
  b = 1.0 / (yl * yl);

  Q[0] = a * C2 + b * S2;
  Q[1] = Q[3] = C * S * (a - b);
  Q[2] = Q[6] =-(Q[0] * x0 + Q[1] * y0);  
  Q[4] = a * S2 + b * C2;
  Q[5] = Q[7] =-(Q[1] * x0 + Q[4] * y0);  
  Q[8] = Q[0] * x0 * x0 + Q[4] * y0 * y0 + 2.0 * Q[1] * x0 * y0 - 1.0;

  _TeoDrawArcClipping_UINT8 (img, Q, color);
}

/* ʱߤ (ɤĤ֤) ************************************************* *
 * ʱߤ濴XȾ¡YȾ¡ž()ꤷʱߤ
 * ؿ
 * ************************************************************************* */
void
TeoUtilDrawFillArcClipping_UINT8 (TEOIMAGE	*img,
				  int		x0,	/* 濴Xɸ */
				  int		y0,	/* 濴Yɸ */
				  int		xl,	/* XȾ */
				  int		yl,	/* YȾ */
				  double	theta,	/* ž() */
				  TEO_UINT8	*color) {
  double	Q[9];
  double	a, b, C, S, C2, S2;

  theta = -theta * M_PI / 180.0;
  C = cos (theta);
  S = sin (theta);
  C2 = C * C;
  S2 = S * S;
  
  a = 1.0 / (xl * xl);
  b = 1.0 / (yl * yl);

  Q[0] = a * C2 + b * S2;
  Q[1] = Q[3] = C * S * (a - b);
  Q[2] = Q[6] =-(Q[0] * x0 + Q[1] * y0);  
  Q[4] = a * S2 + b * C2;
  Q[5] = Q[7] =-(Q[1] * x0 + Q[4] * y0);  
  Q[8] = Q[0] * x0 * x0 + Q[4] * y0 * y0 + 2.0 * Q[1] * x0 * y0 - 1.0;

  _TeoDrawFillArcClipping_UINT8 (img, Q, color);
}

/* ʱߤ (ɤĤ֤+֥ǥ) ******************************** *
 * ʱߤ濴XȾ¡YȾ¡ž()ꤷʱߤ
 * ؿ
 * ************************************************************************* */
void
TeoUtilDrawFillArcWithAlphaClipping_UINT8 (TEOIMAGE		*img,
					   int			x0,
					   int			y0,
					   int			xl,
					   int			yl,
					   double		theta,
					   unsigned char	alpha,
					   TEO_UINT8		*color) {
  double	Q[9];
  double	a, b, C, S, C2, S2;

  theta = -theta * M_PI / 180.0;
  C = cos (theta);
  S = sin (theta);
  C2 = C * C;
  S2 = S * S;
  
  a = 1.0 / (xl * xl);
  b = 1.0 / (yl * yl);

  Q[0] = a * C2 + b * S2;
  Q[1] = Q[3] = C * S * (a - b);
  Q[2] = Q[6] =-(Q[0] * x0 + Q[1] * y0);  
  Q[4] = a * S2 + b * C2;
  Q[5] = Q[7] =-(Q[1] * x0 + Q[4] * y0);  
  Q[8] = Q[0] * x0 * x0 + Q[4] * y0 * y0 + 2.0 * Q[1] * x0 * y0 - 1.0;

  _TeoDrawFillArcWithAlphaClipping_UINT8 (img, Q, alpha, color);
}

/* ****************************************************** End of draw+.c *** */
