#!/bin/sh

# from AuroraFox, modified for TenFourFox, modified for Tenfourbird

strip_bin="/opt/local/bin/strip"

if [ $# -ne 3 ]
then
	echo "usage:" >&2
	echo "$0 libgcc_dir source_app dest_app" >&2
	exit 1
fi

_pwd="${PWD}"
cd "$1"
libgcc_dir="${PWD}"
cd "${_pwd}"

src_app=$2
dest_app=$3

dest_dir="${dest_app}/Contents"

function exit_err() {
	cnt=$1
	msg=$2
	echo "Error count: ${cnt}" >&2
	echo "${msg}" >&2
	exit $1
}

if [ -e "${dest_app}" ]
then
	exit_err 1 "destination directory already existed: ${dest_app}"
fi

cp -RL "${src_app}" "${dest_app}" || exit
test -e "${dest_dir}" || exit

dylibs="libstdc++.6.dylib libgcc_s.1.dylib"

for dylib in ${dylibs}
do
	ditto -v "${libgcc_dir}/${dylib}" "${dest_dir}/MacOS" || exit
	eval "${strip_bin}" -x "${dest_dir}/MacOS/${dylib}" || exit
	install_name_tool -change "${libgcc_dir}/${dylib}" "@executable_path/${dylib}" \
		-id "@executable_path/${dylib}" \
		"${dest_dir}/MacOS/${dylib}" || exit
done

libgcc_prefix=`otool -L "${dest_dir}/MacOS/XUL" | sed -E -e 's#^[[:space:]]*(/opt/[^/]+/lib/[^/]*gcc[^/]*)/.+$#\1#p' -e d | head -1`

if [ -z "${libgcc_prefix}" ]
then
	exit_err 1 "${src_app} does not use gcc in '/opt/*' "
fi

change_sharelib()
	{
	errcnt=0
	while read file
	do
		libs=`otool -L "${file}" | sed -E -e 's/[[:space:]]+([^[:space:]](.+[^[:space:]])?)[[:space:]]+\([^(]+/\1/p' -e d`
		if [ -z "${libs}" ]
		then
			continue
		fi

		opt_libs=`echo "${libs}" | grep -E -e '^/opt/'`

		if [ -n "${opt_libs}" ]
		then
			echo "file: ${file}"
		else
			continue
		fi

		opt_list="${opt_libs}"
		for dylib in $dylibs
		do
			if [ -n "`echo "${opt_list}" | grep -xF "${libgcc_prefix}/${dylib}"`" ]
			then
				echo "	change: ${libgcc_prefix}/${dylib}"
				install_name_tool -change "${libgcc_prefix}/${dylib}" "@executable_path/${dylib}" "${file}"
				opt_list=`echo "${opt_list}" | grep -vxF "${libgcc_prefix}/${dylib}"`
			fi
		done

		if [ -n "${opt_list}" ]
		then
			errcnt=$(($errcnt + 1))
			echo "error: unknown shared libraries found" >&2 
			echo "	file: ${file}" >&2
			echo "${opt_list}" | sed -E -e 's/.+/	shared_lib: &/p' -e d >&2
			echo >&2
		fi
		echo
	done
	if [ "$errcnt" -ne 0 ]
	then
		echo "Error count: $errcnt" >&2
	fi
	}

find "${dest_dir}" -type f | change_sharelib
