#!/bin/sh

if [ $# -ne 2 ]
then
	echo "Usage:"
	echo "$0 prefix dylib_file"
	exit 1
fi

prefix=$1
file=$2

shared_libs=`otool -L "$file"`

optlocal_libs=`echo "${shared_libs}" | sed -E -e 's#^[[:space:]]+('${prefix}'.+)[[:space:]]+\([^(]+$#\1#p' -e d`

if [ "${#optlocal_libs}" -eq 0 ]
then
	exit
fi

for lib in $optlocal_libs
do
	install_name_tool -change "$lib" "@executable_path/`basename $lib`" "${file}"
done
