// For TenFourFox AltiVec by Cameron Kaiser and Tobias Netzel
// Modified for M682592 (issue 75, issue 109)
// Remember, PPC is normally big endian! Endian Little Hate We! -- Connectix

#include <altivec.h>
#include "nscore.h"
#warning compiled VMX version

namespace mozilla {
namespace VMX {

PRInt32
FirstNon8Bit(const PRUnichar *str, const PRUnichar *end)
{
  const PRUint32 numUnicharsPerVector = 8;
  const PRUint32 numCharsPerVector = 16;
  register vector unsigned short vect;

// This matches native endianness. Don't reverse it.
#if PR_BYTES_PER_WORD == 4
  const size_t mask = 0xff00ff00;
  const PRUint32 alignMask = 0x03;
  const PRUint32 numUnicharsPerWord = 2;
#elif PR_BYTES_PER_WORD == 8
  const size_t mask = 0xff00ff00ff00ff00;
  const PRUint32 alignMask = 0x07;
  const PRUint32 numUnicharsPerWord = 4;
#else
#error Unknown platform!
#endif

  const PRInt32 len = end - str;
  PRInt32 i = 0;

  // Align ourselves to a 16-byte boundary, as required by AltiVec loads.
  PRInt32 alignLen =
    PR_MIN(len, PRInt32(((-NS_PTR_TO_UINT32(str)) & 0xf) / sizeof(PRUnichar)));

if ((len - alignLen) > (numUnicharsPerVector - 1)) {
  for (; i < alignLen; i++) {
    if (str[i] > 255)
      return i;
  }

  register const vector unsigned short gtcompare =
	vec_mergel( vec_splat_s8( 0 ), vec_splat_s8( -1 ) );
  // Check one VMX register (16 bytes) at a time.
  // This is simpler on AltiVec and involves no mucking about with masks,
  // since the vec_any_gt intrinsic does exactly what we want.
  const PRInt32 vectWalkEnd = ((len - i) / numUnicharsPerVector) * numUnicharsPerVector;
  // We use this a lot, so let's calculate it now.
  const PRInt32 vectFactor = (numCharsPerVector/numUnicharsPerVector);
    PRInt32 i2 = i * vectFactor;
    while (1) {
#define CheckForASCII						\
      vect = vec_ld(i2, (unsigned short *)str);			\
      if (vec_any_gt(vect, gtcompare))				\
        return (i2 / vectFactor);                               \
      i2 += numCharsPerVector;					\
      if (!(i2 < vectWalkEnd))					\
        break;
      CheckForASCII
      CheckForASCII
    }
    i = i2 / vectFactor;
  }
  else {
    // Align ourselves to a word boundary.
    alignLen =
      PR_MIN(len, PRInt32(((-NS_PTR_TO_UINT32(str)) & alignMask) / sizeof(PRUnichar)));
    for (; i < alignLen; i++) {
      if (str[i] > 255)
        return i;
    }
  }

  // Check one word at a time.
  const PRInt32 wordWalkEnd = ((len - i) / numUnicharsPerWord) * numUnicharsPerWord;
  for(; i < wordWalkEnd; i += numUnicharsPerWord) {
    const size_t word = *reinterpret_cast<const size_t*>(str + i);
    if (word & mask)
      return i;
  }

  // Take care of the remainder one character at a time.
  for (; i < len; i++) {
    if (str[i] > 255) {
      return i;
    }
  }

  return -1;
}

} // namespace VMX
} // namespace mozilla
