# easyDEBUG output module / copyright(C)2003 SCOPE software design
package spt_debug;
require 5.004;
use strict;
use CGI::Carp qw(carpout fatalsToBrowser);
use Benchmark;
BEGIN{
	use Exporter ();
	use vars qw($VERSION @ISA @EXPORT @EXPORT_OK %EXPORT_TAGS);
	$VERSION='0.10';
	@ISA=qw(Exporter);
	@EXPORT=qw(&SPDBinit &SPDBreset &SPDBclearlog &SPDBsectionrs &SPDBsection &SPDBout &SPDBsig);
	%EXPORT_TAGS=();
	@EXPORT_OK=qw();
}
use vars @EXPORT_OK;
use vars qw($SPDBflag @SPDBlogfl $SPDBcode $SPDBcnt %SPDBscnt @SPDBfcnt $SPDBtime);
use vars qw($SPDBbm1 $SPDBbm2);
$SPDBflag=0;

################ debug:initialize
sub SPDBinit{
	my($v,@fl)=@_;
	$SPDBflag=$v;
	return if!$SPDBflag;
	@SPDBlogfl=@fl;
	$SPDBcode='';
	$SPDBcnt=0;
	undef%SPDBscnt;
	undef@SPDBfcnt;
	$SPDBtime=time;
    $SPDBbm1=new Benchmark;
1}
################ debug:reset
sub SPDBreset{
	return if!$SPDBflag;
	SPDBout(0,"###### RESET! ######")if$SPDBcnt;
	$SPDBcode='';
	$SPDBcnt=0;
	undef%SPDBscnt;
	undef@SPDBfcnt;
1}
################ debug:clear file
sub SPDBclearlog{
	return if!$SPDBflag;
	my($fl);
	$fl="@_";
	return if($fl!~/^(\d+|all)$/);
	return if($fl=~/^\d+$/&&$fl>=scalar@SPDBlogfl);
	if($fl!~/^all$/){open(DBGFH,">$SPDBlogfl[$fl]");close DBGFH}
	else{foreach(@SPDBlogfl){open(DBGFH,">$_");close DBGFH}}
1}
################ debug:move section (with reset)
sub SPDBsectionrs{
	return if!$SPDBflag;
	$SPDBscnt{$_[0]}=0;
	SPDBsection($_[0]);
}
################ debug:move section
sub SPDBsection{
	return if!$SPDBflag;
	my($v,$o)=@_;$SPDBcode=$v;$o="###### SET SECTION-CODE! ######";
	$o="###### CLEAR SECTION-CODE! ######"if$SPDBcode eq'';
#	$o.=' (time: +'.(time-$SPDBtime).'s)';
    $SPDBbm2=new Benchmark;
    $o.=' (time: +'.timestr(timediff($SPDBbm2,$SPDBbm1)).')';
	SPDBout(0,$o);
}
################ debug:message out
sub SPDBout{
	return if!$SPDBflag;
	my($fl,@msg,$m,$h,$d,$o,$y,$p,$c,$lp,$ky,$vl);
	($fl,@msg)=@_;
	($m,$h,$d,$o,$y,$p,$c)=(localtime)[1..6];
	$y+=1900;$o++;
	if($fl=~/\D/||!@msg){@msg=$fl;$fl=0}
	@msg="DEBUG MESSAGE!"if@msg==0;
	$msg[0]=~s/(\x0d\x0a|\x0a|\x0d)//g;
	$msg[0]=substr$msg[0],0,256;
	$c="[$SPDBcode]"if$SPDBcode;
	$p='';
	if(!$SPDBfcnt[$fl]){
		$p="Debug Message..\n";
		$p.=('-'x64)."\n";
		$p.="OS:$^O / ";
		$p.="Perl ver.:$] / ";
		$p.="Process no:$$ / ";
		$p.="User no:$< / ";
		$p.="User grp.:$( \n";
		$lp=0;foreach(@ARGV){$lp++;
			$p.="\$ARGV[$lp] : $_\n";
		}
#inc
#		$lp=0;while(($ky,$vl)=each%INC){$lp++;
#			$p.="include $lp : $ky [$vl]";
#			$p.=' *'if($ky=~/\.pm$/);
#			$p.="\n";
#		}
#env
#		$lp=0;while(($ky,$vl)=each%ENV){$lp++;
#			$vl=~s/</&lt;/g;$vl=~s/>/&gt;/g;$vl=~s/\n//g;
#			$p.="ENV $lp : $ky [$vl]\n";
#		}
		$p.='-'x64;
		$p.="\nLOGGING START($y/$o/$d $h:$m)..\n Tot-Fl-Se\n"
	}
	$p.=sprintf("(%03d-%02d-%02d)",$SPDBcnt+1,$SPDBfcnt[$fl]+1,$SPDBscnt{$SPDBcode}+1);
	if(!$SPDBscnt{$SPDBcode}){$p.="*"}else{$p.=" "}
	$p.="$c\"".(join',',@msg)."\"\n";
	if(open(DBGFH,">>$SPDBlogfl[$fl]")){print DBGFH$p;close DBGFH}
	$SPDBcnt++;$SPDBscnt{$SPDBcode}++;$SPDBfcnt[$fl]++;
1}
################ debug:signal
sub SPDBsig{&SPDBout('<b>[SIGNAL] **************** '.($_[0]).' ****************</b>')}
1;