/*
 *   ----  ץƥȥ٥ ---- 
 * 
 *     
 * 
 *   $Revision: 1.4 $
 *   $Date: 2002/04/08 04:31:34 $
 */

`timescale 100ps/10ps

module top;

reg          HCLK ;
reg          HRESETn ;

wire  [1:0]  HTRANS ;
wire         HREADY ;
wire         HREADYo ;
wire         HWRITE ;
wire  [1:0]  HRESP ;
wire  [2:0]  HSIZE ;
wire  [31:0] HADDR ;
wire  [31:0] HWDATA ;
wire  [2:0]  HBURST ;
wire  [31:0] HRDATA ;
wire         HSEL ;

parameter CLK = 10000 ;

  // ----- clock & reset generater -----
  initial begin
     HCLK    <= 0 ;
     HRESETn <= 0 ;
     #(CLK*10) HRESETn <= 1 ;
  end
  always #(CLK/2) HCLK <= ~HCLK ;

  // ----- call tbvMain -----
  initial 
    begin
      #0 $tbv_main();
    end

  // ----- hready & hsel -----
  assign HREADY = HREADYo ;
  assign HSEL   = 1'b1 ;        // DUV˥쥯

  // ----- connect AMBA MASTER -----
  AmbaTvmT tvmInstance1( 
         .HCLK(   HCLK       ),     // in
         .HRDATA( HRDATA     ),     // in
         .HREADY( HREADY     ),     // in
         .HRESP(  HRESP      ),     // in
         .HRESET( HRESETn    ),     // in
         .HTRANS( HTRANS     ),     // out
         .HWRITE( HWRITE     ),     // out
         .HSIZE(  HSIZE      ),     // out
         .HADDR(  HADDR      ),     // out
         .HWDATA( HWDATA     ),     // out
         .HBURST( HBURST     )      // out
  )  ;


  // ----  DDDDD     D     D    D     D  ------
  // ----  D    D    D     D    D     D  ------
  // ----  D    D    D     D     D   D   ------
  // ----  D    D    D     D      D D    ------
  // ----  DDDDD      DDDDD        D     ------

  DUV DUV1( 
         .HCLK(   HCLK       ),     // in
         .HRDATA( HRDATA     ),     // in
         .HSEL(   HSEL       ),     // in
         .HRESP(  HRESP      ),     // in
         .HRESETn( HRESETn   ),     // in
         .HREADY( HREADY     ),     // in
         .HREADYo( HREADYo   ),     // out
         .HTRANS( HTRANS     ),     // out
         .HWRITE( HWRITE     ),     // out
         .HSIZE(  HSIZE      ),     // out
         .HADDR(  HADDR      ),     // out
         .HWDATA( HWDATA     ),     // out
         .HBURST( HBURST     )      // out
  )  ;

  // ------ END of DUV --------

endmodule     // end of main module //


////////////////////////////////////////////////
//////////////   AMBA MASTER Tvm ///////////////
////////////////////////////////////////////////
  
module AmbaTvmT( 
       HCLK,            // in
       HRDATA,          // in
       HREADY,          // in
       HRESET,          // in
       HRESP,           // in
       HTRANS,          // out
       HWRITE,          // out
       HSIZE,           // out
       HADDR,           // out
       HWDATA,          // out
       HBURST           // out
                ) ;

   input          HCLK   ;
   input [31:0]   HRDATA ;
   input          HREADY ;
   input          HRESET ;
   input [1:0]    HRESP ;

   output         HWRITE ;          // out
   output [2:0]   HSIZE ;           // out
   output [31:0]  HADDR ;           // out
   output [31:0]  HWDATA ;          // out
   output [2:0]   HBURST ;          // out
   output [1:0]   HTRANS ;          // out

   wire [1:0]   HRESP ;

   reg [1:0]    HTRANS ;          // out
   reg          HWRITE ;          // out
   reg [2:0]    HSIZE ;           // out
   reg [31:0]   HADDR ;           // out
   reg [31:0]   HWDATA ;          // out
   reg [2:0]    HBURST ;    // out

   // register every instance of this TVM to test builder.
   initial $tbv_tvm_connect;

endmodule


////////////////////////////////////////////////
////////////////// Sample DUV //////////////////
////////////////////////////////////////////////
  
module DUV( 
       HCLK,            // in
       HRESETn,         // in
       HWRITE,          // in
       HTRANS,          // in
       HSIZE,           // in
       HADDR,           // in
       HWDATA,          // in
       HBURST,          // in
       HSEL,            // in
       HREADY,          // in
       HREADYo,         // out
       HRESP,           // out
       HRDATA,          // out
                ) ;

   input         HCLK   ;         // in
   input         HRESETn ;        // in

   input         HSEL   ;          // in
   input [1:0]   HTRANS ;          // in
   input         HWRITE ;          // in
   input [2:0]   HSIZE ;           // in
   input [31:0]  HADDR ;           // in
   input [31:0]  HWDATA ;          // in
   input [2:0]   HBURST ;          // in
   input         HREADY ;          // in

   output [31:0] HRDATA ;          // out
   output        HREADYo ;         // out
   output [1:0]  HRESP ;           // out

   reg    [1:0]  HRESP ;
   reg           HREADYo ;         // out
   reg  [31:0]   HRDATA ;          // out

   wire          HSEL ;            // in
   wire          HREADY ;          // in
   wire [1:0]    HTRANS ;          // in
   wire          HWRITE ;          // in
   wire [2:0]    HSIZE ;           // in
   wire [31:0]   HADDR ;           // in
   wire [31:0]   HWDATA ;          // in
   wire [2:0]    HBURST ;          // in

   // register array
   reg  [31:0]   mem[0:16777215] ;
   reg  [31:0]   bufhaddr ;
   reg           bufhwrite ;

   // main state
   always @( posedge HCLK or negedge HRESETn ) begin
     if ( ~HRESETn ) begin
        HRDATA    <= 0 ;
        HRESP     <= 0 ;
        HREADYo   <= 1'b1 ;
        bufhaddr  <= 0 ;
        bufhwrite <= 0 ;
     end
     else if ( HREADY & HSEL ) begin
        if ( bufhwrite ) begin
           mem[HADDR[23:0]] <= HWDATA ;
        end
        else begin
           HRDATA <= mem[HADDR[23:0]] ;
        end
        bufhwrite <= HWRITE ;
        bufhaddr  <= HADDR ;
     end
   end

endmodule  // end of sample duv //

