/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.tatooine.gtx;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import jp.sf.tatooine.gtx.GtxTemplate;
import jp.sf.tatooine.gtx.node.Attribute;
import jp.sf.tatooine.gtx.node.CommentNode;
import jp.sf.tatooine.gtx.node.DTDNode;
import jp.sf.tatooine.gtx.node.ElementNode;
import jp.sf.tatooine.gtx.node.GtxAttribute;
import jp.sf.tatooine.gtx.node.GtxAttributeType;
import jp.sf.tatooine.gtx.node.GtxFor;
import jp.sf.tatooine.gtx.node.GtxIf;
import jp.sf.tatooine.gtx.node.GtxIgnore;
import jp.sf.tatooine.gtx.node.GtxInnerText;
import jp.sf.tatooine.gtx.node.GtxNull;
import jp.sf.tatooine.gtx.node.GtxUnless;
import jp.sf.tatooine.gtx.node.Namespace;
import jp.sf.tatooine.gtx.node.Node;
import jp.sf.tatooine.gtx.node.ProcessingInstructionNode;
import jp.sf.tatooine.gtx.node.TextNode;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DefaultHandler2;

public class GtxTemplateHandler
extends DefaultHandler2 {
    private GtxTemplate _gtxTemplate;
    private String _gtxPrefix;
    private boolean _ignoreSpace = false;
    private boolean _ignoreComment = false;
    private List<Node> _topLevelList = new ArrayList<Node>();
    private Stack<ElementNode> _elementStack = new Stack();
    private List<Namespace> _namespaceList = new ArrayList<Namespace>();
    private boolean _DTDprocessed = false;

    public GtxTemplate getGtxTemplate() {
        return this._gtxTemplate;
    }

    public void setIgnoreComment(boolean ignoreComment) {
        this._ignoreComment = ignoreComment;
    }

    public void setIgnoreSpace(boolean ignoreSpace) {
        this._ignoreSpace = ignoreSpace;
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this._DTDprocessed || this._ignoreComment) {
            return;
        }
        String value = new String(ch, start, length);
        if (this._ignoreSpace) {
            value = value.trim();
        }
        CommentNode commentNode = new CommentNode();
        if (this._elementStack.isEmpty()) {
            this._topLevelList.add(commentNode);
        } else {
            this._elementStack.peek().appendChild(commentNode);
        }
        commentNode.setValue(value);
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        DTDNode node = new DTDNode(name, publicId, systemId);
        this._topLevelList.add(node);
        this._DTDprocessed = true;
    }

    public void endDTD() throws SAXException {
        this._DTDprocessed = false;
    }

    public void startDocument() throws SAXException {
        this._gtxTemplate = new GtxTemplate();
        this._gtxTemplate.setTopLevelList(this._topLevelList);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        ProcessingInstructionNode node = new ProcessingInstructionNode(target, StringUtils.trimToEmpty(data));
        if (this._elementStack.isEmpty()) {
            this._topLevelList.add(node);
        } else {
            this._elementStack.peek().appendChild(node);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        Namespace namespace = new Namespace(prefix, uri);
        this._namespaceList.add(namespace);
        if ("http://tatooine.sourceforge.jp/ns/gtx".equals(uri)) {
            this._gtxPrefix = prefix;
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (this._gtxPrefix != null && this._gtxPrefix.equals(prefix)) {
            this._gtxPrefix = null;
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        ElementNode elementNode = new ElementNode(qName);
        if (this._elementStack.isEmpty()) {
            this._topLevelList.add(elementNode);
        } else {
            this._elementStack.peek().appendChild(elementNode);
        }
        for (Namespace namespace : this._namespaceList) {
            elementNode.addAttribute(namespace);
        }
        this._namespaceList.clear();
        String value = null;
        try {
            GtxAttribute attr;
            value = attributes.getValue("http://tatooine.sourceforge.jp/ns/gtx", "ignore");
            if (value != null) {
                attr = new GtxIgnore(this._gtxPrefix, value);
                elementNode.addGtxAttribute(attr);
            }
            if ((value = attributes.getValue("http://tatooine.sourceforge.jp/ns/gtx", "if")) != null) {
                attr = new GtxIf(this._gtxPrefix, value);
                elementNode.addGtxAttribute(attr);
            }
            if ((value = attributes.getValue("http://tatooine.sourceforge.jp/ns/gtx", "unless")) != null) {
                attr = new GtxUnless(this._gtxPrefix, value);
                elementNode.addGtxAttribute(attr);
            }
            if ((value = attributes.getValue("http://tatooine.sourceforge.jp/ns/gtx", "for")) != null) {
                String step;
                String inside;
                attr = new GtxFor(this._gtxPrefix, value);
                String index = attributes.getValue("http://tatooine.sourceforge.jp/ns/gtx", "index");
                if (index != null) {
                    ((GtxFor)attr).setIndex(index);
                }
                if ((inside = attributes.getValue("http://tatooine.sourceforge.jp/ns/gtx", "inside")) != null) {
                    ((GtxFor)attr).setInside(inside);
                }
                if ((step = attributes.getValue("http://tatooine.sourceforge.jp/ns/gtx", "step")) != null) {
                    ((GtxFor)attr).setStep(step);
                }
                elementNode.addGtxAttribute(attr);
            }
            if ((value = attributes.getValue("http://tatooine.sourceforge.jp/ns/gtx", "inner-text")) != null) {
                attr = new GtxInnerText(this._gtxPrefix, value);
                elementNode.addGtxAttribute(attr);
            }
            if ((value = attributes.getValue("http://tatooine.sourceforge.jp/ns/gtx", "null")) != null) {
                attr = new GtxNull(this._gtxPrefix, value);
                elementNode.addGtxAttribute(attr);
            }
        }
        catch (Exception e) {
            throw new SAXException(e.getMessage());
        }
        int i = 0;
        while (i < attributes.getLength()) {
            if (!"http://tatooine.sourceforge.jp/ns/gtx".equals(attributes.getURI(i))) {
                Attribute attr = new Attribute(GtxAttributeType.NA, attributes.getQName(i), attributes.getValue(i));
                elementNode.addAttribute(attr);
            }
            ++i;
        }
        this._elementStack.push(elementNode);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this._elementStack.pop();
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (!this._ignoreSpace) {
            this._processTextNode(ch, start, length);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this._processTextNode(ch, start, length);
    }

    private void _processTextNode(char[] ch, int start, int length) throws SAXException {
        String text = new String(ch, start, length);
        if (this._ignoreSpace) {
            text = text.trim();
        }
        TextNode textNode = new TextNode();
        textNode.setParent(this._elementStack.peek());
        textNode.setValue(text);
        this._elementStack.peek().appendChild(textNode);
    }

    public void warning(SAXParseException e) {
        throw new RuntimeException(String.format("\u8b66\u544a: %s %s\u884c\u76ee\n%s", "", e.getLineNumber(), e.getMessage()));
    }

    public void error(SAXParseException e) {
        throw new RuntimeException(String.format("\u30a8\u30e9\u30fc: %s %s\u884c\u76ee\n%s", "", e.getLineNumber(), e.getMessage()));
    }

    public void fatalError(SAXParseException e) {
        throw new RuntimeException(String.format("\u6df1\u523b\u306a\u30a8\u30e9\u30fc: %s %s\u884c\u76ee\n%s", "", e.getLineNumber(), e.getMessage()));
    }
}

