/* 
 * Copyright 2007 Tatooine Project <http://tatooine.sourceforge.jp/> 
 *  
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *  
 *     http://www.apache.org/licenses/LICENSE-2.0
 *  
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.tatooine.gtx.node;

import jp.sf.tatooine.gtx.GtxConsts;

/**
 * for命令.
 *
 * @author  Tooru Noda
 * @version 1.0 2007/09/07
 * @since   JDK5.0 Tiger
 */
public class GtxFor extends GtxAttribute {
	
	private static final String NS_SEPARATOR = ":";
	
	private static final String ATTR_SEPARATOR = " ";

	/** インデックス名 */
	private String _index;
	
	/** 刻み値 */
	private String _step = "1";
	
	/** inside命令の有無 */
	private String _inside = "false";
	
	/**
	 * コンストラクタ.
	 * 
	 * @param prefix	名前空間プレフィックス
	 * @param value		属性値
	 */
	public GtxFor(String prefix, String value) {
		super(GtxAttributeType.FOR, prefix, GtxConsts.FOR, value);
	}

	/**
	 * index命令値を取得する.
	 * 
	 * @return	index命令値
	 */
	public String getIndex() {
		return _index;
	}

	/**
	 * index命令値を設定する.
	 * 
	 * @param index		index命令値
	 */
	public void setIndex(String index) {
		_index = index;
	}

	/**
	 * inside命令値を取得する.
	 * 
	 * @return	inside命令値
	 */
	public String getInside() {
		return _inside;
	}

	/**
	 * inside命令値を設定する.
	 * 
	 * @param inside	inside命令値
	 */
	public void setInside(String inside) {
		_inside = inside;
	}

	/**
	 * step命令値を取得する.
	 * 
	 * @return	step命令値
	 */
	public String getStep() {
		return _step;
	}

	/**
	 * step命令値を設定する.
	 * 
	 * @param step	step命令値
	 */
	public void setStep(String step) {
		_step = step;
	}

	/**
	 * @see jp.sf.tatooine.gtx.node.Attribute#toString()
	 */
	@Override
	public String toString() {
		
		StringBuilder builder = new StringBuilder();
		builder.append(super.toString());
		if (_index != null) {
			builder.append(ATTR_SEPARATOR);
			builder.append(super.getPrefix());
			builder.append(NS_SEPARATOR);
			builder.append(GtxConsts.INDEX);
			builder.append(VALUE_PREFIX);
			builder.append(_index);
			builder.append(VALUE_POSTFIX);
		}
		if (_step != null) {
			builder.append(ATTR_SEPARATOR);
			builder.append(super.getPrefix());
			builder.append(NS_SEPARATOR);
			builder.append(GtxConsts.STEP);
			builder.append(VALUE_PREFIX);
			builder.append(_step);
			builder.append(VALUE_POSTFIX);
		}
		if (_inside != null) {
			builder.append(ATTR_SEPARATOR);
			builder.append(super.getPrefix());
			builder.append(NS_SEPARATOR);
			builder.append(GtxConsts.INSIDE);
			builder.append(VALUE_PREFIX);
			builder.append(_inside);
			builder.append(VALUE_POSTFIX);
		}
		return builder.toString();
	}
	
}
