/* 
 * Copyright 2007 Tatooine Project <http://tatooine.sourceforge.jp/> 
 *  
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *  
 *     http://www.apache.org/licenses/LICENSE-2.0
 *  
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.tatooine.gtx.filter;

import java.math.BigDecimal;
import java.math.RoundingMode;

import org.apache.commons.lang.ArrayUtils;

import jp.sf.tatooine.gtx.Filter;

/**
 * Floor.
 *
 * @author  Tooru Noda
 * @version 1.0 2007/08/10
 * @since   JDK5.0 Tiger
 */
public class Floor implements Filter {

	/**
	 * @see jp.sf.tatooine.gtx.Filter#invoke(java.lang.String, java.lang.String[])
	 */
	public String invoke(String value, String[] args) {
		
		int len = 0;
		if (args != null) {
			if (args.length > 1) {
				throw new IllegalArgumentException("引数が合致しません。floor([pos]):" + ArrayUtils.toString(args));
			}
			len = Integer.parseInt(args[0]);
			if (len < 0) {
				throw new IllegalArgumentException("floor([pos]): 第一引数は整数を指定してください。: " + args[0]);
			}
		}
		BigDecimal dec = new BigDecimal(value);
		dec = dec.setScale(len, RoundingMode.FLOOR);
		return dec.toString();
	}

}
