/* 
 * Copyright 2007 Tatooine Project <http://tatooine.sourceforge.jp/> 
 *  
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *  
 *     http://www.apache.org/licenses/LICENSE-2.0
 *  
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.tatooine.gtx;

//import static org.junit.Assert.*;

import java.io.File;
import java.io.FileInputStream;

import jp.sf.tatooine.gtx.GtxContext;
import jp.sf.tatooine.gtx.GtxParser;
import jp.sf.tatooine.gtx.GtxTemplate;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/**
 * GtxTemplateTest.
 *
 * @author  Tooru Noda
 * @version 1.0 2007/09/08
 * @since   JDK5.0 Tiger
 */
public class GtxTemplateTest {
	
	private FileInputStream _in = null;

	@Before
	public void setUp() throws Exception {
		_in = new FileInputStream(new File("src/test/resources/test_n.xml"));
	}

	@After
	public void tearDown() throws Exception {
		if (_in != null) {
			_in.close();
		}
	}

	@Test
	public void testExecute2() throws Exception {
		
//		System.out.println(new File(".").getAbsolutePath());
		
		GtxContext context = new GtxContext();
		context.put("sampleString", "abcdefg");
		
		Tag txt1 = new Tag("input");
		txt1.setAttribute("value", "1111");
		context.bindById("txt1", txt1);
		
		Tag txt2 = new Tag("input");
		txt2.setAttribute("value", "2222");
		context.bindById("txt2", txt2);
		
		Tag txt3 = new Tag("input");
		txt3.setAttribute("value", "3333");
		context.bindById("txt3", txt3);
		
		Tag txt4 = new Tag("input");
		txt4.setAttribute("value", "4444");
		context.bindById("txt4", txt4);
		
		Tag txt5 = new Tag("input");
		txt5.setAttribute("value", "5555");
		context.bindById("txt5", txt5);
		
		GtxParser parser = new GtxParser();
//		parser.setIgnoreSpace(true);
//		parser.setIgnoreComment(true);
		
		GtxTemplate template = parser.parse(_in);
		for (int i = 0; i < 1; i++) {
			StringBuilder builder = new StringBuilder();
			template.evaluate(System.out, context);
			System.out.println(builder.toString());
		}
	}

	/**
	 * {@link jp.sf.tatooine.gtx.node.GtxParser2#parse(java.io.InputStream, 
	 * 		jp.sf.tatooine.gtx.GtxContext)} のためのテスト・メソッド。
	 */
//	@Test
	public void testCompile() throws Exception {
		
		GtxContext context = new GtxContext();
		context.put("sampleString", "abcdefg");
		
		GtxParser parser = new GtxParser();
		
		GtxTemplate template = parser.parse(_in);
		for (int i = 0; i < 10; i++) {
			System.out.println(template.toString());
		}
	}

//	@Test
	public void testPrint() throws Exception {
		
		GtxContext context = new GtxContext();
		context.put("sampleString", "abcdefg");
		
		GtxParser parser = new GtxParser();
		
		GtxTemplate template = parser.parse(_in);
		for (int i = 0; i < 10; i++) {
			template.evaluate(System.out, context);
		}
	}
	
}
