/* 
 * Copyright 2007 Tatooine Project <http://tatooine.sourceforge.jp/> 
 *  
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *  
 *     http://www.apache.org/licenses/LICENSE-2.0
 *  
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.tatooine.gtx;

import java.util.HashMap;
import java.util.Map;

/**
 * Tag.
 *
 * @author  Tooru Noda
 * @version 1.0 2007/08/17
 * @since   JDK5.0 Tiger
 */
public class Tag {
	
	private static final long serialVersionUID = 1L;

	/** タグ名 */
	private String _tagName;
	
	/** 属性マップ */
	private Map<String, String> _attributeMap = new HashMap<String, String>();
	
	private Tag() { }
	
	/**
	 * コンストラクタ.
	 * 
	 * @param tagName	タグ名
	 */
	public Tag(String tagName) {
		_tagName = tagName;
	}
	
	/**
	 * 属性値を設定する.
	 * 
	 * @param name		属性名
	 * @param value		属性値
	 */
	public void setAttribute(String name, String value) {
		_attributeMap.put(name, value);
	}
	
	/**
	 * 属性値を取得する.
	 * 
	 * @param name	属性名
	 * @return		属性値
	 */
	public String getAttribute(String name) {
		return _attributeMap.get(name);
	}
	
	/**
	 * 属性を削除する.
	 * 
	 * @param name	属性名
	 */
	public void removeAttribute(String name) {
		_attributeMap.remove(name);
	}
	
	/**
	 * タグ名を取得する.
	 * 
	 * @return	タグ名
	 */
	public String getTagName() {
		return _tagName;
	}
	
	public Map<String, String> getRawMap() {
		return _attributeMap;
	}
}
